/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.run.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.run.filters.FileFilter;

@Immutable
public class DisjunctiveFileFilter
implements FileFilter {
    private static final long serialVersionUID = -8633795907869651250L;
    private final Collection<FileFilter> fileFilters;

    public DisjunctiveFileFilter(Collection<FileFilter> fileFilters) {
        Preconditions.checkNotNull(fileFilters);
        this.fileFilters = ImmutableList.copyOf(fileFilters);
    }

    @Override
    public boolean isFileMatched(FileAtRelativePath file) {
        Preconditions.checkNotNull(file);
        for (FileFilter fileFilter : this.fileFilters) {
            if (!fileFilter.isFileMatched(file)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public Collection<FileFilter> getFileFilters() {
        return this.fileFilters;
    }

    public int hashCode() {
        return this.fileFilters.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DisjunctiveFileFilter)) {
            return false;
        }
        DisjunctiveFileFilter that = (DisjunctiveFileFilter)other;
        return this.fileFilters.equals(that.fileFilters);
    }
}

