/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.run.filters;

import com.google.common.base.Preconditions;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.run.filters.FileFilter;

@Immutable
public class PatternFileFilter
implements FileFilter {
    private static final long serialVersionUID = 6132979932639445297L;
    private transient PathMatcher matcher;
    private final String pattern;

    private PatternFileFilter(String pattern) {
        this.pattern = Preconditions.checkNotNull(pattern);
        this.getMatcher();
    }

    public static PatternFileFilter forRegexp(String regexp) {
        return new PatternFileFilter("regexp:" + regexp);
    }

    public static PatternFileFilter forWildcardPattern(String pattern) {
        return new PatternFileFilter("glob:" + pattern);
    }

    @Override
    public boolean isFileMatched(FileAtRelativePath fileAtRelativePath) {
        return this.getMatcher().matches(Paths.get(fileAtRelativePath.getRelativePathString(), new String[0]));
    }

    private PathMatcher getMatcher() {
        Preconditions.checkState(this.pattern != null);
        if (this.matcher == null) {
            this.matcher = FileSystems.getDefault().getPathMatcher(this.pattern);
        }
        return this.matcher;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.pattern + "]";
    }
}

