/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.units.energy;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Energy
implements Serializable {
    private static final long serialVersionUID = 3L;
    private final long milliJoule;

    private Energy(long milliJoule) {
        Preconditions.checkArgument(milliJoule >= 0L, "Energy must be >0, but is %s", milliJoule);
        this.milliJoule = milliJoule;
    }

    public static Energy milliJoule(long milliJoule) {
        return new Energy(milliJoule);
    }

    public static Energy joule(long joule) {
        return Energy.milliJoule(joule);
    }

    public static Energy kiloJoule(long kiloJoule) {
        return Energy.joule(kiloJoule * 1000L);
    }

    public static Energy milliWattSecond(long milliWattSecond) {
        return Energy.joule(milliWattSecond);
    }

    public static Energy wattSecond(long wattSecond) {
        return Energy.joule(wattSecond);
    }

    public static Energy wattHour(long wattHour) {
        return Energy.joule(3600L * wattHour);
    }

    public long toMilliJoule() {
        return this.milliJoule;
    }

    public long toJoule() {
        return this.toMilliJoule() / 1000L;
    }

    public long toKiloJoule() {
        return this.toJoule() / 1000L;
    }

    public String toString() {
        return this.toJoule() + " J";
    }
}

