/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.units.frequency;

import java.io.Serializable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Frequency
implements Comparable<Frequency>,
Serializable {
    private static final int FACTOR = 1000;
    private static final long serialVersionUID = 753985835437466482L;
    private final long frequency;

    public static Frequency inHz(long frequency) {
        return new Frequency(frequency);
    }

    public static Frequency inKHz(long frequency) {
        return new Frequency(frequency * 1000L);
    }

    public static Frequency inMHz(double frequency) {
        return new Frequency((long)(frequency * 1000.0 * 1000.0));
    }

    public static Frequency inGHz(double frequency) {
        return new Frequency((long)(frequency * 1000.0 * 1000.0 * 1000.0));
    }

    public long toHz() {
        return this.frequency;
    }

    public long toKHz() {
        return this.toHz() / 1000L;
    }

    public long toMHz() {
        return this.toKHz() / 1000L;
    }

    public long toGHz() {
        return this.toMHz() / 1000L;
    }

    private Frequency(long frequency) {
        this.frequency = frequency;
    }

    @Override
    public int compareTo(Frequency other) {
        return Long.compare(this.frequency, other.frequency);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Frequency) {
            Frequency other = (Frequency)obj;
            return this.frequency == other.frequency;
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.frequency).hashCode();
    }

    public String toString() {
        String unit;
        float floating;
        long full;
        if (this.frequency >= 1000000000L) {
            full = this.toGHz();
            floating = (float)this.toMHz() / 1000.0f;
            unit = "GHz";
        } else if (this.frequency >= 1000000L) {
            full = this.toMHz();
            floating = (float)this.toKHz() / 1000.0f;
            unit = "MHz";
        } else if (this.frequency >= 1000L) {
            full = this.toKHz();
            floating = (float)this.toHz() / 1000.0f;
            unit = "kHz";
        } else {
            return this.toHz() + " Hz";
        }
        if (full >= 10L) {
            return full + " " + unit;
        }
        return String.format("%.1f %s", Float.valueOf(floating), unit);
    }
}

