/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.units.memory;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToMemoryUnitFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;

@Immutable
public abstract class MemoryUnit
implements Comparable<MemoryUnit>,
Serializable {
    private static final long serialVersionUID = 3L;
    public static final int MULTIPLICATION_FACTOR = 1000;
    public static final int MULTIPLICATION_FACTOR_BASE2 = 1024;

    public static MemoryUnit zero() {
        return new IntegerMemoryUnit(0);
    }

    public static MemoryUnit bytes(long bytecount) {
        Preconditions.checkArgument(bytecount >= 0L, "MemoryUnit with negative value %s not allowed.", bytecount);
        if (bytecount <= Integer.MAX_VALUE) {
            return new IntegerMemoryUnit((int)bytecount);
        }
        return new LongMemoryUnit(bytecount);
    }

    public static MemoryUnit kibibyte(long kilobyte) {
        return MemoryUnit.bytes(kilobyte * 1024L);
    }

    public static MemoryUnit kilobyte(long kilobyte) {
        return MemoryUnit.bytes(kilobyte * 1000L);
    }

    public static MemoryUnit megabyte(long megabyte) {
        return MemoryUnit.kilobyte(megabyte * 1000L);
    }

    public static MemoryUnit gigabyte(long gigabyte) {
        return MemoryUnit.megabyte(gigabyte * 1000L);
    }

    public static MemoryUnit fromString(String input) {
        try {
            return new StringToMemoryUnitFunction().fromString(input);
        }
        catch (InvalidOptionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public abstract long toByte();

    public long toKilobyte() {
        return this.toByte() / 1000L;
    }

    public long toMegabyte() {
        return this.toKilobyte() / 1000L;
    }

    public long toGigabyte() {
        return this.toMegabyte() / 1000L;
    }

    public long toKibibyte() {
        return this.toByte() / 1024L;
    }

    public long toMibibyte() {
        return this.toKibibyte() / 1024L;
    }

    public long toGibibyte() {
        return this.toMibibyte() / 1024L;
    }

    public static MemoryUnit sum(MemoryUnit m1, MemoryUnit m2) {
        return MemoryUnit.bytes(m1.toByte() + m2.toByte());
    }

    public static MemoryUnit sum(MemoryUnit m1, MemoryUnit m2, MemoryUnit m3) {
        return MemoryUnit.bytes(m1.toByte() + m2.toByte() + m3.toByte());
    }

    public static MemoryUnit sum(Iterable<MemoryUnit> memoryInstances) {
        long sumOfBytes = 0L;
        for (MemoryUnit mem : memoryInstances) {
            sumOfBytes += mem.toByte();
        }
        return MemoryUnit.bytes(sumOfBytes);
    }

    public boolean isGreaterEqualThan(MemoryUnit other) {
        return this.toByte() >= other.toByte();
    }

    public boolean isGreaterThan(MemoryUnit other) {
        return this.toByte() > other.toByte();
    }

    public boolean isZero() {
        return this.toByte() == 0L;
    }

    public MemoryUnit minus(MemoryUnit memoryUnit) throws ArithmeticException {
        long result = this.toByte() - memoryUnit.toByte();
        if (result < 0L) {
            throw new ArithmeticException(this + " - " + memoryUnit);
        }
        return MemoryUnit.bytes(result);
    }

    public static MemoryUnit min(MemoryUnit m1, MemoryUnit m2) {
        return m1.toByte() > m2.toByte() ? m2 : m1;
    }

    public static MemoryUnit max(MemoryUnit m1, MemoryUnit m2) {
        return m1.toByte() < m2.toByte() ? m2 : m1;
    }

    public String toStringBase10() {
        String unit;
        float floating;
        long full;
        if (this.toGigabyte() > 0L) {
            full = this.toGigabyte();
            floating = (float)this.toMegabyte() / 1000.0f;
            unit = "GB";
        } else if (this.toMegabyte() > 0L) {
            full = this.toMegabyte();
            floating = (float)this.toKilobyte() / 1000.0f;
            unit = "MB";
        } else if (this.toKilobyte() > 0L) {
            full = this.toKilobyte();
            floating = (float)this.toByte() / 1000.0f;
            unit = "kB";
        } else {
            return this.toByte() + " B";
        }
        if (full >= 10L) {
            return full + " " + unit;
        }
        return String.format(Locale.ROOT, "%.1f %s", Float.valueOf(floating), unit);
    }

    public String toStringBase2() {
        String unit;
        float floating;
        long full;
        if (this.toGibibyte() > 0L) {
            full = this.toGibibyte();
            floating = (float)this.toMibibyte() / 1024.0f;
            unit = "GiB";
        } else if (this.toMibibyte() > 0L) {
            full = this.toMibibyte();
            floating = (float)this.toKibibyte() / 1024.0f;
            unit = "MiB";
        } else if (this.toKibibyte() > 0L) {
            full = this.toKibibyte();
            floating = (float)this.toByte() / 1024.0f;
            unit = "KiB";
        } else {
            return this.toByte() + " B";
        }
        if (full >= 10L) {
            return full + " " + unit;
        }
        return String.format(Locale.ROOT, "%.1f %s", Float.valueOf(floating), unit);
    }

    public String toString() {
        return this.toStringBase10();
    }

    public String toStringBothUnits() {
        if (this.toByte() < 1000L) {
            return this.toStringBase10();
        }
        return this.toStringBase10() + " (" + this.toStringBase2() + ")";
    }

    public int hashCode() {
        return (int)(this.toByte() ^ this.toByte() >>> 32);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MemoryUnit)) {
            return false;
        }
        MemoryUnit that = (MemoryUnit)other;
        return this.toByte() == that.toByte();
    }

    @Override
    public int compareTo(MemoryUnit other) {
        return Long.compare(this.toByte(), other.toByte());
    }

    private static class LongMemoryUnit
    extends MemoryUnit {
        private static final long serialVersionUID = 3520921097990413917L;
        private final long memoryInByte;

        LongMemoryUnit(long memoryInByte) {
            Preconditions.checkArgument(memoryInByte >= 0L, "MemoryUnit with negative value %s not allowed.", memoryInByte);
            this.memoryInByte = memoryInByte;
        }

        @Override
        public long toByte() {
            return this.memoryInByte;
        }
    }

    private static class IntegerMemoryUnit
    extends MemoryUnit {
        private static final long serialVersionUID = 5100413130312670503L;
        private final int memoryInByte;

        IntegerMemoryUnit(int memoryInByte) {
            Preconditions.checkArgument(memoryInByte >= 0, "MemoryUnit with negative value %s not allowed.", memoryInByte);
            this.memoryInByte = memoryInByte;
        }

        @Override
        public long toByte() {
            return this.memoryInByte;
        }
    }
}

