/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.units.time;

import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToTimeIntervalFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;

@Immutable
public class TimeInterval
implements Serializable,
Comparable<TimeInterval> {
    private static final long serialVersionUID = 6229388135672529235L;
    private final long timeInNanoSeconds;

    private TimeInterval(long timeInNanoSeconds) {
        Preconditions.checkArgument(timeInNanoSeconds >= 0L, "No negative time interval is allowed.");
        this.timeInNanoSeconds = timeInNanoSeconds;
    }

    public static TimeInterval zero() {
        return new TimeInterval(0L);
    }

    public static TimeInterval nanoseconds(long time) {
        return new TimeInterval(time);
    }

    public static TimeInterval microseconds(long time) {
        return TimeInterval.nanoseconds(LongMath.checkedMultiply(time, 1000L));
    }

    public static TimeInterval milliseconds(long time) {
        return TimeInterval.nanoseconds(LongMath.checkedMultiply(time, 1000000L));
    }

    public static TimeInterval seconds(long time) {
        return TimeInterval.nanoseconds(LongMath.checkedMultiply(time, 1000000000L));
    }

    public static TimeInterval minutes(long time) {
        return TimeInterval.nanoseconds(LongMath.checkedMultiply(time, 60000000000L));
    }

    public static TimeInterval hours(long time) {
        return TimeInterval.nanoseconds(LongMath.checkedMultiply(time, 3600000000000L));
    }

    public static TimeInterval days(long time) {
        return TimeInterval.nanoseconds(LongMath.checkedMultiply(time, 86400000000000L));
    }

    public static TimeInterval fromString(String input) {
        try {
            return new StringToTimeIntervalFunction().fromString(input);
        }
        catch (InvalidOptionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public long toNanoseconds() {
        return this.timeInNanoSeconds;
    }

    public long toMicroseconds() {
        return this.toNanoseconds() / 1000L;
    }

    public long toMilliseconds() {
        return this.toMicroseconds() / 1000L;
    }

    public long toSeconds() {
        return this.toMilliseconds() / 1000L;
    }

    public double toSecondsAsDouble() {
        return (double)this.timeInNanoSeconds / 1.0E9;
    }

    public long toMinutes() {
        return this.toSeconds() / 60L;
    }

    public long toHours() {
        return this.toMinutes() / 60L;
    }

    public long toDays() {
        return this.toHours() / 24L;
    }

    public long toYears() {
        return this.toDays() / 365L;
    }

    public boolean isGreaterEqual(TimeInterval other) {
        return this.timeInNanoSeconds >= other.timeInNanoSeconds;
    }

    public boolean isGreater(TimeInterval other) {
        return this.timeInNanoSeconds > other.timeInNanoSeconds;
    }

    public String toString() {
        long years = this.toYears();
        long days = this.toDays() - years * 365L;
        long hours = this.toHours() - years * 365L * 24L - days * 24L;
        long minutes = this.toMinutes() - years * 365L * 24L * 60L - days * 24L * 60L - hours * 60L;
        long seconds = this.toSeconds() - years * 365L * 24L * 60L * 60L - days * 24L * 60L * 60L - hours * 60L * 60L - minutes * 60L;
        StringBuilder result = new StringBuilder();
        if (years > 0L) {
            result.append(years).append("a ");
        }
        if (years > 0L || days > 0L) {
            result.append(days).append("d ");
        }
        if (years > 0L || days > 0L || hours > 0L) {
            result.append(String.format("%02dh ", hours));
        }
        result.append(String.format("%02dmin %02ds", minutes, seconds));
        return result.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof TimeInterval)) {
            return false;
        }
        TimeInterval that = (TimeInterval)other;
        return this.timeInNanoSeconds == that.timeInNanoSeconds;
    }

    public int hashCode() {
        return Objects.hashCode(this.timeInNanoSeconds);
    }

    public static TimeInterval sum(TimeInterval first, TimeInterval second) {
        return TimeInterval.nanoseconds(LongMath.checkedAdd(first.timeInNanoSeconds, second.timeInNanoSeconds));
    }

    public static TimeInterval sum(TimeInterval first, TimeInterval second, TimeInterval third) {
        return TimeInterval.nanoseconds(LongMath.checkedAdd(LongMath.checkedAdd(first.timeInNanoSeconds, second.timeInNanoSeconds), third.timeInNanoSeconds));
    }

    public static TimeInterval sum(TimeInterval first, TimeInterval ... intervals) {
        Preconditions.checkNotNull(first);
        if (intervals.length == 0) {
            return first;
        }
        long time = first.timeInNanoSeconds;
        for (TimeInterval interval : intervals) {
            time = LongMath.checkedAdd(time, interval.timeInNanoSeconds);
        }
        return TimeInterval.nanoseconds(time);
    }

    @Override
    public int compareTo(TimeInterval o) {
        if (this.timeInNanoSeconds == o.timeInNanoSeconds) {
            return 0;
        }
        if (this.timeInNanoSeconds < o.timeInNanoSeconds) {
            return -1;
        }
        return 1;
    }

    public TimeInterval devide(int divisor) {
        return TimeInterval.nanoseconds(this.timeInNanoSeconds / (long)divisor);
    }
}

