/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.workerstart;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class WorkerStartInformation
implements Serializable {
    private static final long serialVersionUID = 2000908280295219507L;
    private final String hostname;
    @Nullable
    private final String path;
    private final boolean userLoginCheck;
    private final boolean useReverseTunnel;

    private WorkerStartInformation(String hostname, Optional<String> path, boolean userLoginCheck, boolean useReverseTunnel) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(hostname));
        this.hostname = hostname;
        this.path = path.orNull();
        this.userLoginCheck = userLoginCheck;
        this.useReverseTunnel = useReverseTunnel;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Optional<String> getPath() {
        return Optional.fromNullable(this.path);
    }

    public boolean enableUserLoginCheck() {
        return this.userLoginCheck;
    }

    public boolean useReverseTunnel() {
        return this.useReverseTunnel;
    }

    public int hashCode() {
        return this.hostname.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (WorkerStartInformation.class != other.getClass()) {
            return false;
        }
        WorkerStartInformation that = (WorkerStartInformation)other;
        return this.hostname.equals(that.hostname);
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName().toString(), this.hostname);
    }

    public static final class WorkerStartInformationBuilder {
        private final String hostname;
        private Optional<String> path = Optional.absent();
        private boolean userLoginCheck = true;
        private boolean useReverseTunnel = false;

        private WorkerStartInformationBuilder(String hostname) {
            this.hostname = Preconditions.checkNotNull(hostname);
        }

        public static WorkerStartInformationBuilder forHost(String hostname) {
            return new WorkerStartInformationBuilder(hostname);
        }

        public WorkerStartInformationBuilder setPath(String path) {
            this.path = Optional.of(path);
            return this;
        }

        public WorkerStartInformationBuilder setUserLoginCheck(boolean active) {
            this.userLoginCheck = active;
            return this;
        }

        public WorkerStartInformationBuilder enableUserLoginCheck() {
            this.userLoginCheck = true;
            return this;
        }

        public WorkerStartInformationBuilder disableUserLoginCheck() {
            this.userLoginCheck = false;
            return this;
        }

        public WorkerStartInformationBuilder setUseReverseTunnel(boolean active) {
            this.useReverseTunnel = active;
            return this;
        }

        public WorkerStartInformation build() {
            return new WorkerStartInformation(this.hostname, this.path, this.userLoginCheck, this.useReverseTunnel);
        }
    }
}

