/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.application.StopAppAndExecuteErrorTriggerUncaughtExceptionHandler;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.error_trigger.ErrorTriggerExecutor;
import org.sosy_lab.verifiercloud.worker.info.WorkerCrashReportSender;

public class WorkerExceptionHandler
extends StopAppAndExecuteErrorTriggerUncaughtExceptionHandler {
    private final AtomicBoolean previousUncaughtException = new AtomicBoolean(false);
    private final WorkerCrashReportSender exceptionMessageSender;

    @Inject
    public WorkerExceptionHandler(ApplicationService worker, ErrorTriggerExecutor errorTriggerExecutor, WorkerCrashReportSender exceptionMessageSender, Logger logger) {
        super(worker, errorTriggerExecutor, logger);
        this.exceptionMessageSender = Preconditions.checkNotNull(exceptionMessageSender);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.exceptionMessageSender.addCrashReport(e);
        if (this.previousUncaughtException.getAndSet(true)) {
            this.getLogger().logf(Level.SEVERE, e, "Second uncaught exception %s in Thread %s.", e.getMessage(), t.getName());
            System.exit(2);
        } else {
            super.uncaughtException(t, e);
        }
    }
}

