/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import org.sosy_lab.verifiercloud.global.application.AbstractCloudModule;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;
import org.sosy_lab.verifiercloud.global.application.ProgramModeFactory;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.ConfigurationHandler;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.ConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationHandler;
import org.sosy_lab.verifiercloud.global.util.TableFormatter;
import org.sosy_lab.verifiercloud.worker.WorkerModule;
import org.sosy_lab.verifiercloud.worker.configuration.WorkerAdditionalConfiguration;
import org.sosy_lab.verifiercloud.worker.configuration.WorkerConfiguration;

public class WorkerFactory
implements ProgramModeFactory {
    @Override
    public String getOptions() {
        return WorkerConfiguration.getOptions() + WorkerAdditionalConfiguration.getOptions();
    }

    @Override
    public String getHelpText() {
        return "A Worker is the unit responsible for executing Runs on a host machine. It is started automatically by the Master.";
    }

    @Override
    public String getOptionDescription() {
        TableFormatter formatter = new TableFormatter(2, 0);
        for (ConfigurationOption configurationOption : WorkerConfiguration.getConfigurationOptions()) {
            formatter.addRow("--" + configurationOption.getName(), configurationOption.getDescription());
        }
        for (ConfigurationOption configurationOption : WorkerAdditionalConfiguration.getConfigurationOptions()) {
            formatter.addRow("--" + configurationOption.getName(), configurationOption.getDescription());
        }
        return formatter.buildTable();
    }

    @Override
    public AbstractCloudModule createModule(CommandLineArguments commandLineArguments, Path userConfigurationPath) throws IOException {
        return new WorkerModule(commandLineArguments, userConfigurationPath);
    }

    @Override
    public ImmutableCollection<ConfigurationHandler<?>> getConfigurationHandlers(Logger logger) {
        return ImmutableList.of(new DefaultConfigurationHandler<WorkerConfiguration>(WorkerConfiguration.getDefaultConfigurationBuilder(), logger));
    }
}

