/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker;

import com.google.common.base.Preconditions;
import com.google.inject.name.Names;
import java.nio.file.Path;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.application.AbstractCloudModule;
import org.sosy_lab.verifiercloud.global.application.ApplicationInitializationException;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;
import org.sosy_lab.verifiercloud.global.logging.InitialLogger;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.logging.LoggerBuilder;
import org.sosy_lab.verifiercloud.global.networking.establishing.connection_builder.ConnectionBuilder;
import org.sosy_lab.verifiercloud.global.networking.establishing.connection_builder.DefaultConnectionBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.DefaultPermanentStorage;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationHandler;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.global.util.disk_space.DefaultNoFreeDiskSpaceDetection;
import org.sosy_lab.verifiercloud.global.util.disk_space.NoFreeDiskSpaceDetection;
import org.sosy_lab.verifiercloud.global.util.error_trigger.DefaultErrorTriggerExecutor;
import org.sosy_lab.verifiercloud.global.util.error_trigger.ErrorTriggerExecutor;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationUtils;
import org.sosy_lab.verifiercloud.global.util.system.guice.OperatingSystemSpecificBindingsModule;
import org.sosy_lab.verifiercloud.global.util.system.guice.UserInformationProviderModule;
import org.sosy_lab.verifiercloud.global.util.time.DefaultTimeProvider;
import org.sosy_lab.verifiercloud.global.util.time.TimeProvider;
import org.sosy_lab.verifiercloud.transportable.filecontent.AbstractFileContent;
import org.sosy_lab.verifiercloud.worker.Worker;
import org.sosy_lab.verifiercloud.worker.WorkerExceptionHandler;
import org.sosy_lab.verifiercloud.worker.configuration.WorkerAdditionalConfiguration;
import org.sosy_lab.verifiercloud.worker.configuration.WorkerConfiguration;
import org.sosy_lab.verifiercloud.worker.files.DefaultWorkerFileStorage;
import org.sosy_lab.verifiercloud.worker.files.WorkerFileStorage;
import org.sosy_lab.verifiercloud.worker.info.DefaultMasterStateUpdate;
import org.sosy_lab.verifiercloud.worker.info.MasterStateUpdate;
import org.sosy_lab.verifiercloud.worker.info.WorkerStatisticProvider;
import org.sosy_lab.verifiercloud.worker.network.DefaultMasterConnection;
import org.sosy_lab.verifiercloud.worker.network.DefaultWorkerAPI;
import org.sosy_lab.verifiercloud.worker.network.MasterConnection;
import org.sosy_lab.verifiercloud.worker.network.WorkerAPI;
import org.sosy_lab.verifiercloud.worker.network.WorkerStateChangeSender;
import org.sosy_lab.verifiercloud.worker.run.DelegatingWorkerModel;
import org.sosy_lab.verifiercloud.worker.run.Executor;
import org.sosy_lab.verifiercloud.worker.run.StateBasedExecutor;
import org.sosy_lab.verifiercloud.worker.run.WorkerModel;
import org.sosy_lab.verifiercloud.worker.run.WorkerStateListener;
import org.sosy_lab.verifiercloud.worker.run.energy.EnergyMeasurement;
import org.sosy_lab.verifiercloud.worker.run.energy.NullEnergyMeasurement;

public class WorkerModule
extends AbstractCloudModule {
    private static final String WORKER_CONFIG_FILE = "Config";
    public static final String WORKING_DIR_ANNOTAION = "workingDir";
    private static final Path WORKING_DIR = SystemInformationUtils.getWorkingDir();
    private final Path workerPermanentStoragePath;
    private final CommandLineArguments commandLineArguments;
    private WorkerConfiguration configuration;
    private WorkerAdditionalConfiguration additionalConfiguration;
    private final InitialLogger initialLogger;

    public WorkerModule(CommandLineArguments commandLineArguments, Path userConfigurationpath) {
        this.commandLineArguments = Preconditions.checkNotNull(commandLineArguments);
        this.workerPermanentStoragePath = Preconditions.checkNotNull(userConfigurationpath).resolve("worker");
        this.initialLogger = LoggerBuilder.createInitialLogger();
    }

    @Override
    public void initialize() throws ApplicationInitializationException {
        DefaultPermanentStorage permanentStorage = new DefaultPermanentStorage(this.workerPermanentStoragePath, this.initialLogger);
        try {
            permanentStorage.initialize();
        }
        catch (PermanentStorageException e) {
            throw new ApplicationInitializationException(e);
        }
        try {
            DefaultConfigurationHandler<WorkerConfiguration> confHandler = new DefaultConfigurationHandler<WorkerConfiguration>(WorkerConfiguration.getDefaultConfigurationBuilder(), this.initialLogger);
            permanentStorage.parseFile(WORKER_CONFIG_FILE, confHandler);
            DefaultConfigurationHandler<WorkerAdditionalConfiguration> additionalConfHandler = new DefaultConfigurationHandler<WorkerAdditionalConfiguration>(WorkerAdditionalConfiguration.getDefaultBuilder(), this.initialLogger);
            CommandLineArguments remainingArguments = confHandler.claimParameters(this.commandLineArguments);
            remainingArguments = additionalConfHandler.claimParameters(remainingArguments);
            if (!remainingArguments.isEmpty()) {
                throw new ApplicationInitializationException("Invalid parameters.");
            }
            this.configuration = (WorkerConfiguration)confHandler.getParseResult();
            this.additionalConfiguration = (WorkerAdditionalConfiguration)additionalConfHandler.getParseResult();
        }
        catch (InvalidOptionException | PermanentStorageException e) {
            throw new ApplicationInitializationException(e.getMessage());
        }
        LoggerBuilder.create().logToStdOut(this.configuration.getLogLevel()).logExceptionsToErrorTrigger(this.configuration.getErrorTriggerCommand(), Level.WARNING).injectInto(this.initialLogger);
        AbstractFileContent.setDeserializationPath(WORKING_DIR.resolve("BigFileContentTmp"));
        AbstractFileContent.setWriteRepresentationOnDeserialisation(false);
        WorkerModule.requireMasterHostname(this.configuration.getMasterHostName());
    }

    @Override
    protected void configure() {
        this.install(new OperatingSystemSpecificBindingsModule());
        this.install(new UserInformationProviderModule());
        this.install(this.configuration);
        this.install(this.additionalConfiguration);
        this.bind(Path.class).annotatedWith(Names.named(WORKING_DIR_ANNOTAION)).toInstance(WORKING_DIR);
        this.bind(ApplicationService.class).to(Worker.class).asEagerSingleton();
        this.bind(Thread.UncaughtExceptionHandler.class).to(WorkerExceptionHandler.class);
        this.bind(ErrorTriggerExecutor.class).to(DefaultErrorTriggerExecutor.class);
        this.bind(NoFreeDiskSpaceDetection.class).to(DefaultNoFreeDiskSpaceDetection.class);
        this.bind(MasterConnection.class).to(DefaultMasterConnection.class).asEagerSingleton();
        this.bind(WorkerAPI.class).to(DefaultWorkerAPI.class).asEagerSingleton();
        this.bind(MasterStateUpdate.class).to(DefaultMasterStateUpdate.class).asEagerSingleton();
        this.bind(WorkerStateListener.class).to(WorkerStateChangeSender.class);
        this.bind(Executor.class).to(StateBasedExecutor.class).asEagerSingleton();
        this.bind(WorkerModel.class).to(DelegatingWorkerModel.class).asEagerSingleton();
        this.bind(WorkerFileStorage.class).to(DefaultWorkerFileStorage.class).asEagerSingleton();
        this.bind(Logger.class).toInstance(this.initialLogger);
        this.bind(ConnectionBuilder.class).to(DefaultConnectionBuilder.class);
        this.bind(TimeProvider.class).to(DefaultTimeProvider.class).asEagerSingleton();
        this.bind(WorkerStatisticProvider.class).asEagerSingleton();
        this.bind(EnergyMeasurement.class).to(NullEnergyMeasurement.class);
    }
}

