/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.configuration;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.inject.TypeLiteral;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.Configuration;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.ConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.GenericTypeConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.StringFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.constraints.PortConstraint;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.constraints.PositiveIntegerConstraint;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringNotNullFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToBooleanFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToImmutableSetFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToIntegerFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToLevelFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToOptionalFunction;

public class WorkerConfiguration
extends Configuration {
    public static final String MASTER_HOSTNAME = "master";
    private final ConfigurationOption<String> masterHostname = new DefaultConfigurationOption<String>("master", "Sets the hostname of the master to connect to.", "<hostname>", "", new StringNotNullFunction(), "connectionBuilderHost");
    public static final String MASTER_PORT = "master-port";
    private final ConfigurationOption<Integer> masterPort = new DefaultConfigurationOption<Integer>("master-port", "Sets the port number at the master used by the worker to connect to the master.", "<port>", Integer.valueOf(15141), (StringFunction<Integer>)new StringToIntegerFunction(), (Predicate<Integer>)new PortConstraint(), "connectionBuilderPort");
    public static final String STOP_ON_USER_LOGIN = "stop-worker-on-userlogin";
    private final ConfigurationOption<Boolean> stopWorkerOnUserLogin = new DefaultConfigurationOption<Boolean>("stop-worker-on-userlogin", "Specifies whether the worker should stop when another user logs in.", "(true|false)", true, new StringToBooleanFunction());
    public static final String LOGLEVEL = "loglevel";
    private final ConfigurationOption<Level> logLevel = new DefaultConfigurationOption<Level>("loglevel", "Sets the log level.", "(" + Joiner.on("|").join(Logger.POSSIBLE_SETTINGS) + ")", Level.FINEST, new StringToLevelFunction(), "logLevel");
    public static final String IGNORED_USERS = "ignored-users";
    private final ConfigurationOption<ImmutableSet<String>> ignoredUsers = new GenericTypeConfigurationOption<ImmutableSet<String>>("ignored-users", "A comma-separated list of users that should be ignored when checking if anyone else is currently logged in.", "[user1,user2,...]", ImmutableSet.of("nobody", "crondata"), new StringToImmutableSetFunction<String>(new StringNotNullFunction(), ","), new TypeLiteral<ImmutableSet<String>>(){});
    public static final String IGNORED_PROGRAMS = "ignored-programs";
    private final ConfigurationOption<ImmutableSet<String>> ignoredPrograms = new GenericTypeConfigurationOption<ImmutableSet<String>>("ignored-programs", "A comma-separated list of programs that should be ignored when checking if anyone else is currently logged in.", "[program1,program2,...]", ImmutableSet.of("ssh-agent"), new StringToImmutableSetFunction<String>(new StringNotNullFunction(), ","), new TypeLiteral<ImmutableSet<String>>(){});
    private static final int DEFAULT_MIN_HUMAN_UID = 1000;
    public static final String MIN_HUMAN_UID = "min-human-uid";
    private final ConfigurationOption<Integer> minHumanUid = new DefaultConfigurationOption<Integer>("min-human-uid", "The lowest UID that should be checked for running programs when determining whether a (human) user is currently logged in. This can be used to exclude daemons from the check, since they should only have UIDs below a certain (distribution-dependant) threshold.", "<uid>", Integer.valueOf(1000), new StringToIntegerFunction(), new PositiveIntegerConstraint());
    public static final String NO_CLEANUP = "no-cleanup";
    private final ConfigurationOption<Boolean> noCleanup = new DefaultConfigurationOption<Boolean>("no-cleanup", "Whether the files and directories created by the worker should be deleted when a run has been completed.", "(true|false)", false, new StringToBooleanFunction());
    public static final String MAX_RUN_RESULT_FILES = "max-run-result-files";
    private final ConfigurationOption<Integer> maxRunResultFiles = new DefaultConfigurationOption<Integer>("max-run-result-files", "Maximal number of result files for a run. The value is set for all workers stared by the master.Defaults to 100,000.", "<max number of input files>", Integer.valueOf(100000), new StringToIntegerFunction(), new PositiveIntegerConstraint());
    public static final String ERROR_TRIGGER_COMMAND = "error-trigger-command";
    private final ConfigurationOption<Optional<String>> errorTriggerCommand = new GenericTypeConfigurationOption<Optional<String>>("error-trigger-command", "Command beeing executed in case of an exception or dead lock.", "- | <command>", Optional.absent(), new StringToOptionalFunction<String>(new StringNotNullFunction()), new TypeLiteral<Optional<String>>(){});
    private ImmutableSet<ConfigurationOption<?>> options = ImmutableSet.of(this.logLevel, this.masterHostname, this.masterPort, this.stopWorkerOnUserLogin, this.ignoredUsers, this.ignoredPrograms, new ConfigurationOption[]{this.minHumanUid, this.noCleanup, this.maxRunResultFiles, this.errorTriggerCommand});

    public String getMasterHostName() {
        return this.masterHostname.getValue();
    }

    public Level getLogLevel() {
        return this.logLevel.getValue();
    }

    public Optional<String> getErrorTriggerCommand() {
        return this.errorTriggerCommand.getValue();
    }

    @Override
    public ImmutableSet<ConfigurationOption<?>> getAllConfigurationOptions() {
        return this.options;
    }

    public static ImmutableSet<ConfigurationOption<?>> getConfigurationOptions() {
        return new WorkerConfiguration().getAllConfigurationOptions();
    }

    public static DefaultConfigurationBuilder<WorkerConfiguration> getDefaultConfigurationBuilder() {
        return new DefaultConfigurationBuilder<WorkerConfiguration>(){

            @Override
            public WorkerConfiguration getDefaultConfiguration() {
                return new WorkerConfiguration();
            }
        };
    }

    public static String getOptions() {
        return WorkerConfiguration.buildOptionsString(WorkerConfiguration.getConfigurationOptions());
    }
}

