/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.files;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Queues;
import com.google.common.hash.HashCode;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.file_storage.DefaultGenericFileStorage;
import org.sosy_lab.verifiercloud.global.file_storage.FileNotAvailableException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.info.FileStorageInformation;
import org.sosy_lab.verifiercloud.worker.files.ExceptionToFileNotAvailableExceptionFunction;
import org.sosy_lab.verifiercloud.worker.files.WorkerFileStorage;
import org.sosy_lab.verifiercloud.worker.network.MasterConnection;

public class DefaultWorkerFileStorage
implements WorkerFileStorage {
    private static final Set<PosixFilePermission> PERMISSIONS = PosixFilePermissions.fromString("r-x------");
    private final Logger logger;
    private final MasterConnection master;
    private final ApplicationService worker;
    private final DefaultGenericFileStorage genericFileStorage;
    private final Queue<HashCode> unrequestedFiles = Queues.synchronizedQueue(Queues.newArrayDeque());
    private final Multimap<HashCode, SettableFuture<Path>> stillRequiredFiles = Multimaps.synchronizedMultimap(ArrayListMultimap.create());
    private final Set<HashCode> currentlyBufferedFiles = Collections.synchronizedSet(new HashSet());
    private final ExecutorService executorService;

    @Inject
    public DefaultWorkerFileStorage(MasterConnection master, ApplicationService worker, Logger logger) {
        this.worker = Preconditions.checkNotNull(worker);
        this.master = Preconditions.checkNotNull(master);
        this.logger = Preconditions.checkNotNull(logger);
        this.genericFileStorage = new DefaultGenericFileStorage(false, logger);
        ThreadFactory tf = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.getClass().getSimpleName().toString() + "-Thread").build();
        this.executorService = Executors.newSingleThreadScheduledExecutor(tf);
    }

    @Override
    public void initializeFileStorage(Path baseWorkingDir) throws IOException {
        this.genericFileStorage.initializeFileStorage(baseWorkingDir);
    }

    @Override
    public void indexFiles() throws IOException {
        this.genericFileStorage.indexFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckedFuture<Path, FileNotAvailableException> getFile(HashCode fileHash) {
        this.genericFileStorage.checkIsInitialized();
        if (this.genericFileStorage.isFileKnown(fileHash)) {
            return Futures.immediateCheckedFuture(this.genericFileStorage.getFileFromStorage(fileHash));
        }
        Multimap<HashCode, SettableFuture<Path>> multimap = this.stillRequiredFiles;
        synchronized (multimap) {
            SettableFuture fileFuture = SettableFuture.create();
            if (!this.stillRequiredFiles.containsKey(fileHash)) {
                this.unrequestedFiles.add(fileHash);
                if (this.stillRequiredFiles.isEmpty()) {
                    this.requestNextFile();
                }
            }
            this.stillRequiredFiles.put(fileHash, fileFuture);
            return Futures.makeChecked(fileFuture, new ExceptionToFileNotAvailableExceptionFunction(fileHash));
        }
    }

    @Override
    public HashCode addFile(final FileContent fileContent) {
        this.genericFileStorage.checkIsInitialized();
        this.currentlyBufferedFiles.add(fileContent.getFileHash());
        Preconditions.checkNotNull(fileContent);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                Path file;
                try {
                    file = DefaultWorkerFileStorage.this.genericFileStorage.addFile(fileContent);
                    Files.setPosixFilePermissions(file, PERMISSIONS);
                }
                catch (IOException e) {
                    DefaultWorkerFileStorage.this.logger.logf(Level.SEVERE, e, "Failed to write file: %s", e.getMessage());
                    DefaultWorkerFileStorage.this.worker.stop();
                    return;
                }
                HashCode fileHash = fileContent.getFileHash();
                Collection allFutureFiles = DefaultWorkerFileStorage.this.stillRequiredFiles.removeAll(fileHash);
                for (SettableFuture futureForFile : allFutureFiles) {
                    futureForFile.set(file);
                }
                DefaultWorkerFileStorage.this.currentlyBufferedFiles.remove(fileHash);
                DefaultWorkerFileStorage.this.requestNextFile();
            }
        });
        return fileContent.getFileHash();
    }

    @Override
    public boolean isFileKnown(HashCode fileHash) {
        return this.currentlyBufferedFiles.contains(fileHash) || this.genericFileStorage.isFileKnown(fileHash);
    }

    @Override
    public FileStorageInformation getFileStorageInformation() {
        return this.genericFileStorage.getFileStorageInformation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestNextFile() {
        Queue<HashCode> queue = this.unrequestedFiles;
        synchronized (queue) {
            if (!this.unrequestedFiles.isEmpty()) {
                this.master.requestFile(this.unrequestedFiles.remove());
            }
        }
    }
}

