/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.info;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;
import org.sosy_lab.verifiercloud.global.util.system.UserInformationProvider;
import org.sosy_lab.verifiercloud.global.util.system.cache.InstanceProvider;
import org.sosy_lab.verifiercloud.global.util.system.cache.OneValueCache;
import org.sosy_lab.verifiercloud.global.util.time.UptimeMeasurer;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.info.worker.ExecutorState;
import org.sosy_lab.verifiercloud.transportable.info.worker.LoadData;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerRuntimeInformation;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerStatistic;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;
import org.sosy_lab.verifiercloud.worker.files.WorkerFileStorage;
import org.sosy_lab.verifiercloud.worker.info.MasterStateUpdate;
import org.sosy_lab.verifiercloud.worker.info.WorkerStatisticProvider;
import org.sosy_lab.verifiercloud.worker.network.MasterConnection;
import org.sosy_lab.verifiercloud.worker.run.Executor;
import org.sosy_lab.verifiercloud.worker.run.WorkerModel;

public class DefaultMasterStateUpdate
implements MasterStateUpdate {
    private final Logger logger;
    private final ExecutorService executorService;
    private final OneValueCache<WorkerRuntimeInformation, SystemEnvironmentException> cache;
    private final Executor executor;
    private final WorkerModel workerSystem;
    private final MasterConnection masterConnection;
    private final WorkerFileStorage workerFileStorage;
    private final UserInformationProvider userInformationProvider;
    private final SystemInformationProvider systemInformationProvider;
    private final WorkerStatisticProvider workerStatisticProvider;
    private final UptimeMeasurer uptimeMeasurer = new UptimeMeasurer();

    @Inject
    public DefaultMasterStateUpdate(UserInformationProvider userInformationProvider, SystemInformationProvider systemInformationProvider, WorkerModel workerSystem, Executor executor, MasterConnection masterConnection, WorkerFileStorage workerFileStorage, WorkerStatisticProvider workerStatisticProvider, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
        this.userInformationProvider = Preconditions.checkNotNull(userInformationProvider);
        this.systemInformationProvider = Preconditions.checkNotNull(systemInformationProvider);
        this.workerStatisticProvider = workerStatisticProvider;
        workerStatisticProvider.initialize();
        this.executor = Preconditions.checkNotNull(executor);
        this.workerSystem = Preconditions.checkNotNull(workerSystem);
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.workerFileStorage = Preconditions.checkNotNull(workerFileStorage);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("StateUpdateCollector-%d").setUncaughtExceptionHandler(uncaughtExceptionHandler).build();
        this.executorService = Executors.newCachedThreadPool(threadFactory);
        this.cache = new OneValueCache<WorkerRuntimeInformation, SystemEnvironmentException>(TimeInterval.milliseconds(500L), new InformationProvider());
    }

    @Override
    public void sendStateUpdateToMaster() throws IOException, SystemEnvironmentException {
        ExecutorState stateDescription = this.collectExecutorState();
        WorkerRuntimeInformation workerRuntimeInformation = this.collectRuntimeInformation();
        this.masterConnection.sendStateUpdate(stateDescription, workerRuntimeInformation);
    }

    @Override
    public ExecutorState collectExecutorState() {
        return this.executor.getExecutorState();
    }

    @Override
    public WorkerRuntimeInformation collectRuntimeInformation() throws SystemEnvironmentException {
        WorkerRuntimeInformation runtimeInfo;
        long initialTimeNanos = 0L;
        if (this.logger.wouldLog(Level.INFO)) {
            initialTimeNanos = System.nanoTime();
        }
        if ((runtimeInfo = this.cache.get()).getState() != this.workerSystem.getWorkerState()) {
            this.cache.invalidate();
            runtimeInfo = this.cache.get();
        }
        if (this.logger.wouldLog(Level.INFO)) {
            long endTimeNanos = System.nanoTime();
            long duration = endTimeNanos - initialTimeNanos;
            Level level = duration > 10000000L ? Level.INFO : Level.ALL;
            this.logger.logf(level, "Required time for information collection: %s ns", duration);
        }
        return runtimeInfo;
    }

    private WorkerRuntimeInformation collectData() throws SystemEnvironmentException {
        Future<LoadData> load = this.getLoad();
        Future<MemoryUnit> availableMemory = this.getAvailableMemory();
        Future<ImmutableSet<String>> activeUsers = this.getActiveUsers();
        Future<ImmutableSet<String>> activePrograms = this.getActivePrograms();
        Future<MemoryUnit> usableMemory = this.getUsableMemory();
        Future<Map<Integer, MemoryUnit>> availableNumaMemory = this.getAvailableNumaMemory();
        Future<ImmutableSet<Processor>> unusableProcessors = this.getUnusableProcessors();
        Future<WorkerStatistic> workerStatistic = this.getWorkerStatistic();
        try {
            return new WorkerRuntimeInformation(this.workerSystem.getWorkerState(), this.systemInformationProvider.getFreeSpaceWorkingDir(), this.systemInformationProvider.getFreeSpaceTemp(), load.get(), availableMemory.get(), availableNumaMemory.get(), this.uptimeMeasurer.getUptime(), this.workerSystem.isUsercheckActive(), (Collection<String>)activeUsers.get(), (Collection<String>)activePrograms.get(), this.workerFileStorage.getFileStorageInformation(), (Set<Processor>)unusableProcessors.get(), usableMemory.get(), workerStatistic.get());
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof SystemEnvironmentException) {
                throw (SystemEnvironmentException)e.getCause();
            }
            this.logger.logf(Level.SEVERE, e, "Unexpected Exception: %s", e);
            throw new SystemEnvironmentException(e);
        }
    }

    private Future<LoadData> getLoad() {
        return this.executorService.submit(new Callable<LoadData>(){

            @Override
            public LoadData call() throws Exception {
                return DefaultMasterStateUpdate.this.systemInformationProvider.getLoad();
            }
        });
    }

    private Future<MemoryUnit> getAvailableMemory() {
        return this.executorService.submit(new Callable<MemoryUnit>(){

            @Override
            public MemoryUnit call() throws Exception {
                return DefaultMasterStateUpdate.this.systemInformationProvider.getAvailableMemory();
            }
        });
    }

    private Future<Map<Integer, MemoryUnit>> getAvailableNumaMemory() {
        return this.executorService.submit(new Callable<Map<Integer, MemoryUnit>>(){

            @Override
            public Map<Integer, MemoryUnit> call() throws Exception {
                return DefaultMasterStateUpdate.this.systemInformationProvider.getAvailableNumaMemory();
            }
        });
    }

    private Future<MemoryUnit> getUsableMemory() {
        return this.executorService.submit(new Callable<MemoryUnit>(){

            @Override
            public MemoryUnit call() throws Exception {
                return DefaultMasterStateUpdate.this.systemInformationProvider.getUsableMemory();
            }
        });
    }

    private Future<ImmutableSet<String>> getActiveUsers() {
        return this.executorService.submit(new Callable<ImmutableSet<String>>(){

            @Override
            public ImmutableSet<String> call() throws Exception {
                return DefaultMasterStateUpdate.this.userInformationProvider.getActiveUsers();
            }
        });
    }

    private Future<ImmutableSet<String>> getActivePrograms() {
        return this.executorService.submit(new Callable<ImmutableSet<String>>(){

            @Override
            public ImmutableSet<String> call() throws Exception {
                return DefaultMasterStateUpdate.this.userInformationProvider.getActivePrograms();
            }
        });
    }

    private Future<ImmutableSet<Processor>> getUnusableProcessors() {
        return this.executorService.submit(new Callable<ImmutableSet<Processor>>(){

            @Override
            public ImmutableSet<Processor> call() throws Exception {
                return DefaultMasterStateUpdate.this.systemInformationProvider.getUnusableProcessors();
            }
        });
    }

    private Future<WorkerStatistic> getWorkerStatistic() {
        return this.executorService.submit(new Callable<WorkerStatistic>(){

            @Override
            public WorkerStatistic call() throws Exception {
                return DefaultMasterStateUpdate.this.workerStatisticProvider.getWorkerStatistic();
            }
        });
    }

    private class InformationProvider
    implements InstanceProvider<WorkerRuntimeInformation, SystemEnvironmentException> {
        private InformationProvider() {
        }

        @Override
        public WorkerRuntimeInformation getInstance() throws SystemEnvironmentException {
            return DefaultMasterStateUpdate.this.collectData();
        }
    }
}

