/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.info;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;
import org.sosy_lab.verifiercloud.global.util.time.TimeProvider;
import org.sosy_lab.verifiercloud.transportable.info.worker.LoadData;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionInformation;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerState;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerStatistic;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;
import org.sosy_lab.verifiercloud.worker.run.Executor;
import org.sosy_lab.verifiercloud.worker.run.WorkerModel;
import org.sosy_lab.verifiercloud.worker.run.WorkerStateListener;

public class WorkerStatisticProvider
implements WorkerStateListener {
    private static final TimeInterval MINUTE_1 = TimeInterval.minutes(1L);
    private static final TimeInterval MINUTES_5 = TimeInterval.minutes(5L);
    private static final TimeInterval MINUTES_15 = TimeInterval.minutes(15L);
    private final WorkerModel worker;
    private final Executor executor;
    private final SystemInformationProvider systemInformationProvider;
    private final TimeProvider timeProvider;
    private final Logger logger;
    private final AtomicLong overallTime = new AtomicLong();
    private final AtomicLong userOccupiedTime = new AtomicLong();
    private final AtomicLong idleTime = new AtomicLong();
    private final AtomicDouble overallLoad = new AtomicDouble();
    private final AtomicLong lastChange;
    private final AtomicBoolean userOccupied;
    private final AtomicBoolean idle;
    private final AtomicDouble load;
    private final NavigableMap<Long, Double> loadHistory;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    @Inject
    public WorkerStatisticProvider(WorkerModel worker, Executor executor, SystemInformationProvider systemInformationProvider, TimeProvider timeProvider, Logger logger) throws SystemEnvironmentException {
        this.worker = Preconditions.checkNotNull(worker);
        this.executor = Preconditions.checkNotNull(executor);
        this.systemInformationProvider = Preconditions.checkNotNull(systemInformationProvider);
        this.timeProvider = Preconditions.checkNotNull(timeProvider);
        this.logger = logger;
        this.lastChange = new AtomicLong(timeProvider.getMillis());
        this.userOccupied = new AtomicBoolean(this.isUserOccupied());
        this.idle = new AtomicBoolean(this.isIdle());
        this.load = new AtomicDouble(this.getCurrentLoad());
        this.loadHistory = Maps.synchronizedNavigableMap(Maps.newTreeMap());
        this.loadHistory.put(this.lastChange.get(), this.load.get());
    }

    public void initialize() {
        if (!this.initialized.getAndSet(true)) {
            this.worker.registerStateChangeListener(this);
        }
    }

    public WorkerStatistic getWorkerStatistic() {
        Preconditions.checkState(this.initialized.get(), "Call initialize() first.");
        return new WorkerStatistic(this.overallLoad.get(), this.getRelativeUserOccupiedTime(), this.getRelativeIdleTime(), this.getLoadData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadData getLoadData() {
        long currentTime;
        if ((double)this.overallTime.get() == 0.0) {
            return LoadData.invalidLoadData();
        }
        long lastComputedTime = currentTime = this.timeProvider.getMillis();
        long overallTime = this.overallTime.get() + (currentTime - this.lastChange.get());
        float weightedLoadSum1Minute = 0.0f;
        float weightedLoadSum5Minutes = 0.0f;
        float weightedLoadSum15Minutes = 0.0f;
        long timeToCompute1Minute = Math.min(MINUTE_1.toMilliseconds(), overallTime);
        long timeToCompute5Minutes = Math.min(MINUTES_5.toMilliseconds(), overallTime);
        long timeToCompute15Minutes = Math.min(MINUTES_15.toMilliseconds(), overallTime);
        long remainingTimeToCompute1Minute = timeToCompute1Minute;
        long remainingTimeToCompute5Minutes = timeToCompute5Minutes;
        long remainingTimeToCompute15Minutes = timeToCompute15Minutes;
        NavigableMap<Long, Double> navigableMap = this.loadHistory;
        synchronized (navigableMap) {
            Iterator<Long> it = this.loadHistory.descendingKeySet().iterator();
            while (it.hasNext()) {
                long timeWeight;
                long time = it.next();
                double load = (Double)this.loadHistory.get(time);
                long timeToLastTime = lastComputedTime - time;
                if (remainingTimeToCompute1Minute > 0L) {
                    timeWeight = Math.min(timeToLastTime, remainingTimeToCompute1Minute);
                    weightedLoadSum1Minute = (float)((double)weightedLoadSum1Minute + (double)timeWeight * load);
                    remainingTimeToCompute1Minute -= timeWeight;
                }
                if (remainingTimeToCompute5Minutes > 0L) {
                    timeWeight = Math.min(timeToLastTime, remainingTimeToCompute5Minutes);
                    weightedLoadSum5Minutes = (float)((double)weightedLoadSum5Minutes + (double)timeWeight * load);
                    remainingTimeToCompute5Minutes -= timeWeight;
                }
                if (remainingTimeToCompute15Minutes > 0L) {
                    timeWeight = Math.min(timeToLastTime, remainingTimeToCompute15Minutes);
                    weightedLoadSum15Minutes = (float)((double)weightedLoadSum15Minutes + (double)timeWeight * load);
                    remainingTimeToCompute15Minutes -= timeWeight;
                } else {
                    it.remove();
                }
                lastComputedTime = time;
            }
        }
        float load1Minute = weightedLoadSum1Minute / (float)timeToCompute1Minute;
        float load5Minutes = weightedLoadSum5Minutes / (float)timeToCompute5Minutes;
        float load15Minutes = weightedLoadSum15Minutes / (float)timeToCompute15Minutes;
        return new LoadData(load1Minute, load5Minutes, load15Minutes);
    }

    private double getRelativeUserOccupiedTime() {
        double relativeUserOccupiedTime = this.overallTime.get() != 0L ? this.userOccupiedTime.doubleValue() / this.overallTime.doubleValue() : (this.userOccupied.get() ? 1.0 : 0.0);
        return relativeUserOccupiedTime;
    }

    private double getRelativeIdleTime() {
        double relativeIdleTime;
        if (this.overallTime.get() != 0L) {
            relativeIdleTime = this.idleTime.doubleValue() / this.overallTime.doubleValue();
        } else {
            double d = relativeIdleTime = this.userOccupied.get() ? 0.0 : 1.0;
        }
        if (relativeIdleTime > 1.0 || relativeIdleTime < 0.0) {
            this.logger.logf(Level.WARNING, "Relative idle time is out of range:%f.", relativeIdleTime);
        }
        return relativeIdleTime;
    }

    @Override
    public void stateChanged() {
        double lastLoad;
        long currentTime = this.timeProvider.getMillis();
        long timeSinceLastUpdate = currentTime - this.lastChange.get();
        try {
            lastLoad = this.load.getAndSet(this.getCurrentLoad());
        }
        catch (SystemEnvironmentException e) {
            throw new RuntimeException(e);
        }
        if (timeSinceLastUpdate != 0L) {
            this.overallLoad.set(((double)timeSinceLastUpdate * lastLoad + (double)this.overallTime.get() * this.overallLoad.get()) / (double)(this.overallTime.get() + timeSinceLastUpdate));
        }
        this.loadHistory.put(currentTime, this.load.get());
        this.overallTime.addAndGet(timeSinceLastUpdate);
        if (this.userOccupied.get()) {
            this.userOccupiedTime.addAndGet(timeSinceLastUpdate);
        }
        if (this.idle.get()) {
            this.idleTime.addAndGet(timeSinceLastUpdate);
        }
        this.lastChange.set(currentTime);
        this.userOccupied.set(this.isUserOccupied());
        this.idle.set(this.isIdle());
    }

    private boolean isUserOccupied() {
        return this.worker.getWorkerState().equals((Object)WorkerState.USER_OCCUPIED);
    }

    private boolean isIdle() {
        return !this.isUserOccupied() && this.executor.getExecutorState().getNumberOfPartitions() == 0;
    }

    private double getCurrentLoad() throws SystemEnvironmentException {
        int reservedCpus = 0;
        MemoryUnit reservedMemory = MemoryUnit.zero();
        ImmutableCollection<WorkerPartitionInformation> partitions = this.executor.getExecutorState().getPartitions();
        for (WorkerPartitionInformation partion : partitions) {
            reservedCpus += partion.getNumberOfProcessors();
            reservedMemory = MemoryUnit.sum(reservedMemory, MemoryUnit.sum(partion.getReservedMemory().values()));
        }
        double cpu = (double)reservedCpus / ((double)this.systemInformationProvider.getProcessors().size() - (double)this.systemInformationProvider.getUnusableProcessors().size());
        double memory = (double)reservedMemory.toByte() / (double)this.systemInformationProvider.getUsableMemory().toByte();
        if (cpu > 1.0 || memory > 1.0 || cpu < 0.0 || memory < 0.0) {
            this.logger.logf(Level.WARNING, "Load is out of range. CPU: %f, memory: %f.", cpu, memory);
        }
        return Math.max(cpu, memory);
    }
}

