/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.maintenance;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.client.run_builders.BenchmarkRunCollectionBuilder;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.FileUtils;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class WorkingDirectoryCleanup {
    private static final TimeInterval MAX_AGE_LOGS = TimeInterval.days(30L);
    @VisibleForTesting
    static final TimeInterval MAX_AGE_TEMP_FOLDERS = TimeInterval.sum(BenchmarkRunCollectionBuilder.MAX_TIME_LIMIT, TimeInterval.hours(1L));
    private final Logger logger;
    private Path workingDir;

    public WorkingDirectoryCleanup(Path workingDir, Logger logger) {
        this.workingDir = Preconditions.checkNotNull(workingDir);
        this.logger = Preconditions.checkNotNull(logger);
    }

    public MemoryUnit cleanUpOldFiles() throws IOException {
        CleanupWalker cleanupWalker = new CleanupWalker();
        Files.walkFileTree(this.workingDir, cleanupWalker);
        return cleanupWalker.getDeletedFileSize();
    }

    static /* synthetic */ TimeInterval access$100() {
        return MAX_AGE_LOGS;
    }

    private class CleanupWalker
    implements FileVisitor<Path> {
        private final FileTime REFERENCE_TIME_LOGFILES = FileTime.fromMillis(System.currentTimeMillis() - WorkingDirectoryCleanup.access$100().toMilliseconds());
        private final FileTime REFERENCE_TIME_TEMP_FOLDERS = FileTime.fromMillis(System.currentTimeMillis() - MAX_AGE_TEMP_FOLDERS.toMilliseconds());
        private long deletedFileSizeByte = 0L;

        private CleanupWalker() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (dir.equals(WorkingDirectoryCleanup.this.workingDir)) {
                return FileVisitResult.CONTINUE;
            }
            if (this.isTmpFolder(dir) && attrs.lastModifiedTime().compareTo(this.REFERENCE_TIME_TEMP_FOLDERS) < 0) {
                MemoryUnit deleteFileSize = FileUtils.deleteDirectory(dir, WorkingDirectoryCleanup.this.logger);
                this.deletedFileSizeByte += deleteFileSize.toByte();
                WorkingDirectoryCleanup.this.logger.logf(Level.FINE, "Deleted old tmp directory %s.", dir);
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            boolean isLogFile = file.getFileName().toString().endsWith(".log");
            if (isLogFile && attrs.lastModifiedTime().compareTo(this.REFERENCE_TIME_LOGFILES) < 0) {
                this.deletedFileSizeByte += attrs.size();
                Files.delete(file);
                WorkingDirectoryCleanup.this.logger.logf(Level.FINE, "Deleted old log file %s.", file.getFileName());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            WorkingDirectoryCleanup.this.logger.logf(Level.FINE, exc, "Failed to delete file during cleanup: %s", exc.getMessage());
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        private boolean isTmpFolder(Path dir) {
            return dir.getFileName().toString().startsWith("tmp_");
        }

        public MemoryUnit getDeletedFileSize() {
            return MemoryUnit.bytes(this.deletedFileSizeByte);
        }
    }
}

