/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.network;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.Socket;
import java.util.LinkedList;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.networking.establishing.connection_builder.ConnectionBuilder;
import org.sosy_lab.verifiercloud.global.networking.establishing.connection_builder.ConnectionBuilderListener;
import org.sosy_lab.verifiercloud.global.networking.interaction.AsyncIncomingCommandHandler;
import org.sosy_lab.verifiercloud.global.networking.interaction.IncomingCommandHandler;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;
import org.sosy_lab.verifiercloud.transportable.commands.worker_to_master.RejectRunCommand;
import org.sosy_lab.verifiercloud.transportable.commands.worker_to_master.ReportWorkerCrash;
import org.sosy_lab.verifiercloud.transportable.commands.worker_to_master.RequestFileCommand;
import org.sosy_lab.verifiercloud.transportable.commands.worker_to_master.RunResultCommand;
import org.sosy_lab.verifiercloud.transportable.commands.worker_to_master.WorkerStateUpdateCommand;
import org.sosy_lab.verifiercloud.transportable.commands.worker_to_master.WorkerToMasterCommand;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.info.worker.ExecutorState;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerRuntimeInformation;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;
import org.sosy_lab.verifiercloud.worker.info.MasterStateUpdate;
import org.sosy_lab.verifiercloud.worker.network.MasterAbstraction;
import org.sosy_lab.verifiercloud.worker.network.MasterConnection;
import org.sosy_lab.verifiercloud.worker.network.WorkerAPI;

public class DefaultMasterConnection
implements MasterConnection {
    private final Logger logger;
    private final ApplicationService worker;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final ConnectionBuilder conBuilder;
    private final IncomingCommandHandler<WorkerAPI> incQueue;
    private final MasterStateUpdate stateProvider;
    private final SystemInformationProvider systemInformationProvider;
    private final Optional<String> workerId;
    private Optional<MasterAbstraction> masterAbstraction;
    private Optional<WorkerConnectionAcceptor> workerConnectionAcceptor;

    @Inject
    public DefaultMasterConnection(MasterStateUpdate stateProvider, ApplicationService worker, ConnectionBuilder conBuilder, WorkerAPI api, @Named(value="worker-id") Optional<String> workerId, Logger logger, SystemInformationProvider systemInformationProvider, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.stateProvider = Preconditions.checkNotNull(stateProvider);
        this.worker = Preconditions.checkNotNull(worker);
        this.conBuilder = Preconditions.checkNotNull(conBuilder);
        this.systemInformationProvider = systemInformationProvider;
        this.workerId = Preconditions.checkNotNull(workerId);
        this.logger = Preconditions.checkNotNull(logger);
        this.uncaughtExceptionHandler = Preconditions.checkNotNull(uncaughtExceptionHandler);
        this.incQueue = new AsyncIncomingCommandHandler<WorkerAPI>(api, uncaughtExceptionHandler, logger);
        this.masterAbstraction = Optional.absent();
        this.workerConnectionAcceptor = Optional.absent();
    }

    @Override
    public ListenableFuture<Boolean> connectToMaster() {
        WorkerConnectionAcceptor acceptor = new WorkerConnectionAcceptor();
        this.workerConnectionAcceptor = Optional.of(acceptor);
        this.conBuilder.connect(acceptor);
        this.incQueue.start();
        return acceptor.getFutureConnectionStatus();
    }

    @Override
    public void stopConnection() {
        this.incQueue.stop();
        this.conBuilder.stop();
        if (this.masterAbstraction.isPresent()) {
            this.masterAbstraction.get().terminateCommunication();
        }
        if (this.workerConnectionAcceptor.isPresent()) {
            this.workerConnectionAcceptor.get().connectionFailed(this.conBuilder.getMasterHostName(), this.conBuilder.getMasterPort(), "Master connection is stopped.");
        }
    }

    @Override
    public void sendStateUpdate(ExecutorState executorState, WorkerRuntimeInformation workerRuntimeInformation) {
        this.checkConnectionState();
        WorkerStateUpdateCommand command = new WorkerStateUpdateCommand(Preconditions.checkNotNull(executorState), Preconditions.checkNotNull(workerRuntimeInformation));
        this.masterAbstraction.get().sendCommand(command);
    }

    private void checkConnectionState() throws IllegalStateException {
        Preconditions.checkState(this.masterAbstraction.isPresent(), "There is no Master to send the message to.");
    }

    @Override
    public void sendRunResults(Run run, RunResult runResult) {
        Preconditions.checkNotNull(run);
        Preconditions.checkNotNull(runResult);
        this.checkConnectionState();
        RunResultCommand resultCommand = new RunResultCommand(run, runResult);
        this.sendCommandToMaster(resultCommand);
    }

    @Override
    public void rejectRun(Run run, String message, boolean error) {
        Preconditions.checkNotNull(run);
        Preconditions.checkNotNull(message);
        this.checkConnectionState();
        RejectRunCommand rejectRunCmd = new RejectRunCommand(run, message, error);
        this.sendCommandToMaster(rejectRunCmd);
    }

    @Override
    public void requestFile(HashCode fileHash) {
        this.checkConnectionState();
        Preconditions.checkNotNull(fileHash);
        RequestFileCommand command = new RequestFileCommand(fileHash);
        this.sendCommandToMaster(command);
    }

    @Override
    public void reportWorkerCrash(FileContent crashReport) {
        ReportWorkerCrash command = new ReportWorkerCrash(crashReport);
        this.sendCommandToMaster(command);
    }

    @Override
    public void completeInitialization() {
        Preconditions.checkState(this.workerConnectionAcceptor.isPresent());
        this.workerConnectionAcceptor.get().setInitializationCompleted();
    }

    private void sendCommandToMaster(WorkerToMasterCommand cmd) {
        Preconditions.checkState(this.masterAbstraction.isPresent());
        this.masterAbstraction.get().sendCommand(cmd);
    }

    private class WorkerConnectionAcceptor
    implements ConnectionBuilderListener {
        private final SettableFuture<Boolean> successOfConnection = SettableFuture.create();

        private WorkerConnectionAcceptor() {
        }

        ListenableFuture<Boolean> getFutureConnectionStatus() {
            return this.successOfConnection;
        }

        @Override
        public void acceptSocket(Socket socket) {
            HostInformation hostInformation;
            Preconditions.checkState(!DefaultMasterConnection.this.masterAbstraction.isPresent());
            LinkedList<MasterAbstraction.MasterEventListener> listeners = Lists.newLinkedList();
            listeners.add(new ConcreteMasterEventListener());
            try {
                hostInformation = DefaultMasterConnection.this.systemInformationProvider.getHostInformation();
            }
            catch (SystemEnvironmentException e) {
                DefaultMasterConnection.this.logger.logf(Level.SEVERE, e, "Failure to create %s: %s", MasterAbstraction.class.getCanonicalName(), e.getMessage());
                this.connectionFailed(socket.getInetAddress().getHostName(), socket.getPort(), e.getMessage());
                DefaultMasterConnection.this.worker.stop();
                return;
            }
            MasterAbstraction masterAbstraction = new MasterAbstraction(Preconditions.checkNotNull(socket), DefaultMasterConnection.this.incQueue, DefaultMasterConnection.this.stateProvider, hostInformation, DefaultMasterConnection.this.workerId, DefaultMasterConnection.this.logger, DefaultMasterConnection.this.uncaughtExceptionHandler, listeners, DefaultMasterConnection.this.worker);
            DefaultMasterConnection.this.masterAbstraction = Optional.of(masterAbstraction);
            masterAbstraction.startCommunication();
        }

        public void setInitializationCompleted() {
            this.successOfConnection.set(true);
            DefaultMasterConnection.this.workerConnectionAcceptor = Optional.absent();
        }

        @Override
        public void connectionFailed(String host, int port, String message) {
            DefaultMasterConnection.this.logger.logf(Level.SEVERE, "Cannot connect to %s:%s. %s", host, port, message);
            this.successOfConnection.set(false);
        }
    }

    private class ConcreteMasterEventListener
    implements MasterAbstraction.MasterEventListener {
        private ConcreteMasterEventListener() {
        }

        @Override
        public void masterConnectionLost() {
            DefaultMasterConnection.this.logger.logf(Level.FINE, "Connection lost.", new Object[0]);
            DefaultMasterConnection.this.worker.stop();
        }
    }
}

