/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.network;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashCode;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.inject.Inject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.Constants;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.file_storage.FileNotAvailableException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.transportable.commands.worker_to_master.SendFileCommand;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;
import org.sosy_lab.verifiercloud.worker.files.WorkerFileStorage;
import org.sosy_lab.verifiercloud.worker.info.MasterStateUpdate;
import org.sosy_lab.verifiercloud.worker.network.MasterAbstraction;
import org.sosy_lab.verifiercloud.worker.network.MasterConnection;
import org.sosy_lab.verifiercloud.worker.network.WorkerAPI;
import org.sosy_lab.verifiercloud.worker.run.WorkerModel;
import org.sosy_lab.verifiercloud.worker.run.WorkerNotAvailableException;

public class DefaultWorkerAPI
implements WorkerAPI {
    private static final TimeInterval LIVENESS_CRITERIUM = TimeInterval.seconds(Constants.WORKER_STATE_REQUEST_INTERVAL.toSeconds() * 20L);
    private final Logger logger;
    private final ApplicationService worker;
    private final MasterStateUpdate masterStateUpdate;
    private final MasterConnection masterConnection;
    private final WorkerFileStorage workerFileStorage;
    private final WorkerModel workerSystem;
    private final Timer heartbeatTimer = new Timer("HeartbeatTimer", true);
    private volatile long lastStateRequest = System.currentTimeMillis();

    @Inject
    public DefaultWorkerAPI(ApplicationService worker, WorkerModel workerSystem, WorkerFileStorage workerFileStorage, MasterStateUpdate masterStateUpdate, MasterConnection masterConnection, Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
        this.worker = Preconditions.checkNotNull(worker);
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.masterStateUpdate = Preconditions.checkNotNull(masterStateUpdate);
        this.workerFileStorage = Preconditions.checkNotNull(workerFileStorage);
        this.workerSystem = Preconditions.checkNotNull(workerSystem);
    }

    @Override
    public void requestState() {
        this.lastStateRequest = System.currentTimeMillis();
        try {
            this.masterStateUpdate.sendStateUpdateToMaster();
        }
        catch (IOException | SystemEnvironmentException e) {
            this.logger.logf(Level.SEVERE, e, "IOException: %s", e.getMessage());
            this.worker.stop();
        }
    }

    @Override
    public void assignRun(Run run, String runCollectionId, ImmutableSet<Processor> processors, ImmutableMap<Integer, MemoryUnit> memoryLimitation) {
        Preconditions.checkNotNull(run);
        Preconditions.checkNotNull(runCollectionId);
        Preconditions.checkNotNull(processors);
        Preconditions.checkNotNull(memoryLimitation);
        try {
            this.workerSystem.addRun(run, runCollectionId, processors, memoryLimitation);
            this.logger.logf(Level.INFO, "Received run %s.", run);
        }
        catch (WorkerNotAvailableException e) {
            this.logger.logf(Level.INFO, "Rejected run %s.", run);
            this.masterConnection.rejectRun(run, "Run cannot be executed, because worker is not AVAILABLE.", true);
        }
    }

    @Override
    public void sendFile(FileContent fileContent) {
        HashCode fileHash = fileContent.getFileHash();
        this.logger.logf(Level.FINER, "Received file %s", fileHash);
        try {
            this.workerFileStorage.addFile(fileContent);
        }
        catch (IOException e) {
            this.logger.logf(Level.SEVERE, e, "IOException when writing file: %s", e.getMessage());
            this.worker.stop();
        }
    }

    @Override
    public void abortRun(Run run) {
        this.workerSystem.cancelRun(run);
    }

    @Override
    public void requestResultFile(final MasterAbstraction master, final Run run, final HashCode fileHash) {
        Preconditions.checkNotNull(fileHash);
        CheckedFuture<FileContent, FileNotAvailableException> futureFile = this.workerSystem.requestFile(run, fileHash);
        Futures.addCallback(futureFile, new FutureCallback<FileContent>(){

            @Override
            public void onSuccess(FileContent file) {
                SendFileCommand cmd = new SendFileCommand(run, file);
                master.sendCommand(cmd);
            }

            @Override
            public void onFailure(Throwable t) {
                if (t instanceof FileNotFoundException) {
                    DefaultWorkerAPI.this.logger.logf(Level.SEVERE, t, "Requested file %s for %s is not available: %s", fileHash, run, t.getMessage());
                    DefaultWorkerAPI.this.masterConnection.rejectRun(run, t.getMessage(), true);
                } else {
                    DefaultWorkerAPI.this.logger.logf(Level.SEVERE, t, "Exception occured: %s", t.getMessage());
                    DefaultWorkerAPI.this.worker.stop();
                }
            }
        });
    }

    @Override
    public void finishRun(Run run) {
        this.workerSystem.finishRun(run);
    }

    @Override
    public void completeInitialization() {
        this.masterConnection.completeInitialization();
        this.heartbeatTimer.scheduleAtFixedRate((TimerTask)new CheckLivenessTask(), LIVENESS_CRITERIUM.toMilliseconds(), LIVENESS_CRITERIUM.toMilliseconds());
    }

    @Override
    public void stop() {
        this.logger.logf(Level.INFO, "Master sent shutdown command.", new Object[0]);
        this.heartbeatTimer.cancel();
        this.worker.stop();
    }

    @Override
    public void fileTransmissionError(HashCode fileHash) {
        this.logger.logf(Level.SEVERE, "Error: Requested file %d is not available on the master.", fileHash);
        this.worker.stop();
    }

    private class CheckLivenessTask
    extends TimerTask {
        private CheckLivenessTask() {
        }

        @Override
        public void run() {
            TimeInterval timeSinceLastStateRequest = TimeInterval.milliseconds(System.currentTimeMillis() - DefaultWorkerAPI.this.lastStateRequest);
            if (timeSinceLastStateRequest.compareTo(LIVENESS_CRITERIUM) > 0) {
                DefaultWorkerAPI.this.worker.stop();
            }
        }
    }
}

