/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.network;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.Socket;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.networking.interaction.AsyncIncomingCommandHandler;
import org.sosy_lab.verifiercloud.global.networking.interaction.ConnectionListener;
import org.sosy_lab.verifiercloud.global.networking.interaction.IncomingCommandHandler;
import org.sosy_lab.verifiercloud.global.networking.interaction.NetworkAbstraction;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_worker.MasterToWorkerCommand;
import org.sosy_lab.verifiercloud.transportable.commands.worker_to_master.WorkerStartedCommand;
import org.sosy_lab.verifiercloud.transportable.commands.worker_to_master.WorkerToMasterCommand;
import org.sosy_lab.verifiercloud.transportable.info.worker.ExecutorState;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerRuntimeInformation;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.worker.info.MasterStateUpdate;
import org.sosy_lab.verifiercloud.worker.network.WorkerAPI;

public class MasterAbstraction
extends NetworkAbstraction<MasterToWorkerCommand, WorkerToMasterCommand, WorkerAPI> {
    private final ApplicationService worker;
    private final Logger logger;
    private final AsyncIncomingCommandHandler<WorkerAPI> incomingCommandHandler;
    private final MasterStateUpdate stateProvider;
    private final List<MasterEventListener> listeners = Lists.newCopyOnWriteArrayList();
    private final HostInformation hostInformation;
    private final Optional<String> workerId;

    public MasterAbstraction(Socket masterSocket, IncomingCommandHandler<WorkerAPI> incQueue, MasterStateUpdate stateProvider, HostInformation hostInformation, Optional<String> workerId, Logger logger, Thread.UncaughtExceptionHandler exceptionHandler, List<MasterEventListener> listeners, ApplicationService worker) {
        super(masterSocket, exceptionHandler, logger, MasterToWorkerCommand.class);
        this.addConnectionListener(new MasterConnectionListener());
        this.logger = Preconditions.checkNotNull(logger);
        this.worker = Preconditions.checkNotNull(worker);
        this.incomingCommandHandler = (AsyncIncomingCommandHandler)Preconditions.checkNotNull(incQueue);
        this.stateProvider = Preconditions.checkNotNull(stateProvider);
        this.workerId = Preconditions.checkNotNull(workerId);
        this.hostInformation = Preconditions.checkNotNull(hostInformation);
        this.listeners.addAll(listeners);
    }

    @Override
    public void startCommunication() {
        WorkerRuntimeInformation workerRuntimeInformation;
        super.startCommunication();
        ExecutorState initialState = this.stateProvider.collectExecutorState();
        try {
            workerRuntimeInformation = this.stateProvider.collectRuntimeInformation();
        }
        catch (SystemEnvironmentException e) {
            this.logger.logf(Level.SEVERE, e, "Exception: %s", e.getMessage());
            this.worker.stop();
            return;
        }
        WorkerStartedCommand command = new WorkerStartedCommand(this.hostInformation, initialState, this.workerId, workerRuntimeInformation);
        this.sendCommand(command);
    }

    public static interface MasterEventListener {
        public void masterConnectionLost();
    }

    private class MasterConnectionListener
    implements ConnectionListener<MasterToWorkerCommand> {
        private MasterConnectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionClosed() {
            List list = MasterAbstraction.this.listeners;
            synchronized (list) {
                for (MasterEventListener listener : MasterAbstraction.this.listeners) {
                    listener.masterConnectionLost();
                }
            }
        }

        @Override
        public void messageReceived(MasterToWorkerCommand message) {
            MasterAbstraction.this.incomingCommandHandler.addCommand(MasterAbstraction.this, message);
        }
    }
}

