/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.network;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.worker.info.MasterStateUpdate;
import org.sosy_lab.verifiercloud.worker.run.WorkerStateListener;

public class WorkerStateChangeSender
implements WorkerStateListener {
    private final Logger logger;
    private final MasterStateUpdate masterStateUpdate;

    @Inject
    public WorkerStateChangeSender(MasterStateUpdate masterStateUpdate, Logger logger) {
        this.masterStateUpdate = Preconditions.checkNotNull(masterStateUpdate);
        this.logger = logger;
    }

    @Override
    public void stateChanged() {
        try {
            this.masterStateUpdate.sendStateUpdateToMaster();
        }
        catch (IOException | SystemEnvironmentException e) {
            this.logger.logf(Level.SEVERE, e, "IOException: %s", e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

