/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.run;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.file_storage.FileNotAvailableException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.global.util.system.UserInformationProvider;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionState;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerState;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;
import org.sosy_lab.verifiercloud.worker.run.Executor;
import org.sosy_lab.verifiercloud.worker.run.PartitionStateListener;
import org.sosy_lab.verifiercloud.worker.run.WorkerModel;
import org.sosy_lab.verifiercloud.worker.run.WorkerNotAvailableException;
import org.sosy_lab.verifiercloud.worker.run.WorkerStateListener;
import org.sosy_lab.verifiercloud.worker.run.state_machine.WorkerPartition;

public class DelegatingWorkerModel
implements WorkerModel {
    private static final TimeInterval CHECK_INTERVAL = TimeInterval.seconds(2L);
    private final Executor executor;
    private final AtomicBoolean usercheck;
    private final UserInformationProvider userInformationProvider;
    private final Logger logger;
    private volatile WorkerState state;
    private final List<WorkerStateListener> listeners;
    private final Timer heartbeatTimer;

    @Inject
    public DelegatingWorkerModel(Executor executor, Logger logger, @Named(value="stop-worker-on-userlogin") Boolean usercheck, UserInformationProvider userInformationProvider) {
        this.executor = Preconditions.checkNotNull(executor);
        this.logger = Preconditions.checkNotNull(logger);
        this.userInformationProvider = Preconditions.checkNotNull(userInformationProvider);
        this.usercheck = new AtomicBoolean(usercheck);
        this.listeners = Lists.newCopyOnWriteArrayList();
        executor.registerStateListener(new ErrorStateCheckingAndForwardingListener());
        this.state = WorkerState.INITIALIZING;
        this.heartbeatTimer = new Timer(true);
        Verify.verifyNotNull(this.state);
    }

    @Override
    public void finishInitialization() {
        boolean occupiedByUser;
        Preconditions.checkState(this.getWorkerState().equals((Object)WorkerState.INITIALIZING));
        try {
            occupiedByUser = this.usercheck.get() && this.userInformationProvider.isOtherUserLoggedIn();
        }
        catch (SystemEnvironmentException e) {
            this.logger.logf(Level.WARNING, e, "Users cannot be determined.", new Object[0]);
            occupiedByUser = true;
        }
        this.changeState(occupiedByUser ? WorkerState.USER_OCCUPIED : WorkerState.AVAILABLE);
        this.heartbeatTimer.schedule((TimerTask)new CheckUserRunnable(), 0L, CHECK_INTERVAL.toMilliseconds());
    }

    @Override
    public WorkerState getWorkerState() {
        return this.state;
    }

    @Override
    public void registerStateChangeListener(WorkerStateListener listener) {
        this.listeners.add(Preconditions.checkNotNull(listener));
    }

    @Override
    public void setUsercheck(boolean active) {
        if (!this.usercheck.compareAndSet(active, active)) {
            this.logger.logf(Level.FINER, "Usercheck is now %s.", active ? "active" : "inactive");
        }
    }

    @Override
    public boolean isUsercheckActive() {
        return this.usercheck.get();
    }

    @Override
    public void stop() {
        this.heartbeatTimer.cancel();
        this.state = WorkerState.STOPPING;
        this.executor.stop();
    }

    @Override
    public void addRun(Run run, String runCollectionId, ImmutableSet<Processor> processors, ImmutableMap<Integer, MemoryUnit> memoryLimitation) throws WorkerNotAvailableException {
        if (this.state == WorkerState.AVAILABLE) {
            try {
                this.executor.addRun(run, runCollectionId, processors, memoryLimitation);
            }
            catch (SystemEnvironmentException e) {
                this.logger.logf(Level.SEVERE, e, "Error during partition preparation: %s", e.getMessage());
                this.changeState(WorkerState.ERROR);
            }
        } else {
            throw new WorkerNotAvailableException();
        }
    }

    @Override
    public CheckedFuture<FileContent, FileNotAvailableException> requestFile(Run run, HashCode fileHash) {
        return this.executor.requestFile(run, fileHash);
    }

    @Override
    public void finishRun(Run run) {
        this.executor.finishRun(run);
    }

    @Override
    public void cancelRun(Run run) {
        this.logger.logf(Level.INFO, "Canceling %s.", run);
        this.executor.cancelRun(run);
    }

    private void changeState(WorkerState newState) {
        this.state = Preconditions.checkNotNull(newState);
        for (WorkerStateListener listener : this.listeners) {
            listener.stateChanged();
        }
    }

    private class CheckUserRunnable
    extends TimerTask {
        private CheckUserRunnable() {
        }

        @Override
        public void run() {
            boolean occupiedByUser;
            boolean workerMarkedOccupied;
            boolean bl = workerMarkedOccupied = DelegatingWorkerModel.this.state == WorkerState.USER_OCCUPIED;
            if (!DelegatingWorkerModel.this.isUsercheckActive()) {
                if (workerMarkedOccupied) {
                    this.markAsFree();
                }
                return;
            }
            try {
                occupiedByUser = DelegatingWorkerModel.this.userInformationProvider.isOtherUserLoggedIn();
            }
            catch (SystemEnvironmentException e) {
                DelegatingWorkerModel.this.logger.logf(Level.WARNING, e, "Unable to read user information because %s", e.getMessage());
                occupiedByUser = true;
            }
            if (workerMarkedOccupied && !occupiedByUser) {
                this.markAsFree();
            } else if (!workerMarkedOccupied && occupiedByUser) {
                this.markAsOccupied();
            }
        }

        private void markAsOccupied() {
            DelegatingWorkerModel.this.logger.logf(Level.INFO, "Computer is used by other users.", new Object[0]);
            DelegatingWorkerModel.this.changeState(WorkerState.USER_OCCUPIED);
            DelegatingWorkerModel.this.executor.release();
        }

        private void markAsFree() {
            DelegatingWorkerModel.this.logger.logf(Level.INFO, "Computer is no longer used by other users.", new Object[0]);
            DelegatingWorkerModel.this.changeState(WorkerState.AVAILABLE);
        }
    }

    private class ErrorStateCheckingAndForwardingListener
    implements PartitionStateListener {
        private ErrorStateCheckingAndForwardingListener() {
        }

        @Override
        public void stateChanged(WorkerPartition partition) {
            if (partition.getCurrentState() == WorkerPartitionState.ERROR) {
                DelegatingWorkerModel.this.state = WorkerState.ERROR;
            }
            for (WorkerStateListener listener : DelegatingWorkerModel.this.listeners) {
                listener.stateChanged();
            }
        }
    }
}

