/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.run;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.sosy_lab.verifiercloud.global.file_storage.FileNotAvailableException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.info.worker.ExecutorState;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionInformation;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionState;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.worker.files.WorkerFileStorage;
import org.sosy_lab.verifiercloud.worker.network.MasterConnection;
import org.sosy_lab.verifiercloud.worker.run.Executor;
import org.sosy_lab.verifiercloud.worker.run.PartitionStateListener;
import org.sosy_lab.verifiercloud.worker.run.energy.EnergyMeasurement;
import org.sosy_lab.verifiercloud.worker.run.energy.NullEnergyMeasurement;
import org.sosy_lab.verifiercloud.worker.run.state_machine.DefaultWorkerPartition;
import org.sosy_lab.verifiercloud.worker.run.state_machine.WorkerPartition;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.CancelRunEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.FinishedRunEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.PrepareRunEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.ReleaseEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.RequestFileEvent;

public class StateBasedExecutor
implements Executor {
    private final Map<Run, WorkerPartition> partitions = Collections.synchronizedMap(new HashMap());
    private final WorkerFileStorage workerFileStorage;
    private final MasterConnection masterConnection;
    private final boolean suppressCleanup;
    private final int maxRunResultFiles;
    private final Logger logger;
    private final List<PartitionStateListener> partitionStateListener = Lists.newCopyOnWriteArrayList();
    private final SystemInformationProvider systemInformationProvider;
    private final ExecutorService eventHandler;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private final EnergyMeasurement energyMeasurement = new NullEnergyMeasurement();
    private volatile boolean stopped = false;

    @Inject
    public StateBasedExecutor(MasterConnection masterConnection, SystemInformationProvider sysInfoProvider, Logger logger, WorkerFileStorage workerFileStorage, Thread.UncaughtExceptionHandler exceptionHandler, @Named(value="no-cleanup") boolean suppressCleanup, @Named(value="max-run-result-files") Integer maxRunResultFiles) {
        this.workerFileStorage = Preconditions.checkNotNull(workerFileStorage);
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.suppressCleanup = suppressCleanup;
        this.maxRunResultFiles = maxRunResultFiles;
        this.logger = Preconditions.checkNotNull(logger);
        this.exceptionHandler = exceptionHandler;
        this.systemInformationProvider = Preconditions.checkNotNull(sysInfoProvider);
        this.partitionStateListener.add(new PartionsCleaner());
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(DefaultWorkerPartition.class.getSimpleName() + "-EventHandler-%d").setUncaughtExceptionHandler(exceptionHandler);
        this.eventHandler = Executors.newSingleThreadExecutor(tfb.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorState getExecutorState() {
        Map<Run, WorkerPartition> map = this.partitions;
        synchronized (map) {
            FluentIterable<WorkerPartitionInformation> partitions = FluentIterable.from(this.partitions.values()).transform(new ExtractPartitionInformationFunction());
            return new ExecutorState(partitions);
        }
    }

    @Override
    public void registerStateListener(PartitionStateListener listener) {
        this.partitionStateListener.add(Preconditions.checkNotNull(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        CancelRunEvent event = new CancelRunEvent();
        StateBasedExecutor stateBasedExecutor = this;
        synchronized (stateBasedExecutor) {
            this.stopped = true;
        }
        ImmutableList<WorkerPartition> partitions = ImmutableList.copyOf(this.partitions.values());
        for (WorkerPartition partition : partitions) {
            partition.addEvent(event);
        }
        while (true) {
            try {
                while (this.partitions.size() != 0) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
        this.eventHandler.shutdown();
        while (true) {
            try {
                while (!this.eventHandler.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS)) {
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRun(Run run, String runCollectionId, ImmutableSet<Processor> processors, ImmutableMap<Integer, MemoryUnit> memoryLimitation) throws SystemEnvironmentException {
        Preconditions.checkArgument(!processors.isEmpty());
        HostInformation hostInfo = this.systemInformationProvider.getHostInformation();
        DefaultWorkerPartition newPartition = new DefaultWorkerPartition(this.partitionStateListener, runCollectionId, processors, memoryLimitation, hostInfo, this.eventHandler, this.workerFileStorage, this.masterConnection, this.exceptionHandler, this.suppressCleanup, this.maxRunResultFiles, this.energyMeasurement, this.logger);
        StateBasedExecutor stateBasedExecutor = this;
        synchronized (stateBasedExecutor) {
            if (!this.stopped) {
                this.partitions.put(run, newPartition);
                this.logger.logf(Level.INFO, "Created partition %s for %s.", newPartition.getId(), run);
                newPartition.addEvent(new PrepareRunEvent(run));
            } else {
                this.masterConnection.rejectRun(run, "Stopping worker cannot proecess a new run.", false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckedFuture<FileContent, FileNotAvailableException> requestFile(Run run, final HashCode fileHash) {
        Map<Run, WorkerPartition> map = this.partitions;
        synchronized (map) {
            if (!this.partitions.containsKey(run)) {
                return Futures.immediateFailedCheckedFuture(new FileNotAvailableException(fileHash, run + " is unknown."));
            }
            SettableFuture<FileContent> futureFileContent = SettableFuture.create();
            RequestFileEvent event = new RequestFileEvent(fileHash, futureFileContent);
            this.partitions.get(run).addEvent(event);
            return Futures.makeChecked(futureFileContent, new Function<Exception, FileNotAvailableException>(){

                @Override
                public FileNotAvailableException apply(Exception cause) {
                    return new FileNotAvailableException(fileHash, (Throwable)cause);
                }
            });
        }
    }

    @Override
    public void finishRun(Run run) {
        FinishedRunEvent event = new FinishedRunEvent();
        WorkerPartition partition = this.partitions.get(run);
        if (partition != null) {
            partition.addEvent(event);
        }
    }

    @Override
    public void cancelRun(Run run) {
        CancelRunEvent event = new CancelRunEvent();
        WorkerPartition partition = this.partitions.get(run);
        if (partition != null) {
            partition.addEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        ImmutableList<WorkerPartition> partitions;
        ReleaseEvent event;
        ReleaseEvent releaseEvent = event = new ReleaseEvent();
        synchronized (releaseEvent) {
            partitions = ImmutableList.copyOf(this.partitions.values());
        }
        for (WorkerPartition partition : partitions) {
            partition.addEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performPartitionsCleanup() {
        Map<Run, WorkerPartition> map = this.partitions;
        synchronized (map) {
            Iterator<Run> activeRunsIt = this.partitions.keySet().iterator();
            while (activeRunsIt.hasNext()) {
                Run run = activeRunsIt.next();
                WorkerPartition partition = this.partitions.get(run);
                if (partition.getCurrentState() != WorkerPartitionState.EXECUTION_STOPPED && partition.getCurrentState() != WorkerPartitionState.ERROR) continue;
                activeRunsIt.remove();
            }
        }
    }

    private class PartionsCleaner
    implements PartitionStateListener {
        private PartionsCleaner() {
        }

        @Override
        public void stateChanged(WorkerPartition partition) {
            StateBasedExecutor.this.performPartitionsCleanup();
        }
    }

    private static final class ExtractPartitionInformationFunction
    implements Function<WorkerPartition, WorkerPartitionInformation> {
        private ExtractPartitionInformationFunction() {
        }

        @Override
        public WorkerPartitionInformation apply(@Nonnull WorkerPartition partition) {
            Preconditions.checkNotNull(partition);
            return partition.getInformation();
        }
    }
}

