/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.run.energy;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.sosy_lab.verifiercloud.global.util.system.EnergyProvider;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionState;
import org.sosy_lab.verifiercloud.transportable.units.energy.Energy;
import org.sosy_lab.verifiercloud.worker.run.energy.EnergyMeasurement;
import org.sosy_lab.verifiercloud.worker.run.state_machine.WorkerPartition;

public class DefaultEnergyMeasurement
implements EnergyMeasurement {
    private final EnergyProvider energyProvider;
    private final Map<WorkerPartition, Energy> currentRuns = Maps.newConcurrentMap();
    private AtomicLong lastMeasurementInMilliJoule = new AtomicLong();

    @Inject
    public DefaultEnergyMeasurement(EnergyProvider energyProvider) {
        this.energyProvider = Preconditions.checkNotNull(energyProvider);
    }

    @Override
    public synchronized void stateChanged(WorkerPartition partition) {
        WorkerPartitionState partitionState = partition.getCurrentState();
        switch (partitionState) {
            case PROCESSING_RUN: {
                Preconditions.checkState(!this.currentRuns.containsKey(partition));
                this.updateEnergy();
                this.currentRuns.put(partition, Energy.joule(0L));
                break;
            }
            case EXECUTION_STOPPED: {
                this.currentRuns.remove(partition);
                break;
            }
        }
    }

    private synchronized void updateEnergy() {
        long energyValueInMilliJoule;
        try {
            energyValueInMilliJoule = this.energyProvider.getEnergyValueInMilliJoule();
        }
        catch (SystemEnvironmentException e) {
            this.currentRuns.clear();
            return;
        }
        if (!this.currentRuns.isEmpty()) {
            long sharePerPartitionInMilliJoule = this.overflowAwareSubstraction(energyValueInMilliJoule, this.lastMeasurementInMilliJoule.get());
            for (Map.Entry<WorkerPartition, Energy> entry : this.currentRuns.entrySet()) {
                long oldEnergyInMilliJoule = entry.getValue().toMilliJoule();
                entry.setValue(Energy.milliJoule(oldEnergyInMilliJoule + sharePerPartitionInMilliJoule));
            }
        }
        this.lastMeasurementInMilliJoule.set(energyValueInMilliJoule);
    }

    private long overflowAwareSubstraction(long minuend, long subtrahend) {
        if (minuend >= subtrahend) {
            return minuend - subtrahend;
        }
        long maxValue = 65533595L;
        return 65533595L + minuend - subtrahend;
    }

    @Override
    public synchronized Optional<Energy> stopEnergyMeasurement(WorkerPartition partition) {
        if (this.currentRuns.containsKey(partition)) {
            this.updateEnergy();
            Energy priorEnergy = this.currentRuns.remove(partition);
            return Optional.of(priorEnergy);
        }
        return Optional.absent();
    }
}

