/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.run.program_environment;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Set;
import org.sosy_lab.verifiercloud.global.util.HashUtils;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based.DefaultFileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.tree_based.TreeFileHierarchyBuilder;
import org.sosy_lab.verifiercloud.worker.run.program_environment.TooManyResultFilesException;

class DiffFileLister
implements FileVisitor<Path> {
    private final Path basePath;
    private final Set<Path> pathsToIgnore;
    private final int maxRunResultFiles;
    private final TreeFileHierarchyBuilder tfBuilder = new TreeFileHierarchyBuilder();

    public DiffFileLister(Path basePath, Set<Path> pathsToIgnore, int maxRunResultFiles) {
        Preconditions.checkNotNull(basePath);
        Preconditions.checkArgument(Files.exists(basePath, new LinkOption[0]));
        this.basePath = basePath;
        this.pathsToIgnore = Preconditions.checkNotNull(pathsToIgnore);
        this.maxRunResultFiles = maxRunResultFiles;
    }

    public Iterable<FileAtRelativePath> getNewFiles() throws IOException, TooManyResultFilesException {
        Files.walkFileTree(this.basePath, this);
        if (this.tfBuilder.size() > this.maxRunResultFiles) {
            throw new TooManyResultFilesException();
        }
        return this.tfBuilder.build();
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Path relFilePath = this.basePath.relativize(file);
        if (!this.pathsToIgnore.contains(relFilePath)) {
            HashCode fileHash = HashUtils.hashFile(file);
            DefaultFileAtRelativePath fileAtRelativePath = new DefaultFileAtRelativePath(fileHash, relFilePath.toString());
            this.tfBuilder.addProgramFiles(fileAtRelativePath);
        }
        if (this.tfBuilder.size() > this.maxRunResultFiles) {
            return FileVisitResult.TERMINATE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

