/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.run.state_machine;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionInformation;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionState;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.worker.files.WorkerFileStorage;
import org.sosy_lab.verifiercloud.worker.network.MasterConnection;
import org.sosy_lab.verifiercloud.worker.run.PartitionStateListener;
import org.sosy_lab.verifiercloud.worker.run.energy.EnergyMeasurement;
import org.sosy_lab.verifiercloud.worker.run.state_machine.WorkerPartition;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.Event;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.InitializeExecutionState;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.State;

public class DefaultWorkerPartition
implements WorkerPartition {
    private final Logger logger;
    private static final AtomicInteger idCounter = new AtomicInteger(0);
    private final int id;
    private final String runCollectionId;
    private final ImmutableSet<Processor> reservedProcessors;
    private final ImmutableMap<Integer, MemoryUnit> reservedMemory;
    private volatile State state;
    private final List<PartitionStateListener> stateChangeListeners;
    private final Executor eventHandler;

    public DefaultWorkerPartition(Iterable<PartitionStateListener> listeners, String runCollectionId, ImmutableSet<Processor> reservedProcessors, ImmutableMap<Integer, MemoryUnit> memoryLimitation, HostInformation hostInformation, ExecutorService eventHandler, WorkerFileStorage fileStorage, MasterConnection masterConnection, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, boolean suppressCleanup, int maxRunResultFiles, EnergyMeasurement energy, Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
        this.id = idCounter.getAndIncrement();
        this.runCollectionId = runCollectionId;
        Preconditions.checkArgument(reservedProcessors.size() >= 1);
        this.reservedProcessors = reservedProcessors;
        Preconditions.checkNotNull(memoryLimitation);
        Preconditions.checkArgument(!memoryLimitation.isEmpty());
        this.reservedMemory = memoryLimitation;
        this.stateChangeListeners = ImmutableList.copyOf(listeners);
        this.state = new InitializeExecutionState(fileStorage, this, masterConnection, hostInformation, uncaughtExceptionHandler, suppressCleanup, maxRunResultFiles, energy, logger);
        this.eventHandler = eventHandler;
    }

    @Override
    public synchronized void addEvent(final Event event) {
        Preconditions.checkNotNull(event);
        this.eventHandler.execute(new Runnable(){

            @Override
            public void run() {
                State statePriorToEvent = DefaultWorkerPartition.this.state;
                DefaultWorkerPartition.this.state = event.accept(DefaultWorkerPartition.this.state);
                Preconditions.checkState(DefaultWorkerPartition.this.state == statePriorToEvent || !DefaultWorkerPartition.this.state.equals(statePriorToEvent), "%s state changed to itself with a new state-object.", DefaultWorkerPartition.this.state);
                if (DefaultWorkerPartition.this.state != statePriorToEvent) {
                    DefaultWorkerPartition.this.state.onEntry();
                    DefaultWorkerPartition.this.informAboutStateChange();
                }
            }
        });
    }

    private void informAboutStateChange() {
        this.logger.logf(Level.INFO, "Partition %s state changed to %s.", new Object[]{this.getId(), this.getCurrentState()});
        for (PartitionStateListener stateChangeListener : this.stateChangeListeners) {
            stateChangeListener.stateChanged(this);
        }
    }

    @Override
    public synchronized WorkerPartitionState getCurrentState() {
        return this.state.getState();
    }

    @Override
    public int getNumberOfReservedProcessors() {
        return this.reservedProcessors.size();
    }

    @Override
    public Set<Processor> getReservedProcessors() {
        return this.reservedProcessors;
    }

    @Override
    public ImmutableMap<Integer, MemoryUnit> getReservedMemory() {
        return this.reservedMemory;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getRunCollectionId() {
        return this.runCollectionId;
    }

    @Override
    public WorkerPartitionInformation getInformation() {
        return new WorkerPartitionInformation(this.getId(), this.getCurrentState(), this.getReservedMemory(), this.getNumberOfReservedProcessors(), this.getRunCollectionId());
    }
}

