/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.run.state_machine.events;

import com.google.common.base.Preconditions;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;
import org.sosy_lab.verifiercloud.worker.run.program_environment.ProgramEnvironment;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.Event;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.State;

public class ExecutedRunEvent
implements Event {
    private final Run run;
    private final ProgramEnvironment programEnvironment;
    private final int exitValue;
    private final TimeInterval walltime;
    private final boolean processWasKilled;

    public ExecutedRunEvent(Run run, int exitValue, TimeInterval walltime, boolean processWasKilled, ProgramEnvironment programEnvironment) {
        this.run = Preconditions.checkNotNull(run);
        this.programEnvironment = Preconditions.checkNotNull(programEnvironment);
        Preconditions.checkArgument(exitValue >= 0 && exitValue < 256);
        this.exitValue = exitValue;
        this.walltime = Preconditions.checkNotNull(walltime);
        this.processWasKilled = this.wasProcessKilled();
    }

    @Override
    public State accept(State state) {
        return state.process(this);
    }

    public Run getRun() {
        return this.run;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public TimeInterval getWalltime() {
        return this.walltime;
    }

    public boolean wasProcessKilled() {
        return this.processWasKilled;
    }

    public ProgramEnvironment getProgramEnvironment() {
        return this.programEnvironment;
    }
}

