/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.run.state_machine.states;

import com.google.common.base.Preconditions;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.worker.network.MasterConnection;
import org.sosy_lab.verifiercloud.worker.run.energy.EnergyMeasurement;
import org.sosy_lab.verifiercloud.worker.run.state_machine.WorkerPartition;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.CancelRunEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.ExecutedRunEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.FinishedRunEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.PrepareRunEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.ReleaseEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.RequestFileEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.RunPreparedEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.StoppedEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.UnhandledProblemEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.ErrorState;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.ExecutionEndedState;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.State;

public abstract class AbstractState
implements State {
    private final Logger logger;
    private final MasterConnection masterConnection;
    private final HostInformation hostInformation;
    private final WorkerPartition stateMachine;
    private final EnergyMeasurement energyMeasurement;

    AbstractState(WorkerPartition stateMachine, MasterConnection masterConnection, HostInformation hostInformation, EnergyMeasurement energyMeasurement, Logger logger) {
        this.stateMachine = Preconditions.checkNotNull(stateMachine);
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.hostInformation = Preconditions.checkNotNull(hostInformation);
        this.energyMeasurement = Preconditions.checkNotNull(energyMeasurement);
        this.logger = Preconditions.checkNotNull(logger);
    }

    MasterConnection getMasterConnection() {
        return this.masterConnection;
    }

    WorkerPartition getStateMachine() {
        return this.stateMachine;
    }

    HostInformation getHostInformation() {
        return this.hostInformation;
    }

    Logger getLogger() {
        return this.logger;
    }

    EnergyMeasurement getEnergyMeasurement() {
        return this.energyMeasurement;
    }

    @Override
    public void onEntry() {
    }

    @Override
    public State process(ReleaseEvent releaseEvent) {
        return this.createErrorState(releaseEvent);
    }

    @Override
    public State process(CancelRunEvent cancelRunEvent) {
        return this.createErrorState(cancelRunEvent);
    }

    @Override
    public State process(StoppedEvent stoppedEvent) {
        return this.createErrorState(stoppedEvent);
    }

    @Override
    public State process(PrepareRunEvent preparationEvent) {
        return this.createErrorState(preparationEvent);
    }

    @Override
    public State process(RunPreparedEvent runPreparedEvent) {
        return this.createErrorState(runPreparedEvent);
    }

    @Override
    public State process(ExecutedRunEvent executedRunEvent) {
        return this.createErrorState(executedRunEvent);
    }

    @Override
    public State process(RequestFileEvent requestFileEvent) {
        return this.createErrorState(requestFileEvent);
    }

    @Override
    public State process(FinishedRunEvent finishedRunEvent) {
        return this.createErrorState(finishedRunEvent);
    }

    @Override
    public State process(UnhandledProblemEvent unhandledProblemEvent) {
        return this.createErrorState(unhandledProblemEvent);
    }

    ErrorState createErrorState(Object event) {
        this.logger.logf(Level.SEVERE, "Change to error state initated by %s.", event);
        return new ErrorState(this.stateMachine, this.masterConnection, this.getHostInformation(), this.energyMeasurement, this.logger);
    }

    State createExecutionEndedState() {
        return new ExecutionEndedState(this.stateMachine, this.masterConnection, this.getHostInformation(), this.energyMeasurement, this.logger);
    }
}

