/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.run.state_machine.states;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.file_storage.FileNotAvailableException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.FileUtils;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.filecontent.EmptyFileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionState;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;
import org.sosy_lab.verifiercloud.transportable.run.filters.FileFilter;
import org.sosy_lab.verifiercloud.transportable.units.energy.Energy;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;
import org.sosy_lab.verifiercloud.worker.network.MasterConnection;
import org.sosy_lab.verifiercloud.worker.run.energy.EnergyMeasurement;
import org.sosy_lab.verifiercloud.worker.run.program_environment.ProgramEnvironment;
import org.sosy_lab.verifiercloud.worker.run.program_environment.TooManyResultFilesException;
import org.sosy_lab.verifiercloud.worker.run.state_machine.WorkerPartition;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.CancelRunEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.FinishedRunEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.ReleaseEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.RequestFileEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.UnhandledProblemEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.AbstractState;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.State;

public class FinishingRunState
extends AbstractState
implements State {
    private final Run run;
    private final ProgramEnvironment programEnvironment;
    private final int pythonExitCode;
    private final TimeInterval outerWalltime;
    private final boolean processWasKilled;

    FinishingRunState(Run run, int pythonExitCode, TimeInterval outerWalltime, ProgramEnvironment programEnvironment, WorkerPartition stateMachine, MasterConnection masterConnection, HostInformation hostInformation, EnergyMeasurement energy, boolean processWasKilled, Logger logger) {
        super(stateMachine, masterConnection, hostInformation, energy, logger);
        this.outerWalltime = outerWalltime;
        this.run = Preconditions.checkNotNull(run);
        this.pythonExitCode = pythonExitCode;
        this.programEnvironment = Preconditions.checkNotNull(programEnvironment);
        this.processWasKilled = processWasKilled;
    }

    @Override
    public void onEntry() {
        ImmutableMap<String, String> runInformation;
        int exitCode;
        TimeInterval wallTime;
        Collection<FileAtRelativePath> filesToReturn;
        Iterable<FileAtRelativePath> allNewFiles;
        FileContent pythonWarnings;
        FileContent pythonStdout;
        try {
            pythonStdout = FileUtils.getFileContent(this.programEnvironment.getStdoutFile());
        }
        catch (IOException e) {
            this.getLogger().logf(Level.WARNING, e, "%s when reading output file: %s", e.getClass().getSimpleName(), e.getMessage());
            pythonStdout = new EmptyFileContent();
        }
        try {
            pythonWarnings = FileUtils.getFileContent(this.programEnvironment.getStderrFile());
        }
        catch (IOException e) {
            this.getLogger().logf(Level.WARNING, e, "%s when reading output file: %s", e.getClass().getSimpleName(), e.getMessage());
            pythonWarnings = new EmptyFileContent();
        }
        if (this.pythonExitCode != 0) {
            Exception cause = new Exception("Python wrapper's exit code: " + this.pythonExitCode + "\n\n" + pythonStdout.getContent() + "\n\n" + pythonWarnings.getContent() + "\n\n");
            UnhandledProblemEvent event = new UnhandledProblemEvent(cause);
            this.getStateMachine().addEvent(event);
            return;
        }
        try {
            allNewFiles = this.programEnvironment.getNewFiles();
            filesToReturn = this.collectAndFilterResultFiles(allNewFiles);
            wallTime = this.programEnvironment.getWallTime();
            exitCode = this.programEnvironment.getExitCode();
            runInformation = this.programEnvironment.getRunInfo();
        }
        catch (IOException e) {
            this.getLogger().logf(Level.SEVERE, e, "%s when reading data output file: %s", e.getClass().getSimpleName(), e.getMessage());
            UnhandledProblemEvent gotoErrorEvent = new UnhandledProblemEvent(e);
            this.getStateMachine().addEvent(gotoErrorEvent);
            return;
        }
        catch (TooManyResultFilesException e) {
            this.getMasterConnection().rejectRun(this.run, "Too many result files.", true);
            this.getStateMachine().addEvent(new FinishedRunEvent());
            return;
        }
        Optional<Energy> energy = this.getEnergyMeasurement().stopEnergyMeasurement(this.getStateMachine());
        RunResult runResult = new RunResult(this.run, exitCode, this.outerWalltime, wallTime, runInformation, pythonWarnings, filesToReturn, allNewFiles, energy, this.getHostInformation(), this.processWasKilled);
        this.getMasterConnection().sendRunResults(this.run, runResult);
    }

    private Collection<FileAtRelativePath> collectAndFilterResultFiles(Iterable<FileAtRelativePath> allNewFiles) throws IOException {
        ArrayList<FileAtRelativePath> files = Lists.newArrayList();
        FileFilter filter = this.run.getOutputFilePattern();
        for (FileAtRelativePath outputFile : allNewFiles) {
            if (!filter.isFileMatched(outputFile)) continue;
            files.add(outputFile);
        }
        return files;
    }

    @Override
    public State process(RequestFileEvent requestFileEvent) {
        HashCode fileHash = requestFileEvent.getFileHash();
        SettableFuture<FileContent> futureFile = requestFileEvent.getFuture();
        try {
            FileContent fileContent = this.programEnvironment.getNewFile(fileHash);
            futureFile.set(fileContent);
        }
        catch (IOException | FileNotAvailableException e) {
            futureFile.setException(e);
            return this.createErrorState(e);
        }
        return this;
    }

    @Override
    public State process(ReleaseEvent releaseEvent) {
        return this;
    }

    @Override
    public State process(FinishedRunEvent finishedRunEvent) {
        this.programEnvironment.cleanUp();
        return this.createExecutionEndedState();
    }

    @Override
    public State process(CancelRunEvent cancelRunEvent) {
        this.programEnvironment.cleanUp();
        this.getMasterConnection().rejectRun(this.run, "Run canceled.", false);
        return this.createExecutionEndedState();
    }

    @Override
    public State process(UnhandledProblemEvent unhandledProblemEvent) {
        String errorMessage = unhandledProblemEvent.getCause().getMessage();
        this.getMasterConnection().rejectRun(this.run, errorMessage, true);
        this.programEnvironment.cleanUp();
        return super.process(unhandledProblemEvent);
    }

    @Override
    public WorkerPartitionState getState() {
        return WorkerPartitionState.FINISHING_RUN;
    }
}

