/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.run.state_machine.states;

import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionState;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.worker.files.WorkerFileStorage;
import org.sosy_lab.verifiercloud.worker.network.MasterConnection;
import org.sosy_lab.verifiercloud.worker.run.energy.EnergyMeasurement;
import org.sosy_lab.verifiercloud.worker.run.state_machine.WorkerPartition;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.CancelRunEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.PrepareRunEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.ReleaseEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.AbstractState;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.PreparingRunState;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.State;

public class InitializeExecutionState
extends AbstractState {
    private final WorkerFileStorage fileStorage;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final boolean suppressCleanup;
    private final int maxRunResultFiles;

    public InitializeExecutionState(WorkerFileStorage fileStorage, WorkerPartition stateMachine, MasterConnection masterConnection, HostInformation hostInfo, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, boolean suppressCleanup, int maxRunResultFiles, EnergyMeasurement energy, Logger logger) {
        super(stateMachine, masterConnection, hostInfo, energy, logger);
        this.fileStorage = fileStorage;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.suppressCleanup = suppressCleanup;
        this.maxRunResultFiles = maxRunResultFiles;
    }

    @Override
    public State process(ReleaseEvent releaseEvent) {
        return this.createExecutionEndedState();
    }

    @Override
    public State process(CancelRunEvent cancelRunEvent) {
        return this.createExecutionEndedState();
    }

    @Override
    public State process(PrepareRunEvent preparationEvent) {
        return new PreparingRunState(preparationEvent.getRun(), this.fileStorage, this.getStateMachine(), this.getMasterConnection(), this.getHostInformation(), this.uncaughtExceptionHandler, this.suppressCleanup, this.maxRunResultFiles, this.getEnergyMeasurement(), this.getLogger());
    }

    @Override
    public WorkerPartitionState getState() {
        return WorkerPartitionState.INITIALIZING;
    }
}

