/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.run.state_machine.states;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sosy_lab.verifiercloud.global.file_storage.FileNotAvailableException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationUtils;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionState;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.worker.files.WorkerFileStorage;
import org.sosy_lab.verifiercloud.worker.network.MasterConnection;
import org.sosy_lab.verifiercloud.worker.run.energy.EnergyMeasurement;
import org.sosy_lab.verifiercloud.worker.run.program_environment.ProgramEnvironment;
import org.sosy_lab.verifiercloud.worker.run.state_machine.WorkerPartition;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.CancelRunEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.Event;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.ReleaseEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.RunPreparedEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.StoppedEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.UnhandledProblemEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.AbstractState;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.ProcessingRunState;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.State;

public class PreparingRunState
extends AbstractState
implements State {
    private final Run run;
    private final ProgramEnvironment programEnvironment;
    private final AtomicBoolean canceledOrReleased = new AtomicBoolean(false);
    private volatile Optional<String> rejectionMessage = Optional.absent();
    private volatile boolean error = false;
    private final Thread calculationThread;

    public PreparingRunState(Run run, WorkerFileStorage fileStorage, WorkerPartition stateMachine, MasterConnection masterConnection, HostInformation hostInfo, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, boolean suppressCleanup, int maxRunResultFiles, EnergyMeasurement energy, Logger logger) {
        super(stateMachine, masterConnection, hostInfo, energy, logger);
        this.run = Preconditions.checkNotNull(run);
        this.programEnvironment = new ProgramEnvironment(this.getLogger(), run, fileStorage, stateMachine.getReservedMemory(), stateMachine.getReservedProcessors(), suppressCleanup, maxRunResultFiles);
        PreparingRunRunnable runnable = new PreparingRunRunnable();
        this.calculationThread = new Thread((Runnable)runnable, this.getClass().getSimpleName() + "-Thread");
        this.calculationThread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
    }

    @Override
    public void onEntry() {
        this.calculationThread.start();
    }

    @Override
    public State process(RunPreparedEvent runPreparedEvent) {
        return new ProcessingRunState(this.programEnvironment, this.run, this.getStateMachine(), this.getMasterConnection(), this.getHostInformation(), this.getEnergyMeasurement(), this.getLogger());
    }

    @Override
    public State process(UnhandledProblemEvent unhandledProblemEvent) {
        this.calculationThread.interrupt();
        String message = unhandledProblemEvent.getCause().getMessage();
        this.rejectionMessage = Optional.of(message);
        this.error = true;
        this.programEnvironment.cleanUp();
        return super.process(unhandledProblemEvent);
    }

    @Override
    public State process(CancelRunEvent abortRunEvent) {
        this.canceledOrReleased.set(true);
        this.calculationThread.interrupt();
        this.rejectionMessage = Optional.of("Run aborted.");
        return this;
    }

    @Override
    public State process(ReleaseEvent releaseEvent) {
        this.canceledOrReleased.set(true);
        this.rejectionMessage = Optional.of("User logged in.");
        this.calculationThread.interrupt();
        return this;
    }

    @Override
    public State process(StoppedEvent stoppedEvent) {
        this.programEnvironment.cleanUp();
        Verify.verify(this.rejectionMessage.isPresent());
        this.getMasterConnection().rejectRun(this.run, this.rejectionMessage.get(), this.error);
        return this.createExecutionEndedState();
    }

    @Override
    public WorkerPartitionState getState() {
        return WorkerPartitionState.PREPARING_RUN;
    }

    private class PreparingRunRunnable
    implements Runnable {
        private PreparingRunRunnable() {
        }

        @Override
        public void run() {
            Path workingDir = SystemInformationUtils.getWorkingDir();
            try {
                PreparingRunState.this.programEnvironment.createProgramEnviroment(workingDir);
            }
            catch (IOException | FileNotAvailableException e) {
                this.sendUnhandledproblemIfUserNotCanceledOrReleased(e);
            }
            Event event = PreparingRunState.this.canceledOrReleased.get() ? new StoppedEvent() : new RunPreparedEvent();
            PreparingRunState.this.getStateMachine().addEvent(event);
        }

        private void sendUnhandledproblemIfUserNotCanceledOrReleased(Exception cause) {
            if (!PreparingRunState.this.canceledOrReleased.get()) {
                UnhandledProblemEvent goToErrorEvent = new UnhandledProblemEvent(cause);
                PreparingRunState.this.getStateMachine().addEvent(goToErrorEvent);
            }
        }
    }
}

