/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.worker.run.state_machine.states;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionState;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;
import org.sosy_lab.verifiercloud.worker.network.MasterConnection;
import org.sosy_lab.verifiercloud.worker.run.energy.EnergyMeasurement;
import org.sosy_lab.verifiercloud.worker.run.program_environment.ProgramEnvironment;
import org.sosy_lab.verifiercloud.worker.run.state_machine.WorkerPartition;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.CancelRunEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.ExecutedRunEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.ReleaseEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.StoppedEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.events.UnhandledProblemEvent;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.AbstractState;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.FinishingRunState;
import org.sosy_lab.verifiercloud.worker.run.state_machine.states.State;

public class ProcessingRunState
extends AbstractState
implements State {
    private static final TimeInterval TIMEOUT_OFFSET = TimeInterval.minutes(1L);
    private final Run run;
    private final ProgramEnvironment programEnvironment;
    private Thread thread;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final AtomicBoolean canceled = new AtomicBoolean(false);
    private volatile Optional<String> rejectionMessage = Optional.absent();
    private volatile boolean error = false;

    ProcessingRunState(ProgramEnvironment programEnvironment, Run run, WorkerPartition stateMachine, MasterConnection masterConnection, HostInformation hostInfo, EnergyMeasurement energy, Logger logger) {
        super(stateMachine, masterConnection, hostInfo, energy, logger);
        this.programEnvironment = Preconditions.checkNotNull(programEnvironment);
        this.run = Preconditions.checkNotNull(run);
    }

    @Override
    public void onEntry() {
        ProcessingRunRunnable runnable = new ProcessingRunRunnable();
        this.thread = new Thread((Runnable)runnable, this.getClass().getSimpleName() + "-" + this.run + "-Thread");
        this.thread.start();
    }

    @Override
    public State process(ExecutedRunEvent executedRunEvent) {
        int exitValue = executedRunEvent.getExitValue();
        TimeInterval walltime = executedRunEvent.getWalltime();
        return new FinishingRunState(this.run, exitValue, walltime, this.programEnvironment, this.getStateMachine(), this.getMasterConnection(), this.getHostInformation(), this.getEnergyMeasurement(), executedRunEvent.wasProcessKilled(), this.getLogger());
    }

    @Override
    public State process(UnhandledProblemEvent unhandledProblemEvent) {
        this.canceled.set(true);
        this.stopExecution();
        String message = unhandledProblemEvent.getCause().getMessage();
        this.rejectionMessage = Optional.of(message);
        this.error = true;
        return super.process(unhandledProblemEvent);
    }

    @Override
    public State process(CancelRunEvent abortRunEvent) {
        this.canceled.set(true);
        this.stopExecution();
        this.rejectionMessage = Optional.of("Run aborted.");
        return this;
    }

    @Override
    public State process(ReleaseEvent releaseEvent) {
        this.canceled.set(true);
        this.stopExecution();
        this.rejectionMessage = Optional.of("User logged in.");
        return this;
    }

    @Override
    public State process(StoppedEvent stoppedEvent) {
        return this.createExecutionEndedState();
    }

    @Override
    public WorkerPartitionState getState() {
        return WorkerPartitionState.PROCESSING_RUN;
    }

    private void stopExecution() {
        this.stopped.set(true);
        this.thread.interrupt();
    }

    private class TimeOverKiller
    extends TimerTask {
        private TimeOverKiller() {
        }

        @Override
        public void run() {
            ProcessingRunState.this.getLogger().logf(Level.FINE, "Stopping execution of %s because of time limitations.", ProcessingRunState.this.run);
            ProcessingRunState.this.stopExecution();
        }
    }

    private class ProcessingRunRunnable
    implements Runnable {
        private final Timer timer = new Timer(true);

        private ProcessingRunRunnable() {
        }

        @Override
        public void run() {
            Process process;
            Object[] command = ProcessingRunState.this.programEnvironment.buildExecutorCommand();
            ProcessBuilder processBuilder = new ProcessBuilder((String[])command);
            processBuilder.directory(ProcessingRunState.this.programEnvironment.getWorkingDir().toFile());
            processBuilder.redirectOutput(ProcessingRunState.this.programEnvironment.getStdoutFile().toFile());
            processBuilder.redirectError(ProcessingRunState.this.programEnvironment.getStderrFile().toFile());
            ProcessingRunState.this.programEnvironment.updateEnvironment(processBuilder.environment());
            try {
                ProcessingRunState.this.getLogger().logf(Level.FINER, "Executing %s with: %s", ProcessingRunState.this.run, Joiner.on(' ').join(command));
                process = processBuilder.start();
                this.startTimeOutTimer();
            }
            catch (IOException e) {
                ProcessingRunState.this.getStateMachine().addEvent(new UnhandledProblemEvent(e));
                return;
            }
            int exitValue = -1;
            boolean processWasKilled = false;
            boolean stillRunning = true;
            long startTimeNanos = System.nanoTime();
            while (stillRunning) {
                try {
                    exitValue = process.waitFor();
                    this.timer.cancel();
                    stillRunning = false;
                }
                catch (InterruptedException e) {
                    if (!ProcessingRunState.this.stopped.get()) continue;
                    this.timer.cancel();
                    process.destroy();
                    processWasKilled = true;
                    while (true) {
                        try {
                            exitValue = process.waitFor();
                        }
                        catch (InterruptedException e1) {
                            continue;
                        }
                        break;
                    }
                    if (ProcessingRunState.this.canceled.get()) {
                        ProcessingRunState.this.programEnvironment.cleanUp();
                        Verify.verify(ProcessingRunState.this.rejectionMessage.isPresent());
                        ProcessingRunState.this.getMasterConnection().rejectRun(ProcessingRunState.this.run, (String)ProcessingRunState.this.rejectionMessage.get(), ProcessingRunState.this.error);
                        ProcessingRunState.this.getStateMachine().addEvent(new StoppedEvent());
                        return;
                    }
                    stillRunning = false;
                }
            }
            this.timer.cancel();
            long endTimeNanos = System.nanoTime();
            TimeInterval actualTime = TimeInterval.nanoseconds(endTimeNanos - startTimeNanos);
            ExecutedRunEvent event = new ExecutedRunEvent(ProcessingRunState.this.run, exitValue, actualTime, processWasKilled, ProcessingRunState.this.programEnvironment);
            ProcessingRunState.this.getStateMachine().addEvent(event);
        }

        private void startTimeOutTimer() {
            TimeInterval maxTime = TimeInterval.sum(ProcessingRunState.this.run.getLimitations().getTimeLimit(), TIMEOUT_OFFSET);
            this.timer.schedule((TimerTask)new TimeOverKiller(), maxTime.toMilliseconds());
        }
    }
}

