/*
 * Decompiled with CFR 0.152.
 */
package ap;

import ap.AbstractFileProver;
import ap.CmdlMain$NullStream$;
import ap.IntelliFileProver;
import ap.ParallelFileProver;
import ap.Prover;
import ap.Prover$NoCounterModel$;
import ap.Prover$NoModel$;
import ap.Prover$TimeoutCounterModel$;
import ap.Prover$TimeoutModel$;
import ap.parameters.GlobalSettings;
import ap.parameters.GlobalSettings$;
import ap.parameters.Param$ASSERTIONS$;
import ap.parameters.Param$GENERATE_TOTALITY_AXIOMS$;
import ap.parameters.Param$INPUT_FORMAT$;
import ap.parameters.Param$InputFormat$;
import ap.parameters.Param$LOGO$;
import ap.parameters.Param$MOST_GENERAL_CONSTRAINT$;
import ap.parameters.Param$MULTI_STRATEGY$;
import ap.parameters.Param$PRINT_DOT_CERTIFICATE_FILE$;
import ap.parameters.Param$PRINT_SMT_FILE$;
import ap.parameters.Param$PRINT_TPTP_FILE$;
import ap.parameters.Param$PRINT_TREE$;
import ap.parameters.Param$QUIET$;
import ap.parameters.Param$REVERSE_FUNCTIONALITY_PROPAGATION$;
import ap.parameters.Param$STDIN$;
import ap.parameters.Param$TIGHT_FUNCTION_SCOPES$;
import ap.parameters.Param$TIMEOUT$;
import ap.parameters.Param$TRIGGER_STRATEGY$;
import ap.parameters.Param$TriggerStrategyOptions$;
import ap.parameters.Param$VERSION$;
import ap.parser.IBoolLit;
import ap.parser.IExpression$;
import ap.parser.IFormula;
import ap.parser.IInterpolantSpec;
import ap.parser.INamedPart;
import ap.parser.IncrementalSMTLIBInterface;
import ap.parser.Internal2InputAbsy$;
import ap.parser.PartName;
import ap.parser.PartName$;
import ap.parser.PrincessLineariser$;
import ap.parser.SMTLineariser$;
import ap.parser.Simplifier;
import ap.parser.TPTPLineariser$;
import ap.proof.certificates.Certificate;
import ap.proof.certificates.DotLineariser$;
import ap.proof.tree.ProofTree;
import ap.proof.tree.QuantifiedTree$;
import ap.terfor.ConstantTerm;
import ap.terfor.conjunctions.Conjunction;
import ap.terfor.conjunctions.Quantifier;
import ap.terfor.conjunctions.Quantifier$EX$;
import ap.util.Debug$;
import ap.util.Timeout$;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import scala.Console$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

public final class CmdlMain$ {
    public static final CmdlMain$ MODULE$;
    private final String version;

    static {
        new CmdlMain$();
    }

    private String version() {
        return this.version;
    }

    public void printGreeting() {
        Predef$.MODULE$.println((Object)"________       _____");
        Predef$.MODULE$.println((Object)"___  __ \\_________(_)________________________________");
        Predef$.MODULE$.println((Object)"__  /_/ /_  ___/_  /__  __ \\  ___/  _ \\_  ___/_  ___/");
        Predef$.MODULE$.println((Object)"_  ____/_  /   _  / _  / / / /__ /  __/(__  )_(__  )");
        Predef$.MODULE$.println((Object)"/_/     /_/    /_/  /_/ /_/\\___/ \\___//____/ /____/");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"A Theorem Prover for First-Order Logic modulo Linear Integer Arithmetic");
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"(").append((Object)this.version()).append((Object)")").toString());
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"(c) Philipp R\u00fcmmer, 2009-2014");
        Predef$.MODULE$.println((Object)"(contributions by Angelo Brillout, Peter Baumgartner)");
        Predef$.MODULE$.println((Object)"Free software under GNU Lesser General Public License (LGPL).");
        Predef$.MODULE$.println((Object)"Bug reports to ph_r@gmx.net");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"For more information, visit http://www.philipp.ruemmer.org/princess.shtml");
    }

    public void printUsage() {
        Predef$.MODULE$.println((Object)"Usage: princess <option>* <inputfile>*");
        Predef$.MODULE$.println();
        this.printOptions();
    }

    public void printOptions() {
        Predef$.MODULE$.println((Object)"Options:");
        Predef$.MODULE$.println((Object)" [+-]logo                  Print logo and elapsed time              (default: +)");
        Predef$.MODULE$.println((Object)" [+-]version               Print version and exit                   (default: -)");
        Predef$.MODULE$.println((Object)" [+-]quiet                 Suppress all output to stderr            (default: -)");
        Predef$.MODULE$.println((Object)" [+-]printTree             Output the constructed proof tree        (default: -)");
        Predef$.MODULE$.println((Object)" -inputFormat=val          Specify format of problem file:       (default: auto)");
        Predef$.MODULE$.println((Object)"                             auto, pri, smtlib, tptp");
        Predef$.MODULE$.println((Object)" [+-]stdin                 Read SMT-LIB 2 problems from stdin       (default: -)");
        Predef$.MODULE$.println((Object)" -printSMT=filename        Output the problem in SMT-LIB format    (default: \"\")");
        Predef$.MODULE$.println((Object)" -printTPTP=filename       Output the problem in TPTP format       (default: \"\")");
        Predef$.MODULE$.println((Object)" -printDOT=filename        Output the proof in GraphViz format     (default: \"\")");
        Predef$.MODULE$.println((Object)" [+-]assert                Enable runtime assertions                (default: -)");
        Predef$.MODULE$.println((Object)" -timeout=val              Set a timeout in milliseconds        (default: infty)");
        Predef$.MODULE$.println((Object)" [+-]multiStrategy         Use a portfolio of different strategies  (default: -)");
        Predef$.MODULE$.println((Object)" -simplifyConstraints=val  How to simplify constraints:");
        Predef$.MODULE$.println((Object)"                             none:   not at all");
        Predef$.MODULE$.println((Object)"                             fair:   fair construction of a proof");
        Predef$.MODULE$.println((Object)"                             lemmas: proof construction with lemmas (default)");
        Predef$.MODULE$.println((Object)" [+-]traceConstraintSimplifier  Show constraint simplifications     (default: -)");
        Predef$.MODULE$.println((Object)" [+-]mostGeneralConstraint Derive the most general constraint for this problem");
        Predef$.MODULE$.println((Object)"                           (quantifier elimination for PA formulae) (default: -)");
        Predef$.MODULE$.println((Object)" [+-]dnfConstraints        Turn ground constraints into DNF         (default: +)");
        Predef$.MODULE$.println((Object)" -clausifier=val           Choose the clausifier (none, simple)  (default: none)");
        Predef$.MODULE$.println((Object)" [+-]posUnitResolution     Resolution of clauses with literals in   (default: +)");
        Predef$.MODULE$.println((Object)"                           the antecedent");
        Predef$.MODULE$.println((Object)" -generateTriggers=val     Automatically choose triggers for quant. formulae");
        Predef$.MODULE$.println((Object)"                             none:  not at all");
        Predef$.MODULE$.println((Object)"                             total: for all total functions         (default)");
        Predef$.MODULE$.println((Object)"                             all:   for all functions");
        Predef$.MODULE$.println((Object)" -functionGC=val           Garbage-collect function terms");
        Predef$.MODULE$.println((Object)"                             none:  not at all");
        Predef$.MODULE$.println((Object)"                             total: for all total functions         (default)");
        Predef$.MODULE$.println((Object)"                             all:   for all functions");
        Predef$.MODULE$.println((Object)" [+-]tightFunctionScopes   Keep function application defs. local    (default: +)");
        Predef$.MODULE$.println((Object)" [+-]genTotalityAxioms     Generate totality axioms for functions   (default: +)");
        Predef$.MODULE$.println((Object)" [+-]boolFunsAsPreds       In smtlib and tptp, encode               (default: -)");
        Predef$.MODULE$.println((Object)"                           boolean functions as predicates");
        Predef$.MODULE$.println((Object)" -constructProofs=val      Extract proofs");
        Predef$.MODULE$.println((Object)"                             never");
        Predef$.MODULE$.println((Object)"                             ifInterpolating: if \\interpolant occurs (default)");
        Predef$.MODULE$.println((Object)"                             always");
        Predef$.MODULE$.println((Object)" [+-]simplifyProofs        Simplify extracted proofs                (default: +)");
        Predef$.MODULE$.println((Object)" [+-]elimInterpolantQuants Eliminate quantifiers from interpolants  (default: +)");
    }

    private void printSMT(AbstractFileProver prover, String filename, GlobalSettings settings) {
        Object object = Param$PRINT_SMT_FILE$.MODULE$.apply(settings);
        String string = "";
        if (object == null ? string != null : !object.equals(string)) {
            Predef$.MODULE$.println();
            Object object2 = Param$PRINT_SMT_FILE$.MODULE$.apply(settings);
            String string2 = "-";
            if (!(object2 != null ? !object2.equals(string2) : string2 != null)) {
                this.ap$CmdlMain$$linearise$1(prover, filename);
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Saving in SMT format to ").append(Param$PRINT_SMT_FILE$.MODULE$.apply(settings)).append((Object)" ...").toString());
                FileOutputStream out = new FileOutputStream((String)Param$PRINT_SMT_FILE$.MODULE$.apply(settings));
                Console$.MODULE$.withOut((OutputStream)out, (Function0)new Serializable(prover, filename){
                    public static final long serialVersionUID = 0L;
                    private final AbstractFileProver prover$1;
                    private final String filename$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        CmdlMain$.MODULE$.ap$CmdlMain$$linearise$1(this.prover$1, this.filename$1);
                    }
                    {
                        this.prover$1 = prover$1;
                        this.filename$1 = filename$1;
                    }
                });
                out.close();
            }
        }
    }

    private void printTPTP(AbstractFileProver prover, String filename, GlobalSettings settings) {
        Object object = Param$PRINT_TPTP_FILE$.MODULE$.apply(settings);
        String string = "";
        if (object == null ? string != null : !object.equals(string)) {
            Predef$.MODULE$.println();
            Object object2 = Param$PRINT_TPTP_FILE$.MODULE$.apply(settings);
            String string2 = "-";
            if (!(object2 != null ? !object2.equals(string2) : string2 != null)) {
                this.ap$CmdlMain$$linearise$2(prover, filename);
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Saving in TPTP format to ").append(Param$PRINT_TPTP_FILE$.MODULE$.apply(settings)).append((Object)" ...").toString());
                FileOutputStream out = new FileOutputStream((String)Param$PRINT_TPTP_FILE$.MODULE$.apply(settings));
                Console$.MODULE$.withOut((OutputStream)out, (Function0)new Serializable(prover, filename){
                    public static final long serialVersionUID = 0L;
                    private final AbstractFileProver prover$2;
                    private final String filename$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        CmdlMain$.MODULE$.ap$CmdlMain$$linearise$2(this.prover$2, this.filename$2);
                    }
                    {
                        this.prover$2 = prover$2;
                        this.filename$2 = filename$2;
                    }
                });
                out.close();
            }
        }
    }

    private void printDOTCertificate(Certificate cert, GlobalSettings settings) {
        Object object = Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings);
        String string = "";
        if (object == null ? string != null : !object.equals(string)) {
            Predef$.MODULE$.println();
            Object object2 = Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings);
            String string2 = "-";
            if (!(object2 != null ? !object2.equals(string2) : string2 != null)) {
                DotLineariser$.MODULE$.apply(cert);
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Saving certificate in GraphViz format to ").append(Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings)).append((Object)" ...").toString());
                FileOutputStream out = new FileOutputStream((String)Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings));
                Console$.MODULE$.withOut((OutputStream)out, (Function0)new Serializable(cert){
                    public static final long serialVersionUID = 0L;
                    private final Certificate cert$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        DotLineariser$.MODULE$.apply(this.cert$1);
                    }
                    {
                        this.cert$1 = cert$1;
                    }
                });
                out.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Enumeration.Value ap$CmdlMain$$determineInputFormat(String filename, GlobalSettings settings) {
        Enumeration.Value value;
        Enumeration.Value value2 = (Enumeration.Value)Param$INPUT_FORMAT$.MODULE$.apply(settings);
        Enumeration.Value value3 = Param$InputFormat$.MODULE$.Auto();
        Enumeration.Value value4 = value2;
        if (value3 == null) {
            if (value4 != null) {
                return value2;
            }
        } else if (!value3.equals(value4)) return value2;
        if (filename.endsWith(".pri")) {
            value = Param$InputFormat$.MODULE$.Princess();
            return value;
        } else if (filename.endsWith(".smt2")) {
            value = Param$InputFormat$.MODULE$.SMTLIB();
            return value;
        } else {
            if (!filename.endsWith(".p")) throw new Exception("could not figure out the input format (recognised types: .pri, .smt2, .p)");
            value = Param$InputFormat$.MODULE$.TPTP();
        }
        return value;
    }

    public void ap$CmdlMain$$printFormula(IFormula f, Enumeration.Value format) {
        Enumeration.Value value = format;
        Enumeration.Value value2 = Param$InputFormat$.MODULE$.SMTLIB();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            SMTLineariser$.MODULE$.apply(f);
            Predef$.MODULE$.println();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            PrincessLineariser$.MODULE$.printExpression(f);
            Predef$.MODULE$.println();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void ap$CmdlMain$$printFormula(Conjunction c, Enumeration.Value format) {
        this.ap$CmdlMain$$printFormula(new Simplifier().apply(Internal2InputAbsy$.MODULE$.apply(c)), format);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int ap$CmdlMain$$existentialConstantNum(ProofTree p) {
        ProofTree proofTree = p;
        Option<Tuple3<Quantifier, Seq<ConstantTerm>, ProofTree>> option = QuantifiedTree$.MODULE$.unapply(proofTree);
        if (option.isEmpty()) return BoxesRunTime.unboxToInt((Object)proofTree.subtrees().iterator().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(ProofTree st) {
                return CmdlMain$.MODULE$.ap$CmdlMain$$existentialConstantNum(st);
            }
        }).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Quantifier quantifier = (Quantifier)((Tuple3)option.get())._1();
        Seq consts = (Seq)((Tuple3)option.get())._2();
        ProofTree subtree = (ProofTree)((Tuple3)option.get())._3();
        Quantifier$EX$ quantifier$EX$ = Quantifier$EX$.MODULE$;
        Quantifier quantifier2 = quantifier;
        if (quantifier$EX$ != null) {
            if (!quantifier$EX$.equals(quantifier2)) return BoxesRunTime.unboxToInt((Object)proofTree.subtrees().iterator().map((Function1)new /* invalid duplicate definition of identical inner class */).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            return this.ap$CmdlMain$$existentialConstantNum(subtree) + consts.size();
        }
        if (quantifier2 == null) return this.ap$CmdlMain$$existentialConstantNum(subtree) + consts.size();
        return BoxesRunTime.unboxToInt((Object)proofTree.subtrees().iterator().map((Function1)new /* invalid duplicate definition of identical inner class */).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public Option<Prover.Result> proveProblem(GlobalSettings settings, String name, Function0<Reader> reader, Function0<Object> userDefStoppingCond, Enumeration.Value format) {
        Option option;
        Debug$.MODULE$.enableAllAssertions(BoxesRunTime.unboxToBoolean((Object)Param$ASSERTIONS$.MODULE$.apply(settings)));
        try {
            Prover prover;
            long timeBefore = System.currentTimeMillis();
            GlobalSettings baseSettings = Param$INPUT_FORMAT$.MODULE$.set(settings, format);
            if (BoxesRunTime.unboxToBoolean((Object)Param$MULTI_STRATEGY$.MODULE$.apply(settings))) {
                GlobalSettings s = baseSettings;
                s = Param$GENERATE_TOTALITY_AXIOMS$.MODULE$.set(s, BoxesRunTime.boxToBoolean((boolean)false));
                s = Param$TRIGGER_STRATEGY$.MODULE$.set(s, Param$TriggerStrategyOptions$.MODULE$.Maximal());
                s = Param$REVERSE_FUNCTIONALITY_PROPAGATION$.MODULE$.set(s, BoxesRunTime.boxToBoolean((boolean)false));
                GlobalSettings S = s = Param$TIGHT_FUNCTION_SCOPES$.MODULE$.set(s, BoxesRunTime.boxToBoolean((boolean)false));
                GlobalSettings s2 = baseSettings;
                s2 = Param$GENERATE_TOTALITY_AXIOMS$.MODULE$.set(s2, BoxesRunTime.boxToBoolean((boolean)true));
                s2 = Param$TRIGGER_STRATEGY$.MODULE$.set(s2, Param$TriggerStrategyOptions$.MODULE$.AllMaximal());
                s2 = Param$REVERSE_FUNCTIONALITY_PROPAGATION$.MODULE$.set(s2, BoxesRunTime.boxToBoolean((boolean)true));
                GlobalSettings J = s2 = Param$TIGHT_FUNCTION_SCOPES$.MODULE$.set(s2, BoxesRunTime.boxToBoolean((boolean)true));
                GlobalSettings s3 = baseSettings;
                s3 = Param$GENERATE_TOTALITY_AXIOMS$.MODULE$.set(s3, BoxesRunTime.boxToBoolean((boolean)true));
                s3 = Param$TRIGGER_STRATEGY$.MODULE$.set(s3, Param$TriggerStrategyOptions$.MODULE$.AllMaximal());
                s3 = Param$REVERSE_FUNCTIONALITY_PROPAGATION$.MODULE$.set(s3, BoxesRunTime.boxToBoolean((boolean)false));
                GlobalSettings P = s3 = Param$TIGHT_FUNCTION_SCOPES$.MODULE$.set(s3, BoxesRunTime.boxToBoolean((boolean)false));
                GlobalSettings s4 = baseSettings;
                s4 = Param$GENERATE_TOTALITY_AXIOMS$.MODULE$.set(s4, BoxesRunTime.boxToBoolean((boolean)false));
                s4 = Param$TRIGGER_STRATEGY$.MODULE$.set(s4, Param$TriggerStrategyOptions$.MODULE$.Maximal());
                s4 = Param$REVERSE_FUNCTIONALITY_PROPAGATION$.MODULE$.set(s4, BoxesRunTime.boxToBoolean((boolean)true));
                GlobalSettings Y = s4 = Param$TIGHT_FUNCTION_SCOPES$.MODULE$.set(s4, BoxesRunTime.boxToBoolean((boolean)false));
                List strategies = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParallelFileProver.Configuration[]{new ParallelFileProver.Configuration(S, false, "-genTotalityAxioms -tightFunctionScopes", Long.MAX_VALUE), new ParallelFileProver.Configuration(J, true, "-triggerStrategy=allMaximal +reverseFunctionalityPropagation", Long.MAX_VALUE), new ParallelFileProver.Configuration(P, true, "-triggerStrategy=allMaximal -tightFunctionScopes", Long.MAX_VALUE), new ParallelFileProver.Configuration(Y, false, "-genTotalityAxioms +reverseFunctionalityPropagation -tightFunctionScopes", Long.MAX_VALUE)}));
                prover = new ParallelFileProver(reader, BoxesRunTime.unboxToInt((Object)Param$TIMEOUT$.MODULE$.apply(settings)), true, userDefStoppingCond, (Seq<ParallelFileProver.Configuration>)strategies, 2);
            } else {
                prover = new IntelliFileProver((Reader)reader.apply(), BoxesRunTime.unboxToInt((Object)Param$TIMEOUT$.MODULE$.apply(settings)), true, userDefStoppingCond, baseSettings);
            }
            IntelliFileProver prover2 = prover;
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    Predef$.MODULE$.println();
                }
            });
            this.printResult(prover2.result(), settings, format);
            long timeAfter = System.currentTimeMillis();
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(settings, timeBefore, timeAfter){
                public static final long serialVersionUID = 0L;
                private final GlobalSettings settings$1;
                private final long timeBefore$1;
                private final long timeAfter$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    Predef$.MODULE$.println();
                    if (BoxesRunTime.unboxToBoolean((Object)Param$LOGO$.MODULE$.apply(this.settings$1))) {
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"").append((Object)BoxesRunTime.boxToLong((long)(this.timeAfter$1 - this.timeBefore$1))).append((Object)"ms").toString());
                    }
                }
                {
                    this.settings$1 = settings$1;
                    this.timeBefore$1 = timeBefore$1;
                    this.timeAfter$1 = timeAfter$1;
                }
            });
            IntelliFileProver intelliFileProver = prover2;
            if (intelliFileProver instanceof AbstractFileProver) {
                AbstractFileProver abstractFileProver = intelliFileProver;
                this.printSMT(abstractFileProver, name, settings);
                this.printTPTP(abstractFileProver, name, settings);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            option = new Some((Object)prover2.result());
        }
        catch (Throwable throwable) {
            Enumeration.Value value = format;
            Enumeration.Value value2 = Param$InputFormat$.MODULE$.SMTLIB();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                Predef$.MODULE$.println((Object)"error");
                Console$.MODULE$.err().println(throwable.getMessage());
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"ERROR: ").append((Object)throwable.getMessage()).toString());
            }
            option = None$.MODULE$;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            option = (Option)Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(format){
                public static final long serialVersionUID = 0L;
                private final Enumeration.Value format$1;

                public final None$ apply() {
                    Enumeration.Value value = this.format$1;
                    Enumeration.Value value2 = Param$InputFormat$.MODULE$.SMTLIB();
                    if (!(value != null ? !value.equals(value2) : value2 != null)) {
                        Predef$.MODULE$.println((Object)"unknown");
                    }
                    Predef$.MODULE$.println((Object)"Out of memory, giving up");
                    System.gc();
                    return None$.MODULE$;
                }
                {
                    this.format$1 = format$1;
                }
            });
        }
        catch (StackOverflowError stackOverflowError) {
            option = (Option)Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(format){
                public static final long serialVersionUID = 0L;
                private final Enumeration.Value format$1;

                public final None$ apply() {
                    Enumeration.Value value = this.format$1;
                    Enumeration.Value value2 = Param$InputFormat$.MODULE$.SMTLIB();
                    if (!(value != null ? !value.equals(value2) : value2 != null)) {
                        Predef$.MODULE$.println((Object)"unknown");
                    }
                    Predef$.MODULE$.println((Object)"Stack overflow, giving up");
                    return None$.MODULE$;
                }
                {
                    this.format$1 = format$1;
                }
            });
        }
        return option;
    }

    public void proveMultiSMT(GlobalSettings settings, BufferedReader input, Function0<Object> userDefStoppingCond) {
        Enumeration.Value format = Param$InputFormat$.MODULE$.SMTLIB();
        IncrementalSMTLIBInterface incrementalSMTLIBInterface = new IncrementalSMTLIBInterface(settings, userDefStoppingCond, format){
            private final GlobalSettings settings$2;
            private final Function0 userDefStoppingCond$1;
            private final Enumeration.Value format$3;

            public Option<Prover.Result> solve(String input) {
                Console$.MODULE$.err().println("Checking satisfiability ...");
                return CmdlMain$.MODULE$.proveProblem(this.settings$2, "SMT-LIB 2 input", (Function0<Reader>)new Serializable(this, input){
                    public static final long serialVersionUID = 0L;
                    private final String input$1;

                    public final StringReader apply() {
                        return new StringReader(this.input$1);
                    }
                    {
                        this.input$1 = input$1;
                    }
                }, (Function0<Object>)this.userDefStoppingCond$1, this.format$3);
            }
            {
                this.settings$2 = settings$2;
                this.userDefStoppingCond$1 = userDefStoppingCond$1;
                this.format$3 = format$3;
            }
        };
        incrementalSMTLIBInterface.readInputs(input, settings);
    }

    public Object proveProblems(GlobalSettings settings, String name, Function0<BufferedReader> input, Function0<Object> userDefStoppingCond, Enumeration.Value format) {
        BoxedUnit boxedUnit;
        Console$.MODULE$.err().println(new StringBuilder().append((Object)"Loading ").append((Object)name).append((Object)" ...").toString());
        Enumeration.Value value = format;
        Enumeration.Value value2 = Param$InputFormat$.MODULE$.SMTLIB();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.proveMultiSMT(settings, (BufferedReader)input.apply(), userDefStoppingCond);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = this.proveProblem(settings, name, input, userDefStoppingCond, format);
        }
        return boxedUnit;
    }

    public void printResult(Prover.Result res, GlobalSettings settings, Enumeration.Value format) {
        Prover.Result result;
        block62: {
            block49: {
                block51: {
                    BoxedUnit boxedUnit;
                    boolean bl;
                    block61: {
                        BoxedUnit boxedUnit2;
                        Object object;
                        block60: {
                            block59: {
                                block58: {
                                    block57: {
                                        block56: {
                                            BoxedUnit boxedUnit3;
                                            block55: {
                                                BoxedUnit boxedUnit4;
                                                IBoolLit iBoolLit;
                                                boolean bl2;
                                                block54: {
                                                    BoxedUnit boxedUnit5;
                                                    block53: {
                                                        BoxedUnit boxedUnit6;
                                                        block52: {
                                                            BoxedUnit boxedUnit7;
                                                            IBoolLit iBoolLit2;
                                                            boolean bl3;
                                                            IFormula iFormula;
                                                            block50: {
                                                                BoxedUnit boxedUnit8;
                                                                block35: {
                                                                    Prover.Result result2;
                                                                    block48: {
                                                                        block37: {
                                                                            boolean bl4;
                                                                            block47: {
                                                                                block46: {
                                                                                    block45: {
                                                                                        block44: {
                                                                                            block43: {
                                                                                                block42: {
                                                                                                    block41: {
                                                                                                        block40: {
                                                                                                            block39: {
                                                                                                                block38: {
                                                                                                                    block36: {
                                                                                                                        Enumeration.Value value = format;
                                                                                                                        Enumeration.Value value2 = Param$InputFormat$.MODULE$.SMTLIB();
                                                                                                                        Enumeration.Value value3 = value;
                                                                                                                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block35;
                                                                                                                        result2 = res;
                                                                                                                        if (!(result2 instanceof Prover.Proof)) break block36;
                                                                                                                        Prover.Proof proof = (Prover.Proof)result2;
                                                                                                                        ProofTree tree = proof.tree();
                                                                                                                        Predef$.MODULE$.println((Object)"unsat");
                                                                                                                        BoxedUnit boxedUnit9 = BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings)) ? (BoxedUnit)Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(tree){
                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                            private final ProofTree tree$1;

                                                                                                                            public final void apply() {
                                                                                                                                this.apply$mcV$sp();
                                                                                                                            }

                                                                                                                            public void apply$mcV$sp() {
                                                                                                                                Predef$.MODULE$.println();
                                                                                                                                Predef$.MODULE$.println((Object)"Proof tree:");
                                                                                                                                Predef$.MODULE$.println((Object)this.tree$1);
                                                                                                                            }
                                                                                                                            {
                                                                                                                                this.tree$1 = tree$1;
                                                                                                                            }
                                                                                                                        }) : BoxedUnit.UNIT;
                                                                                                                        break block37;
                                                                                                                    }
                                                                                                                    if (!(result2 instanceof Prover.ProofWithModel)) break block38;
                                                                                                                    Prover.ProofWithModel proofWithModel = (Prover.ProofWithModel)result2;
                                                                                                                    ProofTree tree = proofWithModel.tree();
                                                                                                                    Predef$.MODULE$.println((Object)"unsat");
                                                                                                                    BoxedUnit boxedUnit10 = BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings)) ? (BoxedUnit)Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(tree){
                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                        private final ProofTree tree$2;

                                                                                                                        public final void apply() {
                                                                                                                            this.apply$mcV$sp();
                                                                                                                        }

                                                                                                                        public void apply$mcV$sp() {
                                                                                                                            Predef$.MODULE$.println();
                                                                                                                            Predef$.MODULE$.println((Object)"Proof tree:");
                                                                                                                            Predef$.MODULE$.println((Object)this.tree$2);
                                                                                                                        }
                                                                                                                        {
                                                                                                                            this.tree$2 = tree$2;
                                                                                                                        }
                                                                                                                    }) : BoxedUnit.UNIT;
                                                                                                                    break block37;
                                                                                                                }
                                                                                                                if (!(result2 instanceof Prover.NoProof)) break block39;
                                                                                                                Predef$.MODULE$.println((Object)"unknown");
                                                                                                                BoxedUnit boxedUnit11 = BoxedUnit.UNIT;
                                                                                                                break block37;
                                                                                                            }
                                                                                                            if (!(result2 instanceof Prover.Invalid)) break block40;
                                                                                                            Predef$.MODULE$.println((Object)"sat");
                                                                                                            BoxedUnit boxedUnit12 = BoxedUnit.UNIT;
                                                                                                            break block37;
                                                                                                        }
                                                                                                        if (!(result2 instanceof Prover.CounterModel)) break block41;
                                                                                                        Prover.CounterModel counterModel = (Prover.CounterModel)result2;
                                                                                                        IFormula model = counterModel.counterModel();
                                                                                                        Predef$.MODULE$.println((Object)"sat");
                                                                                                        BoxedUnit boxedUnit13 = (BoxedUnit)Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(format, model){
                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                            private final Enumeration.Value format$2;
                                                                                                            private final IFormula model$1;

                                                                                                            public final void apply() {
                                                                                                                this.apply$mcV$sp();
                                                                                                            }

                                                                                                            public void apply$mcV$sp() {
                                                                                                                Predef$.MODULE$.println();
                                                                                                                Predef$.MODULE$.println((Object)"Model:");
                                                                                                                CmdlMain$.MODULE$.ap$CmdlMain$$printFormula(this.model$1, this.format$2);
                                                                                                            }
                                                                                                            {
                                                                                                                this.format$2 = format$2;
                                                                                                                this.model$1 = model$1;
                                                                                                            }
                                                                                                        });
                                                                                                        break block37;
                                                                                                    }
                                                                                                    Prover$NoCounterModel$ prover$NoCounterModel$ = Prover$NoCounterModel$.MODULE$;
                                                                                                    Prover.Result result3 = result2;
                                                                                                    if (prover$NoCounterModel$ != null ? !prover$NoCounterModel$.equals(result3) : result3 != null) break block42;
                                                                                                    Predef$.MODULE$.println((Object)"unsat");
                                                                                                    BoxedUnit boxedUnit14 = BoxedUnit.UNIT;
                                                                                                    break block37;
                                                                                                }
                                                                                                if (!(result2 instanceof Prover.NoCounterModelCert)) break block43;
                                                                                                Prover.NoCounterModelCert noCounterModelCert = (Prover.NoCounterModelCert)result2;
                                                                                                Certificate cert = noCounterModelCert.certificate();
                                                                                                Predef$.MODULE$.println((Object)"unsat");
                                                                                                this.printDOTCertificate(cert, settings);
                                                                                                BoxedUnit boxedUnit15 = BoxedUnit.UNIT;
                                                                                                break block37;
                                                                                            }
                                                                                            if (!(result2 instanceof Prover.NoCounterModelCertInter)) break block44;
                                                                                            Prover.NoCounterModelCertInter noCounterModelCertInter = (Prover.NoCounterModelCertInter)result2;
                                                                                            Certificate cert = noCounterModelCertInter.certificate();
                                                                                            Predef$.MODULE$.println((Object)"unsat");
                                                                                            this.printDOTCertificate(cert, settings);
                                                                                            BoxedUnit boxedUnit16 = BoxedUnit.UNIT;
                                                                                            break block37;
                                                                                        }
                                                                                        if (!(result2 instanceof Prover.Model)) break block45;
                                                                                        Predef$.MODULE$.println((Object)"unsat");
                                                                                        BoxedUnit boxedUnit17 = BoxedUnit.UNIT;
                                                                                        break block37;
                                                                                    }
                                                                                    Prover$NoModel$ prover$NoModel$ = Prover$NoModel$.MODULE$;
                                                                                    Prover.Result result4 = result2;
                                                                                    if (prover$NoModel$ != null ? !prover$NoModel$.equals(result4) : result4 != null) break block46;
                                                                                    Predef$.MODULE$.println((Object)"sat");
                                                                                    BoxedUnit boxedUnit18 = BoxedUnit.UNIT;
                                                                                    break block37;
                                                                                }
                                                                                if (!(result2 instanceof Prover.TimeoutProof)) break block47;
                                                                                Prover.TimeoutProof timeoutProof = (Prover.TimeoutProof)result2;
                                                                                ProofTree tree = timeoutProof.unfinishedTree();
                                                                                Predef$.MODULE$.println((Object)"unknown");
                                                                                Console$.MODULE$.err().println("Cancelled or timeout");
                                                                                BoxedUnit boxedUnit19 = BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings)) ? (BoxedUnit)Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(tree){
                                                                                    public static final long serialVersionUID = 0L;
                                                                                    private final ProofTree tree$3;

                                                                                    public final void apply() {
                                                                                        this.apply$mcV$sp();
                                                                                    }

                                                                                    public void apply$mcV$sp() {
                                                                                        Predef$.MODULE$.println();
                                                                                        Predef$.MODULE$.println((Object)"Proof tree:");
                                                                                        Predef$.MODULE$.println((Object)this.tree$3);
                                                                                    }
                                                                                    {
                                                                                        this.tree$3 = tree$3;
                                                                                    }
                                                                                }) : BoxedUnit.UNIT;
                                                                                break block37;
                                                                            }
                                                                            Prover$TimeoutModel$ prover$TimeoutModel$ = Prover$TimeoutModel$.MODULE$;
                                                                            Prover.Result result5 = result2;
                                                                            if (!(prover$TimeoutModel$ != null ? !prover$TimeoutModel$.equals(result5) : result5 != null)) {
                                                                                bl4 = true;
                                                                            } else {
                                                                                Prover$TimeoutCounterModel$ prover$TimeoutCounterModel$ = Prover$TimeoutCounterModel$.MODULE$;
                                                                                Prover.Result result6 = result2;
                                                                                bl4 = !(prover$TimeoutCounterModel$ != null ? !prover$TimeoutCounterModel$.equals(result6) : result6 != null);
                                                                            }
                                                                            if (!bl4) break block48;
                                                                            Predef$.MODULE$.println((Object)"unknown");
                                                                            Console$.MODULE$.err().println("Cancelled or timeout");
                                                                            BoxedUnit boxedUnit20 = BoxedUnit.UNIT;
                                                                        }
                                                                        BoxedUnit boxedUnit21 = BoxedUnit.UNIT;
                                                                        break block49;
                                                                    }
                                                                    throw new MatchError((Object)result2);
                                                                }
                                                                result = res;
                                                                if (!(result instanceof Prover.Proof)) break block50;
                                                                Prover.Proof proof = (Prover.Proof)result;
                                                                ProofTree tree = proof.tree();
                                                                Predef$.MODULE$.println((Object)"VALID");
                                                                if (!tree.closingConstraint().isTrue() || BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                                                                    Predef$.MODULE$.println();
                                                                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Under the ").append((Object)(BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings)) ? "most-general " : "")).append((Object)"constraint:").toString());
                                                                    this.ap$CmdlMain$$printFormula(tree.closingConstraint(), format);
                                                                }
                                                                if (BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) {
                                                                    Predef$.MODULE$.println();
                                                                    Predef$.MODULE$.println((Object)"Proof tree:");
                                                                    Predef$.MODULE$.println((Object)tree);
                                                                    boxedUnit8 = BoxedUnit.UNIT;
                                                                } else {
                                                                    boxedUnit8 = BoxedUnit.UNIT;
                                                                }
                                                                BoxedUnit boxedUnit22 = boxedUnit8;
                                                                break block51;
                                                            }
                                                            if (!(result instanceof Prover.ProofWithModel)) break block52;
                                                            Prover.ProofWithModel proofWithModel = (Prover.ProofWithModel)result;
                                                            ProofTree tree = proofWithModel.tree();
                                                            IFormula model = proofWithModel.model();
                                                            Predef$.MODULE$.println((Object)"VALID");
                                                            if (!tree.closingConstraint().isTrue() || BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                                                                Predef$.MODULE$.println();
                                                                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Under the ").append((Object)(BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings)) ? "most-general " : "")).append((Object)"constraint:").toString());
                                                                this.ap$CmdlMain$$printFormula(tree.closingConstraint(), format);
                                                            }
                                                            if ((iFormula = model) instanceof IBoolLit && (bl3 = (iBoolLit2 = (IBoolLit)iFormula).value())) {
                                                                BoxedUnit boxedUnit23 = BoxedUnit.UNIT;
                                                            } else {
                                                                Conjunction c = tree.closingConstraint();
                                                                if (c.arithConj().positiveEqs().size() == c.size()) {
                                                                    BoxedUnit boxedUnit24 = BoxedUnit.UNIT;
                                                                } else {
                                                                    Predef$.MODULE$.println();
                                                                    Predef$.MODULE$.println((Object)"Concrete witness:");
                                                                    this.ap$CmdlMain$$printFormula(model, format);
                                                                    BoxedUnit boxedUnit25 = BoxedUnit.UNIT;
                                                                }
                                                            }
                                                            if (BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) {
                                                                Predef$.MODULE$.println();
                                                                Predef$.MODULE$.println((Object)"Proof tree:");
                                                                Predef$.MODULE$.println((Object)tree);
                                                                boxedUnit7 = BoxedUnit.UNIT;
                                                            } else {
                                                                boxedUnit7 = BoxedUnit.UNIT;
                                                            }
                                                            BoxedUnit boxedUnit26 = boxedUnit7;
                                                            break block51;
                                                        }
                                                        if (!(result instanceof Prover.NoProof)) break block53;
                                                        Predef$.MODULE$.println((Object)"UNKNOWN");
                                                        if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                                                            Predef$.MODULE$.println();
                                                            Predef$.MODULE$.println((Object)"Most-general constraint:");
                                                            Predef$.MODULE$.println((Object)"false");
                                                            boxedUnit6 = BoxedUnit.UNIT;
                                                        } else {
                                                            boxedUnit6 = BoxedUnit.UNIT;
                                                        }
                                                        BoxedUnit boxedUnit27 = boxedUnit6;
                                                        break block51;
                                                    }
                                                    if (!(result instanceof Prover.Invalid)) break block54;
                                                    Predef$.MODULE$.println((Object)"INVALID");
                                                    if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                                                        Predef$.MODULE$.println();
                                                        Predef$.MODULE$.println((Object)"Most-general constraint:");
                                                        Predef$.MODULE$.println((Object)"false");
                                                        boxedUnit5 = BoxedUnit.UNIT;
                                                    } else {
                                                        boxedUnit5 = BoxedUnit.UNIT;
                                                    }
                                                    BoxedUnit boxedUnit28 = boxedUnit5;
                                                    break block51;
                                                }
                                                if (!(result instanceof Prover.CounterModel)) break block55;
                                                Prover.CounterModel counterModel = (Prover.CounterModel)result;
                                                IFormula model = counterModel.counterModel();
                                                Predef$.MODULE$.println((Object)"INVALID");
                                                IFormula iFormula = model;
                                                if (iFormula instanceof IBoolLit && (bl2 = (iBoolLit = (IBoolLit)iFormula).value())) {
                                                    BoxedUnit boxedUnit29 = BoxedUnit.UNIT;
                                                } else {
                                                    Predef$.MODULE$.println();
                                                    Predef$.MODULE$.println((Object)"Countermodel:");
                                                    this.ap$CmdlMain$$printFormula(model, format);
                                                    BoxedUnit boxedUnit30 = BoxedUnit.UNIT;
                                                }
                                                if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                                                    Predef$.MODULE$.println();
                                                    Predef$.MODULE$.println((Object)"Most-general constraint:");
                                                    Predef$.MODULE$.println((Object)"false");
                                                    boxedUnit4 = BoxedUnit.UNIT;
                                                } else {
                                                    boxedUnit4 = BoxedUnit.UNIT;
                                                }
                                                BoxedUnit boxedUnit31 = boxedUnit4;
                                                break block51;
                                            }
                                            Prover$NoCounterModel$ prover$NoCounterModel$ = Prover$NoCounterModel$.MODULE$;
                                            Prover.Result result7 = result;
                                            if (prover$NoCounterModel$ != null ? !prover$NoCounterModel$.equals(result7) : result7 != null) break block56;
                                            Predef$.MODULE$.println((Object)"VALID");
                                            if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                                                Predef$.MODULE$.println();
                                                Predef$.MODULE$.println((Object)"Most-general constraint:");
                                                Predef$.MODULE$.println((Object)"true");
                                                boxedUnit3 = BoxedUnit.UNIT;
                                            } else {
                                                boxedUnit3 = BoxedUnit.UNIT;
                                            }
                                            BoxedUnit boxedUnit32 = boxedUnit3;
                                            break block51;
                                        }
                                        if (!(result instanceof Prover.NoCounterModelCert)) break block57;
                                        Prover.NoCounterModelCert noCounterModelCert = (Prover.NoCounterModelCert)result;
                                        Certificate cert = noCounterModelCert.certificate();
                                        Predef$.MODULE$.println((Object)"VALID");
                                        if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                                            Predef$.MODULE$.println();
                                            Predef$.MODULE$.println((Object)"Most-general constraint:");
                                            Predef$.MODULE$.println((Object)"true");
                                        }
                                        Predef$.MODULE$.println();
                                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Certificate: ").append((Object)cert).toString());
                                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Assumed formulae: ").append(cert.assumedFormulas()).toString());
                                        Predef$.MODULE$.print((Object)"Constraint: ");
                                        this.ap$CmdlMain$$printFormula(cert.closingConstraint(), format);
                                        this.printDOTCertificate(cert, settings);
                                        BoxedUnit boxedUnit33 = BoxedUnit.UNIT;
                                        break block51;
                                    }
                                    if (!(result instanceof Prover.NoCounterModelCertInter)) break block58;
                                    Prover.NoCounterModelCertInter noCounterModelCertInter = (Prover.NoCounterModelCertInter)result;
                                    Certificate cert = noCounterModelCertInter.certificate();
                                    Seq<IFormula> inters = noCounterModelCertInter.interpolants();
                                    Predef$.MODULE$.println((Object)"VALID");
                                    if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                                        Predef$.MODULE$.println();
                                        Predef$.MODULE$.println((Object)"Most-general constraint:");
                                        Predef$.MODULE$.println((Object)"true");
                                    }
                                    Predef$.MODULE$.println();
                                    Predef$.MODULE$.println((Object)"Interpolants:");
                                    inters.foreach((Function1)new Serializable(format){
                                        public static final long serialVersionUID = 0L;
                                        private final Enumeration.Value format$2;

                                        public final void apply(IFormula i) {
                                            CmdlMain$.MODULE$.ap$CmdlMain$$printFormula(i, this.format$2);
                                        }
                                        {
                                            this.format$2 = format$2;
                                        }
                                    });
                                    this.printDOTCertificate(cert, settings);
                                    BoxedUnit boxedUnit34 = BoxedUnit.UNIT;
                                    break block51;
                                }
                                if (!(result instanceof Prover.Model)) break block59;
                                Prover.Model model = (Prover.Model)result;
                                IFormula model2 = model.model();
                                Predef$.MODULE$.println((Object)"VALID");
                                Predef$.MODULE$.println();
                                Predef$.MODULE$.println((Object)"Under the assignment:");
                                this.ap$CmdlMain$$printFormula(model2, format);
                                BoxedUnit boxedUnit35 = BoxedUnit.UNIT;
                                break block51;
                            }
                            Prover$NoModel$ prover$NoModel$ = Prover$NoModel$.MODULE$;
                            Prover.Result result8 = result;
                            if (prover$NoModel$ != null ? !prover$NoModel$.equals(result8) : result8 != null) break block60;
                            Predef$.MODULE$.println((Object)"INVALID");
                            BoxedUnit boxedUnit36 = BoxedUnit.UNIT;
                            break block51;
                        }
                        if (!(result instanceof Prover.TimeoutProof)) break block61;
                        Prover.TimeoutProof timeoutProof = (Prover.TimeoutProof)result;
                        ProofTree tree = timeoutProof.unfinishedTree();
                        Predef$.MODULE$.println((Object)"CANCELLED/TIMEOUT");
                        if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                            Predef$.MODULE$.println();
                            Predef$.MODULE$.println((Object)"Current constraint:");
                            object = Timeout$.MODULE$.withTimeoutMillis(1000L, new Serializable(format, tree){
                                public static final long serialVersionUID = 0L;
                                private final Enumeration.Value format$2;
                                private final ProofTree tree$4;

                                public final void apply() {
                                    this.apply$mcV$sp();
                                }

                                public void apply$mcV$sp() {
                                    CmdlMain$.MODULE$.ap$CmdlMain$$printFormula(this.tree$4.closingConstraint(), this.format$2);
                                }
                                {
                                    this.format$2 = format$2;
                                    this.tree$4 = tree$4;
                                }
                            }, new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final void apply() {
                                    this.apply$mcV$sp();
                                }

                                public void apply$mcV$sp() {
                                    Predef$.MODULE$.println((Object)"(timeout)");
                                }
                            });
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        if (BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) {
                            Predef$.MODULE$.println();
                            Predef$.MODULE$.println((Object)"Proof tree:");
                            Predef$.MODULE$.println((Object)tree);
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit37 = boxedUnit2;
                        break block51;
                    }
                    Prover$TimeoutModel$ prover$TimeoutModel$ = Prover$TimeoutModel$.MODULE$;
                    Prover.Result result9 = result;
                    if (!(prover$TimeoutModel$ != null ? !prover$TimeoutModel$.equals(result9) : result9 != null)) {
                        bl = true;
                    } else {
                        Prover$TimeoutCounterModel$ prover$TimeoutCounterModel$ = Prover$TimeoutCounterModel$.MODULE$;
                        Prover.Result result10 = result;
                        bl = !(prover$TimeoutCounterModel$ != null ? !prover$TimeoutCounterModel$.equals(result10) : result10 != null);
                    }
                    if (!bl) break block62;
                    Predef$.MODULE$.println((Object)"CANCELLED/TIMEOUT");
                    if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                        Predef$.MODULE$.println();
                        Predef$.MODULE$.println((Object)"Current constraint:");
                        Predef$.MODULE$.println((Object)"false");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit38 = boxedUnit;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)result);
    }

    public void main(String[] args) {
        this.doMain(args, (Function0<Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        });
    }

    public void doMain(String[] args, Function0<Object> userDefStoppingCond) {
        NonLocalReturnControl nonLocalReturnControl2;
        block8: {
            block7: {
                Object object = new Object();
                try {
                    Tuple2 tuple2 = this.liftedTree1$1(args, object);
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        GlobalSettings settings = (GlobalSettings)tuple2._1();
                        Seq inputs = (Seq)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)settings, (Object)inputs);
                        GlobalSettings settings2 = (GlobalSettings)tuple23._1();
                        Seq inputs2 = (Seq)tuple23._2();
                        if (BoxesRunTime.unboxToBoolean((Object)Param$VERSION$.MODULE$.apply(settings2))) {
                            Predef$.MODULE$.println((Object)this.version());
                            return;
                        }
                        if (BoxesRunTime.unboxToBoolean((Object)Param$QUIET$.MODULE$.apply(settings2))) {
                            Console$.MODULE$.setErr((OutputStream)CmdlMain$NullStream$.MODULE$);
                        }
                        Object object2 = BoxesRunTime.unboxToBoolean((Object)Param$LOGO$.MODULE$.apply(settings2)) ? Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                CmdlMain$.MODULE$.printGreeting();
                                Predef$.MODULE$.println();
                            }
                        }) : BoxedUnit.UNIT;
                        if (inputs2.isEmpty() && !BoxesRunTime.unboxToBoolean((Object)Param$STDIN$.MODULE$.apply(settings2))) {
                            Console$.MODULE$.err().println("No inputs given, exiting");
                            return;
                        }
                        inputs2.foreach((Function1)new Serializable(userDefStoppingCond, settings2){
                            public static final long serialVersionUID = 0L;
                            private final Function0 userDefStoppingCond$2;
                            private final GlobalSettings settings$3;

                            public final Object apply(String filename) {
                                Object object;
                                try {
                                    Enumeration.Value format = CmdlMain$.MODULE$.ap$CmdlMain$$determineInputFormat(filename, this.settings$3);
                                    object = CmdlMain$.MODULE$.proveProblems(this.settings$3, filename, (Function0<BufferedReader>)new Serializable(this, filename){
                                        public static final long serialVersionUID = 0L;
                                        private final String filename$3;

                                        public final BufferedReader apply() {
                                            return new BufferedReader(new FileReader(new File(this.filename$3)));
                                        }
                                        {
                                            this.filename$3 = filename$3;
                                        }
                                    }, (Function0<Object>)this.userDefStoppingCond$2, format);
                                }
                                catch (Throwable throwable) {
                                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"ERROR: ").append((Object)throwable.getMessage()).toString());
                                    object = BoxedUnit.UNIT;
                                }
                                return object;
                            }
                            {
                                this.userDefStoppingCond$2 = userDefStoppingCond$2;
                                this.settings$3 = settings$3;
                            }
                        });
                        if (BoxesRunTime.unboxToBoolean((Object)Param$STDIN$.MODULE$.apply(settings2))) {
                            Console$.MODULE$.err().println("Reading SMT-LIB 2 input from stdin ...");
                            this.proveMultiSMT(settings2, Console$.MODULE$.in(), userDefStoppingCond);
                        }
                        break block7;
                    }
                    throw new MatchError((Object)tuple2);
                }
                catch (NonLocalReturnControl nonLocalReturnControl2) {
                    if (nonLocalReturnControl2.key() != object) break block8;
                    nonLocalReturnControl2.value$mcV$sp();
                }
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public final IFormula ap$CmdlMain$$formula$1(PartName name, AbstractFileProver prover$1) {
        return IExpression$.MODULE$.removePartName((IFormula)prover$1.inputFormulas().find((Function1)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final PartName name$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(INamedPart x0$1) {
                INamedPart iNamedPart = x0$1;
                if (iNamedPart == null) return false;
                PartName partName = iNamedPart.name();
                PartName partName2 = this.name$1;
                PartName partName3 = partName;
                if (partName2 != null) {
                    if (!partName2.equals(partName3)) return false;
                    return true;
                }
                if (partName3 == null) return true;
                return false;
            }
            {
                this.name$1 = name$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IFormula apply() {
                return IExpression$.MODULE$.Boolean2IFormula(false);
            }
        }));
    }

    public final void ap$CmdlMain$$linearise$1(AbstractFileProver prover$1, String filename$1) {
        List<IInterpolantSpec> list;
        block4: {
            List list2;
            block3: {
                .colon.colon colon2;
                IInterpolantSpec iInterpolantSpec;
                block2: {
                    list = prover$1.interpolantSpecs();
                    Some some = List$.MODULE$.unapplySeq(list);
                    if (some.isEmpty() || some.get() == null || ((LinearSeqOptimized)some.get()).lengthCompare(0) != 0) break block2;
                    list2 = (List)prover$1.inputFormulas().map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final IFormula apply(INamedPart f) {
                            return IExpression$.MODULE$.removePartName(f);
                        }
                    }, List$.MODULE$.canBuildFrom());
                    break block3;
                }
                if (!(list instanceof .colon.colon) || (iInterpolantSpec = (IInterpolantSpec)(colon2 = (.colon.colon)list).hd$1()) == null) break block4;
                List<PartName> left = iInterpolantSpec.left();
                List<PartName> right = iInterpolantSpec.right();
                IFormula common = this.ap$CmdlMain$$formula$1(PartName$.MODULE$.NO_NAME(), prover$1);
                list2 = (List)((TraversableLike)left.$plus$plus(right, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(prover$1, common){
                    public static final long serialVersionUID = 0L;
                    private final AbstractFileProver prover$1;
                    private final IFormula common$1;

                    public final IFormula apply(PartName part) {
                        return this.common$1.$bar$bar$bar(CmdlMain$.MODULE$.ap$CmdlMain$$formula$1(part, this.prover$1));
                    }
                    {
                        this.prover$1 = prover$1;
                        this.common$1 = common$1;
                    }
                }, List$.MODULE$.canBuildFrom());
            }
            List formulas = list2;
            SMTLineariser$.MODULE$.apply((Seq<IFormula>)formulas, prover$1.signature(), filename$1);
            return;
        }
        throw new MatchError(list);
    }

    public final void ap$CmdlMain$$linearise$2(AbstractFileProver prover$2, String filename$2) {
        TPTPLineariser$.MODULE$.apply(prover$2.originalInputFormula(), filename$2);
    }

    private final Tuple2 liftedTree1$1(String[] args$1, Object nonLocalReturnKey1$1) {
        try {
            return GlobalSettings$.MODULE$.fromArguments((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args$1), GlobalSettings$.MODULE$.DEFAULT());
        }
        catch (Throwable throwable) {
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    CmdlMain$.MODULE$.printGreeting();
                    Predef$.MODULE$.println();
                }
            });
            Predef$.MODULE$.println((Object)throwable.getMessage());
            Predef$.MODULE$.println();
            this.printUsage();
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    private CmdlMain$() {
        MODULE$ = this;
        this.version = "release 2014-08-27";
    }
}

