/*
 * Decompiled with CFR 0.152.
 */
package apache.harmony.math;

import apache.harmony.math.BitLevel;
import apache.harmony.math.Conversion;
import apache.harmony.math.Division;
import apache.harmony.math.Elementary;
import apache.harmony.math.Logical;
import apache.harmony.math.Multiplication;
import apache.harmony.math.Primality;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;
import org.matheclipse.basic.Config;
import org.matheclipse.basic.ObjectMemoryExceededException;

public class BigInteger
implements Comparable<BigInteger>,
Serializable {
    private static final long serialVersionUID = -8287574255936472291L;
    transient int[] _words;
    transient int _size;
    transient int _sign;
    public static final BigInteger ONE = new BigInteger(1, 1);
    public static final BigInteger TEN = new BigInteger(1, 10);
    public static final BigInteger ZERO = new BigInteger(0, 0);
    public static final BigInteger MINUS_ONE = new BigInteger(-1, 1);
    static final int EQUALS = 0;
    static final int GREATER = 1;
    static final int LESS = -1;
    static final BigInteger[] SMALL_VALUES = new BigInteger[]{ZERO, ONE, new BigInteger(1, 2), new BigInteger(1, 3), new BigInteger(1, 4), new BigInteger(1, 5), new BigInteger(1, 6), new BigInteger(1, 7), new BigInteger(1, 8), new BigInteger(1, 9), TEN};
    private transient int firstNonzeroDigit = -2;
    private int signum;
    private byte[] magnitude;

    static BigInteger newInstance(int sign, int numberLength, int[] digits) {
        BigInteger z = new BigInteger();
        z._sign = sign;
        z._size = numberLength;
        z._words = digits;
        return z;
    }

    static BigInteger newInstance(int sign, int value) {
        BigInteger z = new BigInteger();
        z._sign = sign;
        z._size = 1;
        z._words = new int[]{value};
        return z;
    }

    static BigInteger newInstance(int sign, long val) {
        BigInteger z = new BigInteger();
        z._sign = sign;
        if ((val & 0xFFFFFFFF00000000L) == 0L) {
            z._size = 1;
            z._words = new int[]{(int)val};
        } else {
            z._size = 2;
            z._words = new int[]{(int)val, (int)(val >> 32)};
        }
        return z;
    }

    static BigInteger newInstance(int signum, int[] digits) {
        BigInteger z = new BigInteger();
        if (digits.length == 0) {
            z._sign = 0;
            z._size = 1;
            z._words = new int[1];
        } else {
            z._sign = signum;
            z._size = digits.length;
            z._words = digits;
            z.cutOffLeadingZeroes();
        }
        return z;
    }

    private BigInteger() {
    }

    public static BigInteger valueOf(String chars) {
        return BigInteger.valueOf(chars, 10);
    }

    public BigInteger(int numBits, Random rnd) {
        if (numBits < 0) {
            throw new IllegalArgumentException("BigInteger");
        }
        if (numBits == 0) {
            this._sign = 0;
            this._size = 1;
            this._words = new int[1];
        } else {
            this._sign = 1;
            this._size = numBits + 31 >> 5;
            if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < this._size) {
                throw new ObjectMemoryExceededException("BigInteger", this._size);
            }
            this._words = new int[this._size];
            int i = 0;
            while (i < this._size) {
                this._words[i] = rnd.nextInt();
                ++i;
            }
            int n = this._size - 1;
            this._words[n] = this._words[n] >>> (-numBits & 0x1F);
            this.cutOffLeadingZeroes();
        }
    }

    public BigInteger(int bitLength, int certainty, Random rnd) {
        if (bitLength < 2) {
            throw new ArithmeticException("BigInteger");
        }
        BigInteger me = Primality.consBigInteger(bitLength, certainty, rnd);
        this._sign = me._sign;
        this._size = me._size;
        this._words = me._words;
    }

    private BigInteger(String val) {
        this(val, 10);
    }

    private BigInteger(String val, int radix) {
        if (val == null) {
            throw new NullPointerException();
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("BigInteger");
        }
        if (val.length() == 0) {
            throw new NumberFormatException("BigInteger");
        }
        BigInteger me = Conversion.string2BigInteger(val, radix);
        this._sign = me._sign;
        this._size = me._size;
        this._words = me._words;
    }

    public BigInteger(int signum, byte[] magnitude) {
        if (magnitude == null) {
            throw new NullPointerException();
        }
        if (signum < -1 || signum > 1) {
            throw new NumberFormatException("BigInteger");
        }
        if (signum == 0) {
            byte[] byArray = magnitude;
            int n = magnitude.length;
            int n2 = 0;
            while (n2 < n) {
                byte element = byArray[n2];
                if (element != 0) {
                    throw new NumberFormatException("BigInteger");
                }
                ++n2;
            }
        }
        if (magnitude.length == 0) {
            this._sign = 0;
            this._size = 1;
            this._words = new int[1];
        } else {
            this._sign = signum;
            this.putBytesPositiveToIntegers(magnitude);
            this.cutOffLeadingZeroes();
        }
    }

    public BigInteger(byte[] val) {
        if (val.length == 0) {
            throw new NumberFormatException("BigInteger");
        }
        if (val[0] < 0) {
            this._sign = -1;
            this.putBytesNegativeToIntegers(val);
        } else {
            this._sign = 1;
            this.putBytesPositiveToIntegers(val);
        }
        this.cutOffLeadingZeroes();
    }

    private BigInteger(int sign, int value) {
        this._sign = sign;
        this._size = 1;
        this._words = new int[]{value};
    }

    private BigInteger(int sign, long val) {
        this._sign = sign;
        if ((val & 0xFFFFFFFF00000000L) == 0L) {
            this._size = 1;
            this._words = new int[]{(int)val};
        } else {
            this._size = 2;
            this._words = new int[]{(int)val, (int)(val >> 32)};
        }
    }

    public static BigInteger valueOf(long val) {
        if (val < 0L) {
            if (val != -1L) {
                return BigInteger.newInstance(-1, -val);
            }
            return MINUS_ONE;
        }
        if (val <= 10L) {
            return SMALL_VALUES[(int)val];
        }
        return BigInteger.newInstance(1, val);
    }

    static BigInteger valueOfStatic(long val) {
        if (val < 0L) {
            if (val != -1L) {
                return new BigInteger(-1, -val);
            }
            return MINUS_ONE;
        }
        if (val <= 10L) {
            return SMALL_VALUES[(int)val];
        }
        return new BigInteger(1, val);
    }

    public java.math.BigInteger toJavaBigInteger() {
        return new java.math.BigInteger(this.toByteArray());
    }

    /*
     * Unable to fully structure code
     */
    public byte[] toByteArray() {
        block11: {
            if (this._sign == 0) {
                return new byte[1];
            }
            temp = this;
            bitLen = this.bitLength();
            iThis = this.getFirstNonzeroDigit();
            bytesLen = (bitLen >> 3) + 1;
            bytes = new byte[bytesLen];
            firstByteNumber = 0;
            digitIndex = 0;
            bytesInInteger = 4;
            if (bytesLen - (this._size << 2) == 1) {
                bytes[0] = (byte)(this._sign < 0 ? -1 : 0);
                highBytes = 4;
                ++firstByteNumber;
            } else {
                hB = bytesLen & 3;
                highBytes = hB == 0 ? 4 : hB;
            }
            digitIndex = iThis;
            bytesLen -= iThis << 2;
            if (this._sign >= 0) ** GOTO lbl51
            digit = -temp._words[digitIndex];
            if (++digitIndex == this._size) {
                bytesInInteger = highBytes;
            }
            i = 0;
            while (i < bytesInInteger) {
                bytes[--bytesLen] = (byte)digit;
                ++i;
                digit >>= 8;
            }
            while (bytesLen > firstByteNumber) {
                digit = ~temp._words[digitIndex];
                if (++digitIndex == this._size) {
                    bytesInInteger = highBytes;
                }
                i = 0;
                while (i < bytesInInteger) {
                    bytes[--bytesLen] = (byte)digit;
                    ++i;
                    digit >>= 8;
                }
            }
            break block11;
lbl-1000:
            // 1 sources

            {
                digit = temp._words[digitIndex];
                if (++digitIndex == this._size) {
                    bytesInInteger = highBytes;
                }
                i = 0;
                while (i < bytesInInteger) {
                    bytes[--bytesLen] = (byte)digit;
                    ++i;
                    digit >>= 8;
                }
lbl51:
                // 2 sources

                ** while (bytesLen > firstByteNumber)
            }
        }
        return bytes;
    }

    public BigInteger abs() {
        return this._sign < 0 ? BigInteger.newInstance(1, this._size, this._words) : this;
    }

    public BigInteger negate() {
        return this.opposite();
    }

    public BigInteger opposite() {
        return this._sign == 0 ? this : BigInteger.newInstance(-this._sign, this._size, this._words);
    }

    public BigInteger add(long val) {
        return Elementary.add(this, BigInteger.valueOf(val));
    }

    public BigInteger add(BigInteger val) {
        return Elementary.add(this, val);
    }

    public BigInteger subtract(long val) {
        return Elementary.subtract(this, BigInteger.valueOf(val));
    }

    public BigInteger subtract(BigInteger val) {
        return Elementary.subtract(this, val);
    }

    public BigInteger plus(long val) {
        return Elementary.add(this, BigInteger.valueOf(val));
    }

    public BigInteger plus(BigInteger val) {
        return Elementary.add(this, val);
    }

    public BigInteger minus(long val) {
        return Elementary.subtract(this, BigInteger.valueOf(val));
    }

    public BigInteger minus(BigInteger val) {
        return Elementary.subtract(this, val);
    }

    public int signum() {
        return this._sign;
    }

    public BigInteger shiftRight(int n) {
        if (n == 0 || this._sign == 0) {
            return this;
        }
        return n > 0 ? BitLevel.shiftRight(this, n) : BitLevel.shiftLeft(this, -n);
    }

    public BigInteger shiftLeft(int n) {
        if (n == 0 || this._sign == 0) {
            return this;
        }
        return n > 0 ? BitLevel.shiftLeft(this, n) : BitLevel.shiftRight(this, -n);
    }

    public int bitLength() {
        return BitLevel.bitLength(this);
    }

    public boolean testBit(int n) {
        if (n == 0) {
            return (this._words[0] & 1) != 0;
        }
        if (n < 0) {
            throw new ArithmeticException("BigInteger");
        }
        int intCount = n >> 5;
        if (intCount >= this._size) {
            return this._sign < 0;
        }
        int digit = this._words[intCount];
        n = 1 << (n & 0x1F);
        if (this._sign < 0) {
            int firstNonZeroDigit = this.getFirstNonzeroDigit();
            if (intCount < firstNonZeroDigit) {
                return false;
            }
            digit = firstNonZeroDigit == intCount ? -digit : (digit ^= 0xFFFFFFFF);
        }
        return (digit & n) != 0;
    }

    public BigInteger setBit(int n) {
        if (!this.testBit(n)) {
            return BitLevel.flipBit(this, n);
        }
        return this;
    }

    public BigInteger clearBit(int n) {
        if (this.testBit(n)) {
            return BitLevel.flipBit(this, n);
        }
        return this;
    }

    public BigInteger flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("BigInteger");
        }
        return BitLevel.flipBit(this, n);
    }

    public int getLowestSetBit() {
        if (this._sign == 0) {
            return -1;
        }
        int i = this.getFirstNonzeroDigit();
        return (i << 5) + Integer.numberOfTrailingZeros(this._words[i]);
    }

    public int bitCount() {
        return BitLevel.bitCount(this);
    }

    public BigInteger not() {
        return Logical.not(this);
    }

    public BigInteger and(BigInteger val) {
        return Logical.and(this, val);
    }

    public BigInteger or(BigInteger val) {
        return Logical.or(this, val);
    }

    public BigInteger xor(BigInteger val) {
        return Logical.xor(this, val);
    }

    public BigInteger andNot(BigInteger val) {
        return Logical.andNot(this, val);
    }

    public int intValue() {
        return this._sign * this._words[0];
    }

    public long longValue() {
        long value = this._size > 1 ? (long)this._words[1] << 32 | (long)this._words[0] & 0xFFFFFFFFL : (long)this._words[0] & 0xFFFFFFFFL;
        return (long)this._sign * value;
    }

    public long toLong() throws ArithmeticException {
        if (this._size > 2) {
            throw new ArithmeticException("toLong: number to large");
        }
        long value = this._size > 1 ? (long)this._words[1] << 32 | (long)this._words[0] & 0xFFFFFFFFL : (long)this._words[0] & 0xFFFFFFFFL;
        return (long)this._sign * value;
    }

    public int toInt() throws ArithmeticException {
        if (this._size > 1) {
            throw new ArithmeticException("toInt: number to large");
        }
        return this._sign * this._words[0];
    }

    public double doubleValue() {
        return Conversion.bigInteger2Double(this);
    }

    @Override
    public int compareTo(BigInteger val) {
        if (this._sign > val._sign) {
            return 1;
        }
        if (this._sign < val._sign) {
            return -1;
        }
        if (this._size > val._size) {
            return this._sign;
        }
        if (this._size < val._size) {
            return -val._sign;
        }
        return this._sign * Elementary.compareArrays(this._words, val._words, this._size);
    }

    public BigInteger min(BigInteger val) {
        return this.compareTo(val) == -1 ? this : val;
    }

    public BigInteger max(BigInteger val) {
        return this.compareTo(val) == 1 ? this : val;
    }

    public int hashCode() {
        if (this._words.length > 0) {
            return this._words[0];
        }
        return 0;
    }

    public boolean equals(Object x) {
        return x instanceof BigInteger && this.compareTo((BigInteger)x) == 0;
    }

    public String toString() {
        return Conversion.toDecimalScaledString(this, 0);
    }

    public String toString(int radix) {
        return Conversion.bigInteger2String(this, radix);
    }

    public BigInteger gcd(BigInteger val) {
        BigInteger val1 = this.abs();
        BigInteger val2 = val.abs();
        if (val1.signum() == 0) {
            return val2;
        }
        if (val2.signum() == 0) {
            return val1;
        }
        if ((val1._size == 1 || val1._size == 2 && val1._words[1] > 0) && (val2._size == 1 || val2._size == 2 && val2._words[1] > 0)) {
            return BigInteger.valueOf(Division.gcdBinary(val1.longValue(), val2.longValue()));
        }
        return Division.gcdBinary(val1.copy(), val2.copy());
    }

    public BigInteger times(long val) {
        return this.times(BigInteger.valueOf(val));
    }

    public BigInteger times(BigInteger val) {
        if (val._sign == 0) {
            return ZERO;
        }
        if (this._sign == 0) {
            return ZERO;
        }
        return Multiplication.multiply(this, val);
    }

    public BigInteger multiply(long val) {
        return this.times(BigInteger.valueOf(val));
    }

    public BigInteger multiply(BigInteger val) {
        return this.times(BigInteger.valueOf(val));
    }

    public BigInteger pow(int exp) {
        if (exp < 0) {
            throw new ArithmeticException("BigInteger");
        }
        if (exp == 0) {
            return ONE;
        }
        if (exp == 1 || this.equals(ONE) || this.equals(ZERO)) {
            return this;
        }
        return Multiplication.pow(this, exp);
    }

    public BigInteger[] divideAndRemainder(BigInteger divisor) {
        int cmp;
        int divisorSign = divisor._sign;
        if (divisorSign == 0) {
            throw new ArithmeticException("BigInteger");
        }
        int divisorLen = divisor._size;
        int[] divisorDigits = divisor._words;
        if (divisorLen == 1) {
            return Division.divideAndRemainderByInteger(this, divisorDigits[0], divisorSign);
        }
        int[] thisDigits = this._words;
        int thisLen = this._size;
        int n = thisLen != divisorLen ? (thisLen > divisorLen ? 1 : -1) : (cmp = Elementary.compareArrays(thisDigits, divisorDigits, thisLen));
        if (cmp < 0) {
            return new BigInteger[]{ZERO, this};
        }
        int thisSign = this._sign;
        int quotientLength = thisLen - divisorLen + 1;
        int remainderLength = divisorLen;
        int quotientSign = thisSign == divisorSign ? 1 : -1;
        int[] quotientDigits = new int[quotientLength];
        int[] remainderDigits = Division.divide(quotientDigits, quotientLength, thisDigits, thisLen, divisorDigits, divisorLen);
        BigInteger result0 = BigInteger.newInstance(quotientSign, quotientLength, quotientDigits);
        BigInteger result1 = BigInteger.newInstance(thisSign, remainderLength, remainderDigits);
        result0.cutOffLeadingZeroes();
        result1.cutOffLeadingZeroes();
        return new BigInteger[]{result0, result1};
    }

    public BigInteger divide(long divisor) {
        return this.divide(BigInteger.valueOf(divisor));
    }

    public BigInteger divide(BigInteger divisor) {
        int resSign;
        int cmp;
        if (divisor._sign == 0) {
            throw new ArithmeticException("BigInteger");
        }
        int divisorSign = divisor._sign;
        if (divisor.isOne()) {
            return divisor._sign > 0 ? this : this.opposite();
        }
        int thisSign = this._sign;
        int thisLen = this._size;
        int divisorLen = divisor._size;
        if (thisLen + divisorLen == 2) {
            long val = ((long)this._words[0] & 0xFFFFFFFFL) / ((long)divisor._words[0] & 0xFFFFFFFFL);
            if (thisSign != divisorSign) {
                val = -val;
            }
            return BigInteger.valueOf(val);
        }
        int n = thisLen != divisorLen ? (thisLen > divisorLen ? 1 : -1) : (cmp = Elementary.compareArrays(this._words, divisor._words, thisLen));
        if (cmp == 0) {
            return thisSign == divisorSign ? ONE : MINUS_ONE;
        }
        if (cmp == -1) {
            return ZERO;
        }
        int resLength = thisLen - divisorLen + 1;
        int[] resDigits = new int[resLength];
        int n2 = resSign = thisSign == divisorSign ? 1 : -1;
        if (divisorLen == 1) {
            Division.divideArrayByInt(resDigits, this._words, thisLen, divisor._words[0]);
        } else {
            Division.divide(resDigits, resLength, this._words, thisLen, divisor._words, divisorLen);
        }
        BigInteger result = BigInteger.newInstance(resSign, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    public BigInteger remainder(BigInteger divisor) {
        if (divisor._sign == 0) {
            throw new ArithmeticException("BigInteger");
        }
        int thisLen = this._size;
        int divisorLen = divisor._size;
        if ((thisLen != divisorLen ? (thisLen > divisorLen ? 1 : -1) : Elementary.compareArrays(this._words, divisor._words, thisLen)) == -1) {
            return this;
        }
        int resLength = divisorLen;
        int[] resDigits = new int[resLength];
        if (resLength == 1) {
            resDigits[0] = Division.remainderArrayByInt(this._words, thisLen, divisor._words[0]);
        } else {
            int qLen = thisLen - divisorLen + 1;
            resDigits = Division.divide(null, qLen, this._words, thisLen, divisor._words, divisorLen);
        }
        BigInteger result = BigInteger.newInstance(this._sign, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    public BigInteger modInverse(BigInteger m) {
        if (m._sign <= 0) {
            throw new ArithmeticException("BigInteger");
        }
        if (!this.testBit(0) && !m.testBit(0)) {
            throw new ArithmeticException("BigInteger");
        }
        if (m.isOne()) {
            return ZERO;
        }
        BigInteger res = Division.modInverseMontgomery(this.abs().mod(m), m);
        if (res._sign == 0) {
            throw new ArithmeticException("BigInteger");
        }
        res = this._sign < 0 ? m.minus(res) : res;
        return res;
    }

    public BigInteger modPow(BigInteger exponent, BigInteger m) {
        BigInteger res;
        if (m._sign <= 0) {
            throw new ArithmeticException("BigInteger");
        }
        BigInteger base = this;
        if (m.isOne() | exponent._sign > 0 & base._sign == 0) {
            return ZERO;
        }
        if (base._sign == 0 && exponent._sign == 0) {
            return ONE;
        }
        if (exponent._sign < 0) {
            base = this.modInverse(m);
            exponent = exponent.opposite();
        }
        BigInteger bigInteger = res = m.testBit(0) ? Division.oddModPow(base.abs(), exponent, m) : Division.evenModPow(base.abs(), exponent, m);
        if (base._sign < 0 && exponent.testBit(0)) {
            res = m.minus(ONE).times(res).mod(m);
        }
        return res;
    }

    public BigInteger mod(BigInteger m) {
        if (m._sign <= 0) {
            throw new ArithmeticException("BigInteger");
        }
        BigInteger rem = this.remainder(m);
        return rem._sign < 0 ? rem.plus(m) : rem;
    }

    public boolean isProbablePrime(int certainty) {
        return Primality.isProbablePrime(this.abs(), certainty);
    }

    public BigInteger nextProbablePrime() {
        if (this._sign < 0) {
            throw new ArithmeticException("BigInteger");
        }
        return Primality.nextProbablePrime(this);
    }

    public BigInteger nextProbablePrime(int n) {
        if (this._sign < 0 || n <= 0) {
            throw new ArithmeticException("BigInteger");
        }
        BigInteger temp = this;
        int i = 0;
        while (i < n) {
            temp = Primality.nextProbablePrime(temp);
            ++i;
        }
        return temp;
    }

    public static BigInteger probablePrime(int bitLength, Random rnd) {
        return new BigInteger(bitLength, 100, rnd);
    }

    final void cutOffLeadingZeroes() {
        while (this._size > 0 && this._words[--this._size] == 0) {
        }
        if (this._words[this._size++] == 0) {
            this._sign = 0;
        }
    }

    public boolean isOne() {
        return this._size == 1 && this._words[0] == 1;
    }

    private void putBytesPositiveToIntegers(byte[] byteValues) {
        int bytesLen;
        int highBytes = (bytesLen = byteValues.length) & 3;
        this._size = (bytesLen >> 2) + (highBytes == 0 ? 0 : 1);
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < this._size) {
            throw new ObjectMemoryExceededException("BigInteger", this._size);
        }
        this._words = new int[this._size];
        int i = 0;
        while (bytesLen > highBytes) {
            this._words[i++] = byteValues[--bytesLen] & 0xFF | (byteValues[--bytesLen] & 0xFF) << 8 | (byteValues[--bytesLen] & 0xFF) << 16 | (byteValues[--bytesLen] & 0xFF) << 24;
        }
        int j = 0;
        while (j < bytesLen) {
            this._words[i] = this._words[i] << 8 | byteValues[j] & 0xFF;
            ++j;
        }
    }

    private void putBytesNegativeToIntegers(byte[] byteValues) {
        int bytesLen;
        int highBytes = (bytesLen = byteValues.length) & 3;
        this._size = (bytesLen >> 2) + (highBytes == 0 ? 0 : 1);
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < this._size) {
            throw new ObjectMemoryExceededException("BigInteger", this._size);
        }
        this._words = new int[this._size];
        int i = 0;
        this._words[this._size - 1] = -1;
        while (bytesLen > highBytes) {
            this._words[i] = byteValues[--bytesLen] & 0xFF | (byteValues[--bytesLen] & 0xFF) << 8 | (byteValues[--bytesLen] & 0xFF) << 16 | (byteValues[--bytesLen] & 0xFF) << 24;
            if (this._words[i] != 0) {
                this._words[i] = -this._words[i];
                this.firstNonzeroDigit = i++;
                while (bytesLen > highBytes) {
                    this._words[i] = byteValues[--bytesLen] & 0xFF | (byteValues[--bytesLen] & 0xFF) << 8 | (byteValues[--bytesLen] & 0xFF) << 16 | (byteValues[--bytesLen] & 0xFF) << 24;
                    this._words[i] = ~this._words[i];
                    ++i;
                }
                break;
            }
            ++i;
        }
        if (highBytes != 0) {
            if (this.firstNonzeroDigit != -2) {
                int j = 0;
                while (j < bytesLen) {
                    this._words[i] = this._words[i] << 8 | byteValues[j] & 0xFF;
                    ++j;
                }
                this._words[i] = ~this._words[i];
            } else {
                int j = 0;
                while (j < bytesLen) {
                    this._words[i] = this._words[i] << 8 | byteValues[j] & 0xFF;
                    ++j;
                }
                this._words[i] = -this._words[i];
            }
        }
    }

    int getFirstNonzeroDigit() {
        if (this.firstNonzeroDigit == -2) {
            int i;
            if (this._sign == 0) {
                i = -1;
            } else {
                i = 0;
                while (this._words[i] == 0) {
                    ++i;
                }
            }
            this.firstNonzeroDigit = i;
        }
        return this.firstNonzeroDigit;
    }

    public BigInteger copy() {
        int[] copyDigits = new int[this._size];
        System.arraycopy(this._words, 0, copyDigits, 0, this._size);
        return BigInteger.newInstance(this._sign, this._size, copyDigits);
    }

    public BigInteger copyNew() {
        int[] copyDigits = new int[this._size];
        System.arraycopy(this._words, 0, copyDigits, 0, this._size);
        BigInteger z = new BigInteger();
        z._sign = this._sign;
        z._size = this._size;
        z._words = copyDigits;
        return z;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._sign = this.signum;
        this.putBytesPositiveToIntegers(this.magnitude);
        this.cutOffLeadingZeroes();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.signum = this.signum();
        this.magnitude = this.abs().toByteArray();
        out.defaultWriteObject();
    }

    void unCache() {
        this.firstNonzeroDigit = -2;
    }

    public String getString() {
        return Conversion.toDecimalScaledString(this, 0);
    }

    public boolean isLargerThan(BigInteger that) {
        return this.compareTo(that) == 1;
    }

    public boolean isLessThan(BigInteger that) {
        return this.compareTo(that) == -1;
    }

    public boolean isNegative() {
        return this.compareTo(ZERO) == -1;
    }

    public boolean isPositive() {
        return this.compareTo(ZERO) == 1;
    }

    public boolean isZero() {
        return this.compareTo(ZERO) == 0;
    }

    public boolean isEven() {
        return !this.testBit(0);
    }

    public boolean isOdd() {
        return this.testBit(0);
    }

    public static BigInteger valueOf(String val, int radix) {
        if (val == null) {
            throw new NullPointerException();
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("BigInteger");
        }
        if (val.length() == 0) {
            throw new NumberFormatException("BigInteger");
        }
        BigInteger me = Conversion.string2BigInteger(val, radix);
        return me;
    }

    public static BigInteger valueOf(BigInteger val) {
        int[] words = new int[val._size];
        System.arraycopy(val._words, 0, words, 0, val._size);
        return BigInteger.newInstance(val._sign, words);
    }

    public static void main(String[] args) {
        BigInteger i = BigInteger.valueOf(1000000L).nextProbablePrime();
        System.out.println(i);
    }
}

