/*
 * Decompiled with CFR 0.152.
 */
package apache.harmony.math;

import apache.harmony.math.BigInteger;
import org.matheclipse.basic.Config;
import org.matheclipse.basic.ObjectMemoryExceededException;

class BitLevel {
    private BitLevel() {
    }

    static int bitLength(BigInteger val) {
        int i;
        if (val._sign == 0) {
            return 0;
        }
        int bLength = val._size << 5;
        int highDigit = val._words[val._size - 1];
        if (val._sign < 0 && (i = val.getFirstNonzeroDigit()) == val._size - 1) {
            --highDigit;
        }
        return bLength -= Integer.numberOfLeadingZeros(highDigit);
    }

    static int bitCount(BigInteger val) {
        int bCount = 0;
        if (val._sign == 0) {
            return 0;
        }
        int i = val.getFirstNonzeroDigit();
        if (val._sign > 0) {
            while (i < val._size) {
                bCount += Integer.bitCount(val._words[i]);
                ++i;
            }
        } else {
            bCount += Integer.bitCount(-val._words[i]);
            ++i;
            while (i < val._size) {
                bCount += Integer.bitCount(~val._words[i]);
                ++i;
            }
            bCount = (val._size << 5) - bCount;
        }
        return bCount;
    }

    static boolean testBit(BigInteger val, int n) {
        return (val._words[n >> 5] & 1 << (n & 0x1F)) != 0;
    }

    static boolean nonZeroDroppedBits(int numberOfBits, int[] digits) {
        int intCount = numberOfBits >> 5;
        int bitCount = numberOfBits & 0x1F;
        int i = 0;
        while (i < intCount && digits[i] == 0) {
            ++i;
        }
        return i != intCount || digits[i] << 32 - bitCount != 0;
    }

    static BigInteger shiftLeft(BigInteger source, int count) {
        int intCount = count >> 5;
        int resLength = source._size + intCount + ((count &= 0x1F) == 0 ? 0 : 1);
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < resLength) {
            throw new ObjectMemoryExceededException("BigInteger", resLength);
        }
        int[] resDigits = new int[resLength];
        BitLevel.shiftLeft(resDigits, source._words, intCount, count);
        BigInteger result = BigInteger.newInstance(source._sign, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static void inplaceShiftLeft(BigInteger val, int count) {
        int intCount = count >> 5;
        val._size = val._size + (intCount + (Integer.numberOfLeadingZeros(val._words[val._size - 1]) - (count & 0x1F) >= 0 ? 0 : 1));
        BitLevel.shiftLeft(val._words, val._words, intCount, count & 0x1F);
        val.cutOffLeadingZeroes();
        val.unCache();
    }

    static void shiftLeft(int[] result, int[] source, int intCount, int count) {
        if (count == 0) {
            System.arraycopy(source, 0, result, intCount, result.length - intCount);
        } else {
            int rightShiftCount = 32 - count;
            result[result.length - 1] = 0;
            int i = result.length - 1;
            while (i > intCount) {
                int n = i;
                result[n] = result[n] | source[i - intCount - 1] >>> rightShiftCount;
                result[i - 1] = source[i - intCount - 1] << count;
                --i;
            }
        }
        int i = 0;
        while (i < intCount) {
            result[i] = 0;
            ++i;
        }
    }

    static BigInteger shiftRight(BigInteger source, int count) {
        int intCount = count >> 5;
        count &= 0x1F;
        if (intCount >= source._size) {
            return source._sign < 0 ? BigInteger.MINUS_ONE : BigInteger.ZERO;
        }
        int resLength = source._size - intCount;
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < resLength + 1) {
            throw new ObjectMemoryExceededException("BigInteger", resLength + 1);
        }
        int[] resDigits = new int[resLength + 1];
        BitLevel.shiftRight(resDigits, resLength, source._words, intCount, count);
        if (source._sign < 0) {
            int i = 0;
            while (i < intCount && source._words[i] == 0) {
                ++i;
            }
            if (i < intCount || count > 0 && source._words[i] << 32 - count != 0) {
                i = 0;
                while (i < resLength && resDigits[i] == -1) {
                    resDigits[i] = 0;
                    ++i;
                }
                if (i == resLength) {
                    ++resLength;
                }
                int n = i;
                resDigits[n] = resDigits[n] + 1;
            }
        }
        BigInteger result = BigInteger.newInstance(source._sign, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static void inplaceShiftRight(BigInteger val, int count) {
        int sign = val.signum();
        if (count == 0 || val.signum() == 0) {
            return;
        }
        int intCount = count >> 5;
        val._size -= intCount;
        if (!BitLevel.shiftRight(val._words, val._size, val._words, intCount, count & 0x1F) && sign < 0) {
            int i = 0;
            while (i < val._size && val._words[i] == -1) {
                val._words[i] = 0;
                ++i;
            }
            if (i == val._size) {
                ++val._size;
            }
            int n = i;
            val._words[n] = val._words[n] + 1;
        }
        val.cutOffLeadingZeroes();
        val.unCache();
    }

    static boolean shiftRight(int[] result, int resultLen, int[] source, int intCount, int count) {
        boolean allZero = true;
        int i = 0;
        while (i < intCount) {
            allZero &= source[i] == 0;
            ++i;
        }
        if (count == 0) {
            System.arraycopy(source, intCount, result, 0, resultLen);
            i = resultLen;
        } else {
            int leftShiftCount = 32 - count;
            allZero &= source[i] << leftShiftCount == 0;
            i = 0;
            while (i < resultLen - 1) {
                result[i] = source[i + intCount] >>> count | source[i + intCount + 1] << leftShiftCount;
                ++i;
            }
            result[i] = source[i + intCount] >>> count;
            ++i;
        }
        return allZero;
    }

    static BigInteger flipBit(BigInteger val, int n) {
        int resSign = val._sign == 0 ? 1 : val._sign;
        int intCount = n >> 5;
        int bitN = n & 0x1F;
        int resLength = Math.max(intCount + 1, val._size) + 1;
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < resLength) {
            throw new ObjectMemoryExceededException("BigInteger", resLength);
        }
        int[] resDigits = new int[resLength];
        int bitNumber = 1 << bitN;
        System.arraycopy(val._words, 0, resDigits, 0, val._size);
        if (val._sign < 0) {
            if (intCount >= val._size) {
                resDigits[intCount] = bitNumber;
            } else {
                int firstNonZeroDigit = val.getFirstNonzeroDigit();
                if (intCount > firstNonZeroDigit) {
                    int n2 = intCount;
                    resDigits[n2] = resDigits[n2] ^ bitNumber;
                } else if (intCount < firstNonZeroDigit) {
                    resDigits[intCount] = -bitNumber;
                    int i = intCount + 1;
                    while (i < firstNonZeroDigit) {
                        resDigits[i] = -1;
                        ++i;
                    }
                    int n3 = i;
                    resDigits[n3] = resDigits[n3] - 1;
                } else {
                    int i = intCount;
                    resDigits[i] = -(-resDigits[intCount] ^ bitNumber);
                    if (resDigits[i] == 0) {
                        ++i;
                        while (resDigits[i] == -1) {
                            resDigits[i] = 0;
                            ++i;
                        }
                        int n4 = i;
                        resDigits[n4] = resDigits[n4] + 1;
                    }
                }
            }
        } else {
            int n5 = intCount;
            resDigits[n5] = resDigits[n5] ^ bitNumber;
        }
        BigInteger result = BigInteger.newInstance(resSign, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }
}

