/*
 * Decompiled with CFR 0.152.
 */
package apache.harmony.math;

import apache.harmony.math.BigInteger;
import apache.harmony.math.BitLevel;
import apache.harmony.math.Division;
import apache.harmony.math.Elementary;
import apache.harmony.math.Multiplication;
import org.matheclipse.basic.Config;
import org.matheclipse.basic.ObjectMemoryExceededException;

class Conversion {
    private static final int[] digitFitInInt = new int[]{-1, -1, 31, 19, 15, 13, 11, 11, 10, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5};
    private static final int[] bigRadices = new int[]{Integer.MIN_VALUE, 1162261467, 0x40000000, 1220703125, 362797056, 1977326743, 0x40000000, 387420489, 1000000000, 214358881, 429981696, 815730721, 1475789056, 170859375, 0x10000000, 410338673, 612220032, 893871739, 1280000000, 1801088541, 113379904, 148035889, 191102976, 244140625, 308915776, 387420489, 481890304, 594823321, 729000000, 887503681, 0x40000000, 1291467969, 1544804416, 1838265625, 60466176};

    private Conversion() {
    }

    static BigInteger string2BigInteger(String val, int radix) {
        int startChar;
        int sign;
        int stringLength = val.length();
        int endChar = stringLength--;
        if (val.charAt(0) == '-') {
            sign = -1;
            startChar = 1;
        } else {
            sign = 1;
            startChar = 0;
        }
        int charsPerInt = digitFitInInt[radix];
        int bigRadixDigitsLength = stringLength / charsPerInt;
        int topChars = stringLength % charsPerInt;
        if (topChars != 0) {
            ++bigRadixDigitsLength;
        }
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < bigRadixDigitsLength) {
            throw new ObjectMemoryExceededException("BigInteger", bigRadixDigitsLength);
        }
        int[] digits = new int[bigRadixDigitsLength];
        int bigRadix = bigRadices[radix - 2];
        int digitIndex = 0;
        int substrEnd = startChar + (topChars == 0 ? charsPerInt : topChars);
        int substrStart = startChar;
        while (substrStart < endChar) {
            int bigRadixDigit = Integer.parseInt(val.substring(substrStart, substrEnd), radix);
            int newDigit = Multiplication.multiplyByInt(digits, digitIndex, bigRadix);
            digits[digitIndex++] = newDigit += Elementary.inplaceAdd(digits, digitIndex, bigRadixDigit);
            substrStart = substrEnd;
            substrEnd = substrStart + charsPerInt;
        }
        int numberLength = digitIndex;
        BigInteger result = BigInteger.newInstance(sign, numberLength, digits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static String bigInteger2String(BigInteger val, int radix) {
        int resDigit;
        int sign = val._sign;
        int numberLength = val._size;
        int[] digits = val._words;
        if (sign == 0) {
            return "0";
        }
        if (numberLength == 1) {
            int highDigit = digits[numberLength - 1];
            long v = (long)highDigit & 0xFFFFFFFFL;
            if (sign < 0) {
                v = -v;
            }
            return Long.toString(v, radix);
        }
        if (radix == 10 || radix < 2 || radix > 36) {
            return val.toString();
        }
        double bitsForRadixDigit = Math.log(radix) / Math.log(2.0);
        int resLengthInChars = (int)((double)val.abs().bitLength() / bitsForRadixDigit + (double)(sign < 0 ? 1 : 0)) + 1;
        char[] result = new char[resLengthInChars];
        int currentChar = resLengthInChars;
        if (radix != 16) {
            int i;
            int[] temp = new int[numberLength];
            System.arraycopy(digits, 0, temp, 0, numberLength);
            int tempLen = numberLength;
            int charsPerInt = digitFitInInt[radix];
            int bigRadix = bigRadices[radix - 2];
            do {
                resDigit = Division.divideArrayByInt(temp, temp, tempLen, bigRadix);
                int previous = currentChar;
                do {
                    result[--currentChar] = Character.forDigit(resDigit % radix, radix);
                } while ((resDigit /= radix) != 0 && currentChar != 0);
                int delta = charsPerInt - previous + currentChar;
                i = 0;
                while (i < delta && currentChar > 0) {
                    result[--currentChar] = 48;
                    ++i;
                }
                i = tempLen - 1;
                while (i > 0 && temp[i] == 0) {
                    --i;
                }
            } while ((tempLen = i + 1) != 1 || temp[0] != 0);
        } else {
            int i = 0;
            while (i < numberLength) {
                int j = 0;
                while (j < 8 && currentChar > 0) {
                    resDigit = digits[i] >> (j << 2) & 0xF;
                    result[--currentChar] = Character.forDigit(resDigit, 16);
                    ++j;
                }
                ++i;
            }
        }
        while (result[currentChar] == '0') {
            ++currentChar;
        }
        if (sign == -1) {
            result[--currentChar] = 45;
        }
        return new String(result, currentChar, resLengthInChars - currentChar);
    }

    /*
     * Unable to fully structure code
     */
    static String toDecimalScaledString(BigInteger val, int scale) {
        block36: {
            block35: {
                sign = val._sign;
                numberLength = val._size;
                digits = val._words;
                if (sign == 0) {
                    switch (scale) {
                        case 0: {
                            return "0";
                        }
                        case 1: {
                            return "0.0";
                        }
                        case 2: {
                            return "0.00";
                        }
                        case 3: {
                            return "0.000";
                        }
                        case 4: {
                            return "0.0000";
                        }
                        case 5: {
                            return "0.00000";
                        }
                        case 6: {
                            return "0.000000";
                        }
                    }
                    result1 = new StringBuffer();
                    if (scale < 0) {
                        result1.append("0E+");
                    } else {
                        result1.append("0E");
                    }
                    result1.append(-scale);
                    return result1.toString();
                }
                resLengthInChars = numberLength * 10 + 1 + 7;
                result = new char[resLengthInChars + 1];
                currentChar = resLengthInChars;
                if (numberLength != 1) break block35;
                highDigit = digits[0];
                if (highDigit < 0) {
                    v = (long)highDigit & 0xFFFFFFFFL;
                    do {
                        prev = v;
                        result[--currentChar] = (char)(48 + (int)(prev - (v /= 10L) * 10L));
                    } while (v != 0L);
                } else {
                    v = highDigit;
                    do {
                        prev = v;
                        result[--currentChar] = (char)(48 + (prev - (v /= 10) * 10));
                    } while (v != 0);
                }
                break block36;
            }
            temp = new int[numberLength];
            tempLen = numberLength;
            System.arraycopy(digits, 0, temp, 0, tempLen);
            while (true) {
                result11 = 0L;
                i1 = tempLen - 1;
                while (i1 >= 0) {
                    temp1 = (result11 << 32) + ((long)temp[i1] & 0xFFFFFFFFL);
                    res = Conversion.divideLongByBillion(temp1);
                    temp[i1] = (int)res;
                    result11 = (int)(res >> 32);
                    --i1;
                }
                resDigit = (int)result11;
                previous = currentChar;
                do {
                    result[--currentChar] = (char)(48 + resDigit % 10);
                } while ((resDigit /= 10) != 0 && currentChar != 0);
                delta = 9 - previous + currentChar;
                i = 0;
                while (i < delta && currentChar > 0) {
                    result[--currentChar] = 48;
                    ++i;
                }
                j = tempLen - 1;
                while (temp[j] == 0) {
                    if (j != 0) {
                        --j;
                        continue;
                    }
                    ** GOTO lbl82
                }
                tempLen = j + 1;
            }
lbl-1000:
            // 1 sources

            {
                ++currentChar;
lbl82:
                // 2 sources

                ** while (result[currentChar] == '0')
            }
        }
        negNumber = sign < 0;
        exponent = resLengthInChars - currentChar - scale - 1;
        if (scale == 0) {
            if (negNumber) {
                result[--currentChar] = 45;
            }
            return new String(result, currentChar, resLengthInChars - currentChar);
        }
        if (scale > 0 && exponent >= -6) {
            if (exponent >= 0) {
                insertPoint = currentChar + exponent;
                j = resLengthInChars - 1;
                while (j >= insertPoint) {
                    result[j + 1] = result[j];
                    --j;
                }
                result[++insertPoint] = 46;
                if (negNumber) {
                    result[--currentChar] = 45;
                }
                return new String(result, currentChar, resLengthInChars - currentChar + 1);
            }
            j = 2;
            while (j < -exponent + 1) {
                result[--currentChar] = 48;
                ++j;
            }
            result[--currentChar] = 46;
            result[--currentChar] = 48;
            if (negNumber) {
                result[--currentChar] = 45;
            }
            return new String(result, currentChar, resLengthInChars - currentChar);
        }
        startPoint = currentChar + 1;
        endPoint = resLengthInChars;
        result1 = new StringBuffer(16 + endPoint - startPoint);
        if (negNumber) {
            result1.append('-');
        }
        if (endPoint - startPoint >= 1) {
            result1.append(result[currentChar]);
            result1.append('.');
            result1.append(result, currentChar + 1, resLengthInChars - currentChar - 1);
        } else {
            result1.append(result, currentChar, resLengthInChars - currentChar);
        }
        result1.append('E');
        if (exponent > 0) {
            result1.append('+');
        }
        result1.append(Integer.toString(exponent));
        return result1.toString();
    }

    static String toDecimalScaledString(long value, int scale) {
        boolean negNumber;
        boolean bl = negNumber = value < 0L;
        if (negNumber) {
            value = -value;
        }
        if (value == 0L) {
            switch (scale) {
                case 0: {
                    return "0";
                }
                case 1: {
                    return "0.0";
                }
                case 2: {
                    return "0.00";
                }
                case 3: {
                    return "0.000";
                }
                case 4: {
                    return "0.0000";
                }
                case 5: {
                    return "0.00000";
                }
                case 6: {
                    return "0.000000";
                }
            }
            StringBuffer result1 = new StringBuffer();
            if (scale < 0) {
                result1.append("0E+");
            } else {
                result1.append("0E");
            }
            result1.append(scale == Integer.MIN_VALUE ? "2147483648" : Integer.toString(-scale));
            return result1.toString();
        }
        int resLengthInChars = 18;
        char[] result = new char[resLengthInChars + 1];
        int currentChar = resLengthInChars;
        long v = value;
        do {
            long prev = v;
            result[--currentChar] = (char)(48L + (prev - (v /= 10L) * 10L));
        } while (v != 0L);
        long exponent = (long)resLengthInChars - (long)currentChar - (long)scale - 1L;
        if (scale == 0) {
            if (negNumber) {
                result[--currentChar] = 45;
            }
            return new String(result, currentChar, resLengthInChars - currentChar);
        }
        if (scale > 0 && exponent >= -6L) {
            if (exponent >= 0L) {
                int insertPoint = currentChar + (int)exponent;
                int j = resLengthInChars - 1;
                while (j >= insertPoint) {
                    result[j + 1] = result[j];
                    --j;
                }
                result[++insertPoint] = 46;
                if (negNumber) {
                    result[--currentChar] = 45;
                }
                return new String(result, currentChar, resLengthInChars - currentChar + 1);
            }
            int j = 2;
            while ((long)j < -exponent + 1L) {
                result[--currentChar] = 48;
                ++j;
            }
            result[--currentChar] = 46;
            result[--currentChar] = 48;
            if (negNumber) {
                result[--currentChar] = 45;
            }
            return new String(result, currentChar, resLengthInChars - currentChar);
        }
        int startPoint = currentChar + 1;
        int endPoint = resLengthInChars;
        StringBuffer result1 = new StringBuffer(16 + endPoint - startPoint);
        if (negNumber) {
            result1.append('-');
        }
        if (endPoint - startPoint >= 1) {
            result1.append(result[currentChar]);
            result1.append('.');
            result1.append(result, currentChar + 1, resLengthInChars - currentChar - 1);
        } else {
            result1.append(result, currentChar, resLengthInChars - currentChar);
        }
        result1.append('E');
        if (exponent > 0L) {
            result1.append('+');
        }
        result1.append(Long.toString(exponent));
        return result1.toString();
    }

    static long divideLongByBillion(long a) {
        long rem;
        long quot;
        if (a >= 0L) {
            long bLong = 1000000000L;
            quot = a / bLong;
            rem = a % bLong;
        } else {
            long aPos = a >>> 1;
            long bPos = 500000000L;
            quot = aPos / bPos;
            rem = aPos % bPos;
            rem = (rem << 1) + (a & 1L);
        }
        return rem << 32 | quot & 0xFFFFFFFFL;
    }

    static double bigInteger2Double(BigInteger val) {
        if (val._size < 2 || val._size == 2 && val._words[1] > 0) {
            return val.longValue();
        }
        if (val._size > 32) {
            return val._sign > 0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        int bitLen = val.abs().bitLength();
        long exponent = bitLen - 1;
        int delta = bitLen - 54;
        long lVal = val.abs().shiftRight(delta).longValue();
        long mantissa = lVal & 0x1FFFFFFFFFFFFFL;
        if (exponent == 1023L) {
            if (mantissa == 0x1FFFFFFFFFFFFFL) {
                return val._sign > 0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            if (mantissa == 0x1FFFFFFFFFFFFEL) {
                return val._sign > 0 ? Double.MAX_VALUE : -1.7976931348623157E308;
            }
        }
        if ((mantissa & 1L) == 1L && ((mantissa & 2L) == 2L || BitLevel.nonZeroDroppedBits(delta, val._words))) {
            mantissa += 2L;
        }
        long resSign = val._sign < 0 ? Long.MIN_VALUE : 0L;
        exponent = 1023L + exponent << 52 & 0x7FF0000000000000L;
        long result = resSign | exponent | (mantissa >>= 1);
        return Double.longBitsToDouble(result);
    }
}

