/*
 * Decompiled with CFR 0.152.
 */
package apache.harmony.math;

import apache.harmony.math.BigInteger;
import apache.harmony.math.BitLevel;
import apache.harmony.math.Elementary;
import org.matheclipse.basic.Config;
import org.matheclipse.basic.ObjectMemoryExceededException;

class Division {
    Division() {
    }

    static int[] divide(int[] quot, int quotLength, int[] a, int aLength, int[] b, int bLength) {
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < aLength + 1) {
            throw new ObjectMemoryExceededException("BigInteger", aLength + 1);
        }
        int[] normA = new int[aLength + 1];
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < bLength + 1) {
            throw new ObjectMemoryExceededException("BigInteger", bLength + 1);
        }
        int[] normB = new int[bLength + 1];
        int normBLength = bLength;
        int divisorShift = Integer.numberOfLeadingZeros(b[bLength - 1]);
        if (divisorShift != 0) {
            BitLevel.shiftLeft(normB, b, 0, divisorShift);
            BitLevel.shiftLeft(normA, a, 0, divisorShift);
        } else {
            System.arraycopy(a, 0, normA, 0, aLength);
            System.arraycopy(b, 0, normB, 0, bLength);
        }
        int firstDivisorDigit = normB[normBLength - 1];
        int i = quotLength - 1;
        int j = aLength;
        while (i >= 0) {
            int borrow;
            int guessDigit = 0;
            if (normA[j] == firstDivisorDigit) {
                guessDigit = -1;
            } else {
                long product = (((long)normA[j] & 0xFFFFFFFFL) << 32) + ((long)normA[j - 1] & 0xFFFFFFFFL);
                long res = Division.divideLongByInt(product, firstDivisorDigit);
                guessDigit = (int)res;
                int rem = (int)(res >> 32);
                if (guessDigit != 0) {
                    long leftHand = 0L;
                    long rightHand = 0L;
                    boolean rOverflowed = false;
                    ++guessDigit;
                    do {
                        --guessDigit;
                        if (rOverflowed) break;
                        leftHand = ((long)guessDigit & 0xFFFFFFFFL) * ((long)normB[normBLength - 2] & 0xFFFFFFFFL);
                        rightHand = ((long)rem << 32) + ((long)normA[j - 2] & 0xFFFFFFFFL);
                        long longR = ((long)rem & 0xFFFFFFFFL) + ((long)firstDivisorDigit & 0xFFFFFFFFL);
                        if (Integer.numberOfLeadingZeros((int)(longR >>> 32)) < 32) {
                            rOverflowed = true;
                            continue;
                        }
                        rem = (int)longR;
                    } while ((leftHand ^ Long.MIN_VALUE) > (rightHand ^ Long.MIN_VALUE));
                }
            }
            if (guessDigit != 0 && (borrow = Division.multiplyAndSubtract(normA, j - normBLength, normB, normBLength, (long)guessDigit & 0xFFFFFFFFL)) != 0) {
                --guessDigit;
                long carry = 0L;
                int k = 0;
                while (k < normBLength) {
                    normA[j - normBLength + k] = (int)(carry += ((long)normA[j - normBLength + k] & 0xFFFFFFFFL) + ((long)normB[k] & 0xFFFFFFFFL));
                    carry >>>= 32;
                    ++k;
                }
            }
            if (quot != null) {
                quot[i] = guessDigit;
            }
            --j;
            --i;
        }
        if (divisorShift != 0) {
            BitLevel.shiftRight(normB, normBLength, normA, 0, divisorShift);
            return normB;
        }
        System.arraycopy(normA, 0, normB, 0, bLength);
        return normA;
    }

    static int divideArrayByInt(int[] dest, int[] src, int srcLength, int divisor) {
        long rem = 0L;
        long bLong = (long)divisor & 0xFFFFFFFFL;
        int i = srcLength - 1;
        while (i >= 0) {
            long quot;
            long temp = rem << 32 | (long)src[i] & 0xFFFFFFFFL;
            if (temp >= 0L) {
                quot = temp / bLong;
                rem = temp % bLong;
            } else {
                long aPos = temp >>> 1;
                long bPos = divisor >>> 1;
                quot = aPos / bPos;
                rem = aPos % bPos;
                rem = (rem << 1) + (temp & 1L);
                if ((divisor & 1) != 0) {
                    if (quot <= rem) {
                        rem -= quot;
                    } else if (quot - rem <= bLong) {
                        rem += bLong - quot;
                        --quot;
                    } else {
                        rem += (bLong << 1) - quot;
                        quot -= 2L;
                    }
                }
            }
            dest[i] = (int)(quot & 0xFFFFFFFFL);
            --i;
        }
        return (int)rem;
    }

    static int remainderArrayByInt(int[] src, int srcLength, int divisor) {
        long result = 0L;
        int i = srcLength - 1;
        while (i >= 0) {
            long temp = (result << 32) + ((long)src[i] & 0xFFFFFFFFL);
            long res = Division.divideLongByInt(temp, divisor);
            result = (int)(res >> 32);
            --i;
        }
        return (int)result;
    }

    static int remainder(BigInteger dividend, int divisor) {
        return Division.remainderArrayByInt(dividend._words, dividend._size, divisor);
    }

    static long divideLongByInt(long a, int b) {
        long rem;
        long quot;
        long bLong = (long)b & 0xFFFFFFFFL;
        if (a >= 0L) {
            quot = a / bLong;
            rem = a % bLong;
        } else {
            long aPos = a >>> 1;
            long bPos = b >>> 1;
            quot = aPos / bPos;
            rem = aPos % bPos;
            rem = (rem << 1) + (a & 1L);
            if ((b & 1) != 0) {
                if (quot <= rem) {
                    rem -= quot;
                } else if (quot - rem <= bLong) {
                    rem += bLong - quot;
                    --quot;
                } else {
                    rem += (bLong << 1) - quot;
                    quot -= 2L;
                }
            }
        }
        return rem << 32 | quot & 0xFFFFFFFFL;
    }

    static BigInteger[] divideAndRemainderByInteger(BigInteger val, int divisor, int divisorSign) {
        int[] valDigits = val._words;
        int valLen = val._size;
        int valSign = val._sign;
        if (valLen == 1) {
            long a = (long)valDigits[0] & 0xFFFFFFFFL;
            long b = (long)divisor & 0xFFFFFFFFL;
            long quo = a / b;
            long rem = a % b;
            if (valSign != divisorSign) {
                quo = -quo;
            }
            if (valSign < 0) {
                rem = -rem;
            }
            return new BigInteger[]{BigInteger.valueOf(quo), BigInteger.valueOf(rem)};
        }
        int quotientLength = valLen;
        int quotientSign = valSign == divisorSign ? 1 : -1;
        int[] quotientDigits = new int[quotientLength];
        int[] remainderDigits = new int[]{Division.divideArrayByInt(quotientDigits, valDigits, valLen, divisor)};
        BigInteger result0 = BigInteger.newInstance(quotientSign, quotientLength, quotientDigits);
        BigInteger result1 = BigInteger.newInstance(valSign, 1, remainderDigits);
        result0.cutOffLeadingZeroes();
        result1.cutOffLeadingZeroes();
        return new BigInteger[]{result0, result1};
    }

    static int multiplyAndSubtract(int[] a, int start, int[] b, int bLen, long c) {
        long product;
        int carry = 0;
        int i = 0;
        while (i < bLen) {
            product = c * ((long)b[i] & 0xFFFFFFFFL);
            int productInt = (int)product;
            carry = (int)(product >> 32) + (((productInt += carry) ^ Integer.MIN_VALUE) < (carry ^ Integer.MIN_VALUE) ? 1 : 0);
            if (((productInt = a[start + i] - productInt) ^ Integer.MIN_VALUE) > (a[start + i] ^ Integer.MIN_VALUE)) {
                ++carry;
            }
            a[start + i] = productInt;
            ++i;
        }
        product = ((long)a[start + i] & 0xFFFFFFFFL) - ((long)carry & 0xFFFFFFFFL);
        a[start + i] = (int)product;
        carry = (int)(product >> 32);
        return carry;
    }

    static BigInteger gcdBinary(BigInteger op1, BigInteger op2) {
        BigInteger swap;
        int lsb1 = op1.getLowestSetBit();
        int lsb2 = op2.getLowestSetBit();
        int pow2Count = Math.min(lsb1, lsb2);
        BitLevel.inplaceShiftRight(op1, lsb1);
        BitLevel.inplaceShiftRight(op2, lsb2);
        if (op1.compareTo(op2) == 1) {
            swap = op1;
            op1 = op2;
            op2 = swap;
        }
        do {
            if (op2._size == 1 || op2._size == 2 && op2._words[1] > 0) {
                op2 = BigInteger.valueOf(Division.gcdBinary(op1.longValue(), op2.longValue()));
                break;
            }
            if ((double)op2._size > (double)op1._size * 1.2) {
                if ((op2 = op2.remainder(op1)).signum() != 0) {
                    BitLevel.inplaceShiftRight(op2, op2.getLowestSetBit());
                }
            } else {
                do {
                    Elementary.inplaceSubtract(op2, op1);
                    BitLevel.inplaceShiftRight(op2, op2.getLowestSetBit());
                } while (op2.compareTo(op1) >= 0);
            }
            swap = op2;
            op2 = op1;
            op1 = swap;
        } while (op1._sign != 0);
        return op2.shiftLeft(pow2Count);
    }

    static long gcdBinary(long op1, long op2) {
        int lsb1 = Long.numberOfTrailingZeros(op1);
        int lsb2 = Long.numberOfTrailingZeros(op2);
        int pow2Count = Math.min(lsb1, lsb2);
        if (lsb1 != 0) {
            op1 >>>= lsb1;
        }
        if (lsb2 != 0) {
            op2 >>>= lsb2;
        }
        do {
            if (op1 >= op2) {
                op1 -= op2;
                op1 >>>= Long.numberOfTrailingZeros(op1);
                continue;
            }
            op2 -= op1;
            op2 >>>= Long.numberOfTrailingZeros(op2);
        } while (op1 != 0L);
        return op2 << pow2Count;
    }

    static BigInteger modInverseMontgomery(BigInteger a, BigInteger p) {
        if (a._sign == 0) {
            throw new ArithmeticException("Division.modInverseMontgomery");
        }
        if (!p.testBit(0)) {
            return Division.modInverseLorencz(a, p);
        }
        int m = p._size * 32;
        Object[] save = Division.almostMonInv(a, p);
        BigInteger r = (BigInteger)save[0];
        int k = (Integer)save[1];
        long n1 = Division.calcN(p);
        if (k > m) {
            r = Division.monPro(r, BigInteger.ONE, p, n1);
            k -= m;
        }
        r = Division.monPro(r, BigInteger.ONE.shiftLeft(m - k), p, n1);
        return r;
    }

    private static long calcN(BigInteger a) {
        long m0 = (long)a._words[0] & 0xFFFFFFFFL;
        long n2 = 1L;
        long powerOfTwo = 2L;
        do {
            if ((m0 * n2 & powerOfTwo) == 0L) continue;
            n2 |= powerOfTwo;
        } while ((powerOfTwo <<= 1) < 0x100000000L);
        n2 = -n2;
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    private static Object[] almostMonInv(BigInteger a, BigInteger module) {
        u = module.copy();
        v = a.copy();
        max = Math.max(v._size, u._size);
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < max + 1) {
            throw new ObjectMemoryExceededException("BigInteger", max + 1);
        }
        r = BigInteger.newInstance(1, 1, new int[max + 1]);
        s = BigInteger.newInstance(1, 1, new int[max + 1]);
        s._words[0] = 1;
        k = 0;
        lsbu = u.getLowestSetBit();
        if (lsbu > (lsbv = v.getLowestSetBit())) {
            BitLevel.inplaceShiftRight(u, lsbu);
            BitLevel.inplaceShiftRight(v, lsbv);
            BitLevel.inplaceShiftLeft(r, lsbv);
            k += lsbu - lsbv;
        } else {
            BitLevel.inplaceShiftRight(u, lsbu);
            BitLevel.inplaceShiftRight(v, lsbv);
            BitLevel.inplaceShiftLeft(s, lsbu);
            k += lsbv - lsbu;
        }
        r._sign = 1;
        ** GOTO lbl40
        {
            Elementary.inplaceSubtract(u, v);
            toShift = u.getLowestSetBit();
            BitLevel.inplaceShiftRight(u, toShift);
            Elementary.inplaceAdd(r, s);
            BitLevel.inplaceShiftLeft(s, toShift);
            k += toShift;
            block1: do {
                if (u.compareTo(v) > 0) continue block0;
                while (u.compareTo(v) <= 0) {
                    Elementary.inplaceSubtract(v, u);
                    if (v.signum() == 0) continue block1;
                    toShift = v.getLowestSetBit();
                    BitLevel.inplaceShiftRight(v, toShift);
                    Elementary.inplaceAdd(s, r);
                    BitLevel.inplaceShiftLeft(r, toShift);
                    k += toShift;
                }
lbl40:
                // 3 sources

            } while (v.signum() > 0);
        }
        if (!u.isOne()) {
            throw new ArithmeticException("Division.almostMonInv");
        }
        if (r.compareTo(module) >= 0) {
            Elementary.inplaceSubtract(r, module);
        }
        r = module.minus(r);
        return new Object[]{r, k};
    }

    private static boolean isPowerOfTwo(BigInteger bi, int exp) {
        boolean result = false;
        boolean bl = result = exp >> 5 == bi._size - 1 && bi._words[bi._size - 1] == 1 << (exp & 0x1F);
        if (result) {
            int i = 0;
            while (result && i < bi._size - 1) {
                result = bi._words[i] == 0;
                ++i;
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static int howManyIterations(BigInteger bi, int n) {
        i = n - 1;
        if (bi._sign <= 0) ** GOTO lbl8
        while (!bi.testBit(i)) {
            --i;
        }
        return n - 1 - i;
lbl-1000:
        // 1 sources

        {
            --i;
lbl8:
            // 2 sources

            ** while (bi.testBit((int)i))
        }
lbl9:
        // 1 sources

        return n - 1 - Math.max(i, bi.getLowestSetBit());
    }

    static BigInteger modInverseLorencz(BigInteger a, BigInteger modulo) {
        int max = Math.max(a._size, modulo._size);
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < max + 1) {
            throw new ObjectMemoryExceededException("BigInteger", max + 1);
        }
        int[] uDigits = new int[max + 1];
        int[] vDigits = new int[max + 1];
        System.arraycopy(modulo._words, 0, uDigits, 0, modulo._size);
        System.arraycopy(a._words, 0, vDigits, 0, a._size);
        BigInteger u = BigInteger.newInstance(modulo._sign, modulo._size, uDigits);
        BigInteger v = BigInteger.newInstance(a._sign, a._size, vDigits);
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < max + 1) {
            throw new ObjectMemoryExceededException("BigInteger", max + 1);
        }
        BigInteger r = BigInteger.newInstance(0, 1, new int[max + 1]);
        BigInteger s = BigInteger.newInstance(1, 1, new int[max + 1]);
        s._words[0] = 1;
        int coefU = 0;
        int coefV = 0;
        int n = modulo.bitLength();
        while (!Division.isPowerOfTwo(u, coefU) && !Division.isPowerOfTwo(v, coefV)) {
            int k = Division.howManyIterations(u, n);
            if (k != 0) {
                BitLevel.inplaceShiftLeft(u, k);
                if (coefU >= coefV) {
                    BitLevel.inplaceShiftLeft(r, k);
                } else {
                    BitLevel.inplaceShiftRight(s, Math.min(coefV - coefU, k));
                    if (k - (coefV - coefU) > 0) {
                        BitLevel.inplaceShiftLeft(r, k - coefV + coefU);
                    }
                }
                coefU += k;
            }
            if ((k = Division.howManyIterations(v, n)) != 0) {
                BitLevel.inplaceShiftLeft(v, k);
                if (coefV >= coefU) {
                    BitLevel.inplaceShiftLeft(s, k);
                } else {
                    BitLevel.inplaceShiftRight(r, Math.min(coefU - coefV, k));
                    if (k - (coefU - coefV) > 0) {
                        BitLevel.inplaceShiftLeft(s, k - coefU + coefV);
                    }
                }
                coefV += k;
            }
            if (u.signum() == v.signum()) {
                if (coefU <= coefV) {
                    Elementary.completeInPlaceSubtract(u, v);
                    Elementary.completeInPlaceSubtract(r, s);
                } else {
                    Elementary.completeInPlaceSubtract(v, u);
                    Elementary.completeInPlaceSubtract(s, r);
                }
            } else if (coefU <= coefV) {
                Elementary.completeInPlaceAdd(u, v);
                Elementary.completeInPlaceAdd(r, s);
            } else {
                Elementary.completeInPlaceAdd(v, u);
                Elementary.completeInPlaceAdd(s, r);
            }
            if (v.signum() != 0 && u.signum() != 0) continue;
            throw new ArithmeticException("Division.modInverseLorencz");
        }
        if (Division.isPowerOfTwo(v, coefV)) {
            r = s;
            if (v.signum() != u.signum()) {
                u = u.opposite();
            }
        }
        if (u.testBit(n)) {
            r = r.signum() < 0 ? r.opposite() : modulo.minus(r);
        }
        if (r.signum() < 0) {
            r = r.plus(modulo);
        }
        return r;
    }

    static BigInteger squareAndMultiply(BigInteger x2, BigInteger a2, BigInteger exponent, BigInteger modulus, long n2) {
        BigInteger res = x2;
        int i = exponent.bitLength() - 1;
        while (i >= 0) {
            res = Division.monPro(res, res, modulus, n2);
            if (BitLevel.testBit(exponent, i)) {
                res = Division.monPro(res, a2, modulus, n2);
            }
            --i;
        }
        return res;
    }

    static BigInteger slidingWindow(BigInteger x2, BigInteger a2, BigInteger exponent, BigInteger modulus, long n2) {
        BigInteger[] pows = new BigInteger[8];
        BigInteger res = x2;
        pows[0] = a2;
        BigInteger x3 = Division.monSquare(a2, modulus, n2);
        int i = 1;
        while (i <= 7) {
            pows[i] = Division.monPro(pows[i - 1], x3, modulus, n2);
            ++i;
        }
        i = exponent.bitLength() - 1;
        while (i >= 0) {
            if (BitLevel.testBit(exponent, i)) {
                int lowexp = 1;
                int acc3 = i;
                int j = Math.max(i - 3, 0);
                while (j <= i - 1) {
                    if (BitLevel.testBit(exponent, j)) {
                        if (j < acc3) {
                            acc3 = j;
                            lowexp = lowexp << i - j ^ 1;
                        } else {
                            lowexp ^= 1 << j - acc3;
                        }
                    }
                    ++j;
                }
                j = acc3;
                while (j <= i) {
                    res = Division.monSquare(res, modulus, n2);
                    ++j;
                }
                res = Division.monPro(pows[lowexp - 1 >> 1], res, modulus, n2);
                i = acc3;
            } else {
                res = Division.monSquare(res, modulus, n2);
            }
            --i;
        }
        return res;
    }

    static BigInteger oddModPow(BigInteger base, BigInteger exponent, BigInteger modulus) {
        int k = modulus._size << 5;
        BigInteger a2 = base.shiftLeft(k).mod(modulus);
        BigInteger x2 = BigInteger.ZERO.setBit(k).mod(modulus);
        long m0 = (long)modulus._words[0] & 0xFFFFFFFFL;
        long n2 = 1L;
        long powerOfTwo = 2L;
        do {
            if ((m0 * n2 & powerOfTwo) == 0L) continue;
            n2 |= powerOfTwo;
        } while ((powerOfTwo <<= 1) < 0x100000000L);
        n2 = -n2;
        BigInteger res = modulus._size == 1 ? Division.squareAndMultiply(x2, a2, exponent, modulus, n2) : Division.slidingWindow(x2, a2, exponent, modulus, n2);
        return Division.monPro(res, BigInteger.ONE, modulus, n2);
    }

    static BigInteger evenModPow(BigInteger base, BigInteger exponent, BigInteger modulus) {
        int j = modulus.getLowestSetBit();
        BigInteger q = modulus.shiftRight(j);
        BigInteger x1 = Division.oddModPow(base, exponent, q);
        BigInteger x2 = Division.pow2ModPow(base, exponent, j);
        BigInteger qInv = Division.modPow2Inverse(q, j);
        BigInteger y = x2.minus(x1).times(qInv);
        Division.inplaceModPow2(y, j);
        if (y._sign < 0) {
            y = y.plus(BigInteger.ZERO.setBit(j));
        }
        return x1.plus(q.times(y));
    }

    static BigInteger pow2ModPow(BigInteger base, BigInteger exponent, int j) {
        BigInteger res = BigInteger.ONE;
        BigInteger e = exponent.copy();
        BigInteger baseMod2toN = base.copy();
        if (base.testBit(0)) {
            Division.inplaceModPow2(e, j - 1);
        }
        Division.inplaceModPow2(baseMod2toN, j);
        int i = e.bitLength() - 1;
        while (i >= 0) {
            BigInteger res2 = res.copy();
            Division.inplaceModPow2(res2, j);
            res = res.times(res2);
            if (BitLevel.testBit(e, i)) {
                res = res.times(baseMod2toN);
                Division.inplaceModPow2(res, j);
            }
            --i;
        }
        Division.inplaceModPow2(res, j);
        return res;
    }

    static BigInteger monSquare(BigInteger aBig, BigInteger modulus, long n2) {
        int j;
        long cs;
        if (modulus._size == 1) {
            return Division.monPro(aBig, aBig, modulus, n2);
        }
        int[] a = aBig._words;
        int[] n = modulus._words;
        int s = modulus._size;
        int[] t = new int[(s << 1) + 1];
        int limit = Math.min(s, aBig._size);
        int i = 0;
        while (i < limit) {
            cs = 0L;
            int j2 = i + 1;
            while (j2 < limit) {
                t[i + j2] = (int)(cs += (0xFFFFFFFFL & (long)t[i + j2]) + (0xFFFFFFFFL & (long)a[i]) * (0xFFFFFFFFL & (long)a[j2]));
                cs >>>= 32;
                ++j2;
            }
            t[i + limit] = (int)cs;
            ++i;
        }
        BitLevel.shiftLeft(t, t, 0, 1);
        cs = 0L;
        long carry = 0L;
        int i2 = 0;
        int index = 0;
        while (i2 < s) {
            t[index] = (int)(cs += (0xFFFFFFFFL & (long)a[i2]) * (0xFFFFFFFFL & (long)a[i2]) + ((long)t[index] & 0xFFFFFFFFL));
            cs >>>= 32;
            t[index] = (int)(cs += (long)t[++index] & 0xFFFFFFFFL);
            cs >>>= 32;
            ++i2;
            ++index;
        }
        int m = 0;
        carry = 0L;
        cs = 0L;
        int i3 = 0;
        while (i3 < s) {
            cs = 0L;
            m = (int)(((long)t[i3] & 0xFFFFFFFFL) * (n2 & 0xFFFFFFFFL));
            j = 0;
            while (j < s) {
                cs = ((long)t[i3 + j] & 0xFFFFFFFFL) + ((long)m & 0xFFFFFFFFL) * ((long)n[j] & 0xFFFFFFFFL) + (cs >>> 32);
                t[i3 + j] = (int)cs;
                ++j;
            }
            t[i3 + s] = (int)(carry += ((long)t[i3 + s] & 0xFFFFFFFFL) + (cs >>> 32 & 0xFFFFFFFFL));
            carry >>>= 32;
            ++i3;
        }
        t[s << 1] = (int)carry;
        j = 0;
        while (j < s + 1) {
            t[j] = t[j + s];
            ++j;
        }
        return Division.finalSubtraction(t, s, s, modulus);
    }

    static BigInteger monPro(BigInteger a, BigInteger b, BigInteger modulus, long n2) {
        int aFirst = a._size - 1;
        int bFirst = b._size - 1;
        int s = modulus._size;
        int[] n = modulus._words;
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < (s << 1) + 1) {
            throw new ObjectMemoryExceededException("BigInteger", (s << 1) + 1);
        }
        int[] t = new int[(s << 1) + 1];
        int i = 0;
        while (i < s) {
            long product;
            long C = 0L;
            long aI = i > aFirst ? 0L : (long)a._words[i] & 0xFFFFFFFFL;
            int j = 0;
            while (j < s) {
                product = ((long)t[j] & 0xFFFFFFFFL) + C + (j > bFirst ? 0L : ((long)b._words[j] & 0xFFFFFFFFL) * aI);
                C = product >>> 32;
                t[j] = (int)product;
                ++j;
            }
            product = ((long)t[s] & 0xFFFFFFFFL) + C;
            C = product >>> 32;
            t[s] = (int)product;
            t[s + 1] = (int)C;
            int m = (int)(((long)t[0] & 0xFFFFFFFFL) * n2);
            product = ((long)t[0] & 0xFFFFFFFFL) + ((long)m & 0xFFFFFFFFL) * ((long)n[0] & 0xFFFFFFFFL);
            C = (int)(product >>> 32);
            j = 1;
            while (j < s) {
                product = ((long)t[j] & 0xFFFFFFFFL) + (C & 0xFFFFFFFFL) + ((long)m & 0xFFFFFFFFL) * ((long)n[j] & 0xFFFFFFFFL);
                C = product >>> 32;
                t[j - 1] = (int)product;
                ++j;
            }
            product = ((long)t[s] & 0xFFFFFFFFL) + (C & 0xFFFFFFFFL);
            C = product >>> 32;
            t[s - 1] = (int)product;
            t[s] = t[s + 1] + (int)C;
            ++i;
        }
        return Division.finalSubtraction(t, t.length - 1, s, modulus);
    }

    static BigInteger finalSubtraction(int[] t, int tLength, int s, BigInteger modulus) {
        int[] n = modulus._words;
        boolean lower = false;
        int i = tLength;
        while (i > 0 && t[i] == 0) {
            --i;
        }
        if (i == s - 1) {
            while (i >= 0 && t[i] == n[i]) {
                --i;
            }
            lower = i >= 0 && ((long)t[i] & 0xFFFFFFFFL) < ((long)n[i] & 0xFFFFFFFFL);
        } else {
            lower = i < s - 1;
        }
        BigInteger res = BigInteger.newInstance(1, s + 1, t);
        if (!lower) {
            Elementary.inplaceSubtract(res, modulus);
        }
        res.cutOffLeadingZeroes();
        return res;
    }

    static BigInteger modPow2Inverse(BigInteger x, int n) {
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < 1 << n) {
            throw new ObjectMemoryExceededException("BigInteger", 1 << n);
        }
        BigInteger y = BigInteger.newInstance(1, new int[1 << n]);
        y._size = 1;
        y._words[0] = 1;
        y._sign = 1;
        int i = 1;
        while (i < n) {
            if (BitLevel.testBit(x.times(y), i)) {
                int n2 = i >> 5;
                y._words[n2] = y._words[n2] | 1 << (i & 0x1F);
            }
            ++i;
        }
        return y;
    }

    static void inplaceModPow2(BigInteger x, int n) {
        int fd = n >> 5;
        if (x._size < fd || x.bitLength() <= n) {
            return;
        }
        int leadingZeros = 32 - (n & 0x1F);
        x._size = fd + 1;
        int n2 = fd;
        x._words[n2] = x._words[n2] & (leadingZeros < 32 ? -1 >>> leadingZeros : 0);
        x.cutOffLeadingZeroes();
    }
}

