/*
 * Decompiled with CFR 0.152.
 */
package apache.harmony.math;

import apache.harmony.math.BigInteger;
import org.matheclipse.basic.Config;
import org.matheclipse.basic.ObjectMemoryExceededException;

class Elementary {
    private Elementary() {
    }

    static int compareArrays(int[] a, int[] b, int size) {
        int i = size - 1;
        while (i >= 0 && a[i] == b[i]) {
            --i;
        }
        return i < 0 ? 0 : (((long)a[i] & 0xFFFFFFFFL) < ((long)b[i] & 0xFFFFFFFFL) ? -1 : 1);
    }

    static BigInteger add(BigInteger op1, BigInteger op2) {
        int[] resDigits;
        int resSign;
        int op1Sign = op1._sign;
        int op2Sign = op2._sign;
        if (op1Sign == 0) {
            return op2;
        }
        if (op2Sign == 0) {
            return op1;
        }
        int op1Len = op1._size;
        int op2Len = op2._size;
        if (op1Len + op2Len == 2) {
            long a = (long)op1._words[0] & 0xFFFFFFFFL;
            long b = (long)op2._words[0] & 0xFFFFFFFFL;
            if (op1Sign == op2Sign) {
                long res = a + b;
                int valueLo = (int)res;
                int valueHi = (int)(res >>> 32);
                return valueHi == 0 ? BigInteger.newInstance(op1Sign, valueLo) : BigInteger.newInstance(op1Sign, 2, new int[]{valueLo, valueHi});
            }
            return BigInteger.valueOf(op1Sign < 0 ? b - a : a - b);
        }
        if (op1Sign == op2Sign) {
            resSign = op1Sign;
            resDigits = op1Len >= op2Len ? Elementary.add(op1._words, op1Len, op2._words, op2Len) : Elementary.add(op2._words, op2Len, op1._words, op1Len);
        } else {
            int cmp;
            int n = op1Len != op2Len ? (op1Len > op2Len ? 1 : -1) : (cmp = Elementary.compareArrays(op1._words, op2._words, op1Len));
            if (cmp == 0) {
                return BigInteger.ZERO;
            }
            if (cmp == 1) {
                resSign = op1Sign;
                resDigits = Elementary.subtract(op1._words, op1Len, op2._words, op2Len);
            } else {
                resSign = op2Sign;
                resDigits = Elementary.subtract(op2._words, op2Len, op1._words, op1Len);
            }
        }
        BigInteger res = BigInteger.newInstance(resSign, resDigits.length, resDigits);
        res.cutOffLeadingZeroes();
        return res;
    }

    private static void add(int[] res, int[] a, int aSize, int[] b, int bSize) {
        int i;
        long carry = ((long)a[0] & 0xFFFFFFFFL) + ((long)b[0] & 0xFFFFFFFFL);
        res[0] = (int)carry;
        carry >>= 32;
        if (aSize >= bSize) {
            i = 1;
            while (i < bSize) {
                res[i] = (int)(carry += ((long)a[i] & 0xFFFFFFFFL) + ((long)b[i] & 0xFFFFFFFFL));
                carry >>= 32;
                ++i;
            }
            while (i < aSize) {
                res[i] = (int)(carry += (long)a[i] & 0xFFFFFFFFL);
                carry >>= 32;
                ++i;
            }
        } else {
            i = 1;
            while (i < aSize) {
                res[i] = (int)(carry += ((long)a[i] & 0xFFFFFFFFL) + ((long)b[i] & 0xFFFFFFFFL));
                carry >>= 32;
                ++i;
            }
            while (i < bSize) {
                res[i] = (int)(carry += (long)b[i] & 0xFFFFFFFFL);
                carry >>= 32;
                ++i;
            }
        }
        if (carry != 0L) {
            res[i] = (int)carry;
        }
    }

    static BigInteger subtract(BigInteger op1, BigInteger op2) {
        int[] resDigits;
        int resSign;
        int cmp;
        int op1Sign = op1._sign;
        int op2Sign = op2._sign;
        if (op2Sign == 0) {
            return op1;
        }
        if (op1Sign == 0) {
            return op2.opposite();
        }
        int op1Len = op1._size;
        int op2Len = op2._size;
        if (op1Len + op2Len == 2) {
            long a = (long)op1._words[0] & 0xFFFFFFFFL;
            long b = (long)op2._words[0] & 0xFFFFFFFFL;
            if (op1Sign < 0) {
                a = -a;
            }
            if (op2Sign < 0) {
                b = -b;
            }
            return BigInteger.valueOf(a - b);
        }
        int n = op1Len != op2Len ? (op1Len > op2Len ? 1 : -1) : (cmp = Elementary.compareArrays(op1._words, op2._words, op1Len));
        if (cmp == -1) {
            resSign = -op2Sign;
            resDigits = op1Sign == op2Sign ? Elementary.subtract(op2._words, op2Len, op1._words, op1Len) : Elementary.add(op2._words, op2Len, op1._words, op1Len);
        } else {
            resSign = op1Sign;
            if (op1Sign == op2Sign) {
                if (cmp == 0) {
                    return BigInteger.ZERO;
                }
                resDigits = Elementary.subtract(op1._words, op1Len, op2._words, op2Len);
            } else {
                resDigits = Elementary.add(op1._words, op1Len, op2._words, op2Len);
            }
        }
        BigInteger res = BigInteger.newInstance(resSign, resDigits.length, resDigits);
        res.cutOffLeadingZeroes();
        return res;
    }

    private static void subtract(int[] res, int[] a, int aSize, int[] b, int bSize) {
        long borrow = 0L;
        int i = 0;
        while (i < bSize) {
            res[i] = (int)(borrow += ((long)a[i] & 0xFFFFFFFFL) - ((long)b[i] & 0xFFFFFFFFL));
            borrow >>= 32;
            ++i;
        }
        while (i < aSize) {
            res[i] = (int)(borrow += (long)a[i] & 0xFFFFFFFFL);
            borrow >>= 32;
            ++i;
        }
    }

    private static int[] add(int[] a, int aSize, int[] b, int bSize) {
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < aSize + 1) {
            throw new ObjectMemoryExceededException("BigInteger", aSize + 1);
        }
        int[] res = new int[aSize + 1];
        Elementary.add(res, a, aSize, b, bSize);
        return res;
    }

    static void inplaceAdd(BigInteger op1, BigInteger op2) {
        Elementary.add(op1._words, op1._words, op1._size, op2._words, op2._size);
        op1._size = Math.min(Math.max(op1._size, op2._size) + 1, op1._words.length);
        op1.cutOffLeadingZeroes();
        op1.unCache();
    }

    static int inplaceAdd(int[] a, int aSize, int addend) {
        long carry = (long)addend & 0xFFFFFFFFL;
        int i = 0;
        while (carry != 0L && i < aSize) {
            a[i] = (int)(carry += (long)a[i] & 0xFFFFFFFFL);
            carry >>= 32;
            ++i;
        }
        return (int)carry;
    }

    static void inplaceAdd(BigInteger op1, int addend) {
        int carry = Elementary.inplaceAdd(op1._words, op1._size, addend);
        if (carry == 1) {
            op1._words[op1._size] = 1;
            ++op1._size;
        }
        op1.unCache();
    }

    static void inplaceSubtract(BigInteger op1, BigInteger op2) {
        Elementary.subtract(op1._words, op1._words, op1._size, op2._words, op2._size);
        op1.cutOffLeadingZeroes();
        op1.unCache();
    }

    private static void inverseSubtract(int[] res, int[] a, int aSize, int[] b, int bSize) {
        long borrow = 0L;
        if (aSize < bSize) {
            int i = 0;
            while (i < aSize) {
                res[i] = (int)(borrow += ((long)b[i] & 0xFFFFFFFFL) - ((long)a[i] & 0xFFFFFFFFL));
                borrow >>= 32;
                ++i;
            }
            while (i < bSize) {
                res[i] = (int)(borrow += (long)b[i] & 0xFFFFFFFFL);
                borrow >>= 32;
                ++i;
            }
        } else {
            int i = 0;
            while (i < bSize) {
                res[i] = (int)(borrow += ((long)b[i] & 0xFFFFFFFFL) - ((long)a[i] & 0xFFFFFFFFL));
                borrow >>= 32;
                ++i;
            }
            while (i < aSize) {
                res[i] = (int)(borrow -= (long)a[i] & 0xFFFFFFFFL);
                borrow >>= 32;
                ++i;
            }
        }
    }

    private static int[] subtract(int[] a, int aSize, int[] b, int bSize) {
        int[] res = new int[aSize];
        Elementary.subtract(res, a, aSize, b, bSize);
        return res;
    }

    static void completeInPlaceSubtract(BigInteger op1, BigInteger op2) {
        int resultSign = op1.compareTo(op2);
        if (op1._sign == 0) {
            System.arraycopy(op2._words, 0, op1._words, 0, op2._size);
            op1._sign = -op2._sign;
        } else if (op1._sign != op2._sign) {
            Elementary.add(op1._words, op1._words, op1._size, op2._words, op2._size);
            op1._sign = resultSign;
        } else {
            int sign = Elementary.unsignedArraysCompare(op1._words, op2._words, op1._size, op2._size);
            if (sign > 0) {
                Elementary.subtract(op1._words, op1._words, op1._size, op2._words, op2._size);
            } else {
                Elementary.inverseSubtract(op1._words, op1._words, op1._size, op2._words, op2._size);
                op1._sign = -op1._sign;
            }
        }
        op1._size = Math.max(op1._size, op2._size) + 1;
        op1.cutOffLeadingZeroes();
        op1.unCache();
    }

    static void completeInPlaceAdd(BigInteger op1, BigInteger op2) {
        if (op1._sign == 0) {
            System.arraycopy(op2._words, 0, op1._words, 0, op2._size);
        } else {
            if (op2._sign == 0) {
                return;
            }
            if (op1._sign == op2._sign) {
                Elementary.add(op1._words, op1._words, op1._size, op2._words, op2._size);
            } else {
                int sign = Elementary.unsignedArraysCompare(op1._words, op2._words, op1._size, op2._size);
                if (sign > 0) {
                    Elementary.subtract(op1._words, op1._words, op1._size, op2._words, op2._size);
                } else {
                    Elementary.inverseSubtract(op1._words, op1._words, op1._size, op2._words, op2._size);
                    op1._sign = -op1._sign;
                }
            }
        }
        op1._size = Math.max(op1._size, op2._size) + 1;
        op1.cutOffLeadingZeroes();
        op1.unCache();
    }

    private static int unsignedArraysCompare(int[] a, int[] b, int aSize, int bSize) {
        if (aSize > bSize) {
            return 1;
        }
        if (aSize < bSize) {
            return -1;
        }
        int i = aSize - 1;
        while (i >= 0 && a[i] == b[i]) {
            --i;
        }
        return i < 0 ? 0 : (((long)a[i] & 0xFFFFFFFFL) < ((long)b[i] & 0xFFFFFFFFL) ? -1 : 1);
    }
}

