/*
 * Decompiled with CFR 0.152.
 */
package apache.harmony.math;

import apache.harmony.math.BigInteger;

class Logical {
    private Logical() {
    }

    static BigInteger not(BigInteger val) {
        int i;
        if (val._sign == 0) {
            return BigInteger.MINUS_ONE;
        }
        if (val.equals(BigInteger.MINUS_ONE)) {
            return BigInteger.ZERO;
        }
        int[] resDigits = new int[val._size + 1];
        if (val._sign > 0) {
            if (val._words[val._size - 1] != -1) {
                i = 0;
                while (val._words[i] == -1) {
                    ++i;
                }
            } else {
                i = 0;
                while (i < val._size && val._words[i] == -1) {
                    ++i;
                }
                if (i == val._size) {
                    resDigits[i] = 1;
                    return BigInteger.newInstance(-val._sign, i + 1, resDigits);
                }
            }
        } else {
            i = 0;
            while (val._words[i] == 0) {
                resDigits[i] = -1;
                ++i;
            }
        }
        resDigits[i] = val._words[i] + val._sign;
        ++i;
        while (i < val._size) {
            resDigits[i] = val._words[i];
            ++i;
        }
        return BigInteger.newInstance(-val._sign, i, resDigits);
    }

    static BigInteger and(BigInteger val, BigInteger that) {
        if (that._sign == 0 || val._sign == 0) {
            return BigInteger.ZERO;
        }
        if (that.equals(BigInteger.MINUS_ONE)) {
            return val;
        }
        if (val.equals(BigInteger.MINUS_ONE)) {
            return that;
        }
        if (val._sign > 0) {
            if (that._sign > 0) {
                return Logical.andPositive(val, that);
            }
            return Logical.andDiffSigns(val, that);
        }
        if (that._sign > 0) {
            return Logical.andDiffSigns(that, val);
        }
        if (val._size > that._size) {
            return Logical.andNegative(val, that);
        }
        return Logical.andNegative(that, val);
    }

    static BigInteger andPositive(BigInteger val, BigInteger that) {
        int resLength = Math.min(val._size, that._size);
        int i = Math.max(val.getFirstNonzeroDigit(), that.getFirstNonzeroDigit());
        if (i >= resLength) {
            return BigInteger.ZERO;
        }
        int[] resDigits = new int[resLength];
        while (i < resLength) {
            resDigits[i] = val._words[i] & that._words[i];
            ++i;
        }
        BigInteger result = BigInteger.newInstance(1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger andDiffSigns(BigInteger positive, BigInteger negative) {
        int iPos = positive.getFirstNonzeroDigit();
        int iNeg = negative.getFirstNonzeroDigit();
        if (iNeg >= positive._size) {
            return BigInteger.ZERO;
        }
        int resLength = positive._size;
        int[] resDigits = new int[resLength];
        int i = Math.max(iPos, iNeg);
        if (i == iNeg) {
            resDigits[i] = -negative._words[i] & positive._words[i];
            ++i;
        }
        int limit = Math.min(negative._size, positive._size);
        while (i < limit) {
            resDigits[i] = ~negative._words[i] & positive._words[i];
            ++i;
        }
        if (i >= negative._size) {
            while (i < positive._size) {
                resDigits[i] = positive._words[i];
                ++i;
            }
        }
        BigInteger result = BigInteger.newInstance(1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger andNegative(BigInteger longer, BigInteger shorter) {
        int iLonger = longer.getFirstNonzeroDigit();
        int iShorter = shorter.getFirstNonzeroDigit();
        if (iLonger >= shorter._size) {
            return longer;
        }
        int i = Math.max(iShorter, iLonger);
        int digit = iShorter > iLonger ? -shorter._words[i] & ~longer._words[i] : (iShorter < iLonger ? ~shorter._words[i] & -longer._words[i] : -shorter._words[i] & -longer._words[i]);
        if (digit == 0) {
            ++i;
            while (i < shorter._size && (digit = ~(longer._words[i] | shorter._words[i])) == 0) {
                ++i;
            }
            if (digit == 0) {
                while (i < longer._size && (digit = ~longer._words[i]) == 0) {
                    ++i;
                }
                if (digit == 0) {
                    int resLength = longer._size + 1;
                    int[] resDigits = new int[resLength];
                    resDigits[resLength - 1] = 1;
                    BigInteger result = BigInteger.newInstance(-1, resLength, resDigits);
                    return result;
                }
            }
        }
        int resLength = longer._size;
        int[] resDigits = new int[resLength];
        resDigits[i] = -digit;
        ++i;
        while (i < shorter._size) {
            resDigits[i] = longer._words[i] | shorter._words[i];
            ++i;
        }
        while (i < longer._size) {
            resDigits[i] = longer._words[i];
            ++i;
        }
        BigInteger result = BigInteger.newInstance(-1, resLength, resDigits);
        return result;
    }

    static BigInteger andNot(BigInteger val, BigInteger that) {
        if (val._sign == 0) {
            return BigInteger.ZERO;
        }
        if (that._sign == 0) {
            return val;
        }
        if (val.equals(BigInteger.MINUS_ONE)) {
            return that.not();
        }
        if (that.equals(BigInteger.MINUS_ONE)) {
            return BigInteger.ZERO;
        }
        if (val._sign > 0) {
            if (that._sign > 0) {
                return Logical.andNotPositive(val, that);
            }
            return Logical.andNotPositiveNegative(val, that);
        }
        if (that._sign > 0) {
            return Logical.andNotNegativePositive(val, that);
        }
        return Logical.andNotNegative(val, that);
    }

    static BigInteger andNotPositive(BigInteger val, BigInteger that) {
        int[] resDigits = new int[val._size];
        int limit = Math.min(val._size, that._size);
        int i = val.getFirstNonzeroDigit();
        while (i < limit) {
            resDigits[i] = val._words[i] & ~that._words[i];
            ++i;
        }
        while (i < val._size) {
            resDigits[i] = val._words[i];
            ++i;
        }
        BigInteger result = BigInteger.newInstance(1, val._size, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger andNotPositiveNegative(BigInteger positive, BigInteger negative) {
        int iNeg = negative.getFirstNonzeroDigit();
        int iPos = positive.getFirstNonzeroDigit();
        if (iNeg >= positive._size) {
            return positive;
        }
        int resLength = Math.min(positive._size, negative._size);
        int[] resDigits = new int[resLength];
        int i = iPos;
        while (i < iNeg) {
            resDigits[i] = positive._words[i];
            ++i;
        }
        if (i == iNeg) {
            resDigits[i] = positive._words[i] & negative._words[i] - 1;
            ++i;
        }
        while (i < resLength) {
            resDigits[i] = positive._words[i] & negative._words[i];
            ++i;
        }
        BigInteger result = BigInteger.newInstance(1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger andNotNegativePositive(BigInteger negative, BigInteger positive) {
        int limit;
        int[] resDigits;
        int iNeg = negative.getFirstNonzeroDigit();
        int iPos = positive.getFirstNonzeroDigit();
        if (iNeg >= positive._size) {
            return negative;
        }
        int resLength = Math.max(negative._size, positive._size);
        int i = iNeg;
        if (iPos > iNeg) {
            resDigits = new int[resLength];
            limit = Math.min(negative._size, iPos);
            while (i < limit) {
                resDigits[i] = negative._words[i];
                ++i;
            }
            if (i == negative._size) {
                i = iPos;
                while (i < positive._size) {
                    resDigits[i] = positive._words[i];
                    ++i;
                }
            }
        } else {
            int digit = -negative._words[i] & ~positive._words[i];
            if (digit == 0) {
                limit = Math.min(positive._size, negative._size);
                ++i;
                while (i < limit && (digit = ~(negative._words[i] | positive._words[i])) == 0) {
                    ++i;
                }
                if (digit == 0) {
                    while (i < positive._size && (digit = ~positive._words[i]) == 0) {
                        ++i;
                    }
                    while (i < negative._size && (digit = ~negative._words[i]) == 0) {
                        ++i;
                    }
                    if (digit == 0) {
                        int[] resDigits2 = new int[++resLength];
                        resDigits2[resLength - 1] = 1;
                        BigInteger result = BigInteger.newInstance(-1, resLength, resDigits2);
                        return result;
                    }
                }
            }
            resDigits = new int[resLength];
            resDigits[i] = -digit;
            ++i;
        }
        limit = Math.min(positive._size, negative._size);
        while (i < limit) {
            resDigits[i] = negative._words[i] | positive._words[i];
            ++i;
        }
        while (i < negative._size) {
            resDigits[i] = negative._words[i];
            ++i;
        }
        while (i < positive._size) {
            resDigits[i] = positive._words[i];
            ++i;
        }
        BigInteger result = BigInteger.newInstance(-1, resLength, resDigits);
        return result;
    }

    static BigInteger andNotNegative(BigInteger val, BigInteger that) {
        int limit;
        int iVal = val.getFirstNonzeroDigit();
        int iThat = that.getFirstNonzeroDigit();
        if (iVal >= that._size) {
            return BigInteger.ZERO;
        }
        int resLength = that._size;
        int[] resDigits = new int[resLength];
        int i = iVal;
        if (iVal < iThat) {
            resDigits[i] = -val._words[i];
            limit = Math.min(val._size, iThat);
            ++i;
            while (i < limit) {
                resDigits[i] = ~val._words[i];
                ++i;
            }
            if (i == val._size) {
                while (i < iThat) {
                    resDigits[i] = -1;
                    ++i;
                }
                resDigits[i] = that._words[i] - 1;
            } else {
                resDigits[i] = ~val._words[i] & that._words[i] - 1;
            }
        } else {
            resDigits[i] = iThat < iVal ? -val._words[i] & that._words[i] : -val._words[i] & that._words[i] - 1;
        }
        limit = Math.min(val._size, that._size);
        ++i;
        while (i < limit) {
            resDigits[i] = ~val._words[i] & that._words[i];
            ++i;
        }
        while (i < that._size) {
            resDigits[i] = that._words[i];
            ++i;
        }
        BigInteger result = BigInteger.newInstance(1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger or(BigInteger val, BigInteger that) {
        if (that.equals(BigInteger.MINUS_ONE) || val.equals(BigInteger.MINUS_ONE)) {
            return BigInteger.MINUS_ONE;
        }
        if (that._sign == 0) {
            return val;
        }
        if (val._sign == 0) {
            return that;
        }
        if (val._sign > 0) {
            if (that._sign > 0) {
                if (val._size > that._size) {
                    return Logical.orPositive(val, that);
                }
                return Logical.orPositive(that, val);
            }
            return Logical.orDiffSigns(val, that);
        }
        if (that._sign > 0) {
            return Logical.orDiffSigns(that, val);
        }
        if (that.getFirstNonzeroDigit() > val.getFirstNonzeroDigit()) {
            return Logical.orNegative(that, val);
        }
        return Logical.orNegative(val, that);
    }

    static BigInteger orPositive(BigInteger longer, BigInteger shorter) {
        int resLength = longer._size;
        int[] resDigits = new int[resLength];
        int i = Math.min(longer.getFirstNonzeroDigit(), shorter.getFirstNonzeroDigit());
        i = 0;
        while (i < shorter._size) {
            resDigits[i] = longer._words[i] | shorter._words[i];
            ++i;
        }
        while (i < resLength) {
            resDigits[i] = longer._words[i];
            ++i;
        }
        BigInteger result = BigInteger.newInstance(1, resLength, resDigits);
        return result;
    }

    static BigInteger orNegative(BigInteger val, BigInteger that) {
        int i;
        int iThat = that.getFirstNonzeroDigit();
        int iVal = val.getFirstNonzeroDigit();
        if (iVal >= that._size) {
            return that;
        }
        if (iThat >= val._size) {
            return val;
        }
        int resLength = Math.min(val._size, that._size);
        int[] resDigits = new int[resLength];
        if (iThat == iVal) {
            resDigits[iVal] = -(-val._words[iVal] | -that._words[iVal]);
            i = iVal;
        } else {
            i = iThat;
            while (i < iVal) {
                resDigits[i] = that._words[i];
                ++i;
            }
            resDigits[i] = that._words[i] & val._words[i] - 1;
        }
        ++i;
        while (i < resLength) {
            resDigits[i] = val._words[i] & that._words[i];
            ++i;
        }
        BigInteger result = BigInteger.newInstance(-1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    /*
     * Unable to fully structure code
     */
    static BigInteger orDiffSigns(BigInteger positive, BigInteger negative) {
        block7: {
            block8: {
                block9: {
                    block6: {
                        iNeg = negative.getFirstNonzeroDigit();
                        iPos = positive.getFirstNonzeroDigit();
                        if (iPos >= negative._size) {
                            return negative;
                        }
                        resLength = negative._size;
                        resDigits = new int[resLength];
                        if (iNeg >= iPos) break block6;
                        i = iNeg;
                        while (i < iPos) {
                            resDigits[i] = negative._words[i];
                            ++i;
                        }
                        break block7;
                    }
                    if (iPos >= iNeg) break block8;
                    i = iPos;
                    resDigits[i] = -positive._words[i];
                    limit = Math.min(positive._size, iNeg);
                    ++i;
                    while (i < limit) {
                        resDigits[i] = ~positive._words[i];
                        ++i;
                    }
                    if (i == positive._size) ** GOTO lbl29
                    resDigits[i] = ~(-negative._words[i] | positive._words[i]);
                    break block9;
lbl-1000:
                    // 1 sources

                    {
                        resDigits[i] = -1;
                        ++i;
lbl29:
                        // 2 sources

                        ** while (i < iNeg)
                    }
lbl30:
                    // 1 sources

                    resDigits[i] = negative._words[i] - 1;
                }
                ++i;
                break block7;
            }
            i = iPos;
            resDigits[i] = -(-negative._words[i] | positive._words[i]);
            ++i;
        }
        limit = Math.min(negative._size, positive._size);
        while (i < limit) {
            resDigits[i] = negative._words[i] & ~positive._words[i];
            ++i;
        }
        while (i < negative._size) {
            resDigits[i] = negative._words[i];
            ++i;
        }
        result = BigInteger.newInstance(-1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger xor(BigInteger val, BigInteger that) {
        if (that._sign == 0) {
            return val;
        }
        if (val._sign == 0) {
            return that;
        }
        if (that.equals(BigInteger.MINUS_ONE)) {
            return val.not();
        }
        if (val.equals(BigInteger.MINUS_ONE)) {
            return that.not();
        }
        if (val._sign > 0) {
            if (that._sign > 0) {
                if (val._size > that._size) {
                    return Logical.xorPositive(val, that);
                }
                return Logical.xorPositive(that, val);
            }
            return Logical.xorDiffSigns(val, that);
        }
        if (that._sign > 0) {
            return Logical.xorDiffSigns(that, val);
        }
        if (that.getFirstNonzeroDigit() > val.getFirstNonzeroDigit()) {
            return Logical.xorNegative(that, val);
        }
        return Logical.xorNegative(val, that);
    }

    static BigInteger xorPositive(BigInteger longer, BigInteger shorter) {
        int resLength = longer._size;
        int[] resDigits = new int[resLength];
        int i = Math.min(longer.getFirstNonzeroDigit(), shorter.getFirstNonzeroDigit());
        while (i < shorter._size) {
            resDigits[i] = longer._words[i] ^ shorter._words[i];
            ++i;
        }
        while (i < longer._size) {
            resDigits[i] = longer._words[i];
            ++i;
        }
        BigInteger result = BigInteger.newInstance(1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger xorNegative(BigInteger val, BigInteger that) {
        int limit;
        int iThat;
        int resLength = Math.max(val._size, that._size);
        int[] resDigits = new int[resLength];
        int iVal = val.getFirstNonzeroDigit();
        int i = iThat = that.getFirstNonzeroDigit();
        if (iVal == iThat) {
            resDigits[i] = -val._words[i] ^ -that._words[i];
        } else {
            resDigits[i] = -that._words[i];
            limit = Math.min(that._size, iVal);
            ++i;
            while (i < limit) {
                resDigits[i] = ~that._words[i];
                ++i;
            }
            if (i == that._size) {
                while (i < iVal) {
                    resDigits[i] = -1;
                    ++i;
                }
                resDigits[i] = val._words[i] - 1;
            } else {
                resDigits[i] = -val._words[i] ^ ~that._words[i];
            }
        }
        limit = Math.min(val._size, that._size);
        ++i;
        while (i < limit) {
            resDigits[i] = val._words[i] ^ that._words[i];
            ++i;
        }
        while (i < val._size) {
            resDigits[i] = val._words[i];
            ++i;
        }
        while (i < that._size) {
            resDigits[i] = that._words[i];
            ++i;
        }
        BigInteger result = BigInteger.newInstance(1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    /*
     * Unable to fully structure code
     */
    static BigInteger xorDiffSigns(BigInteger positive, BigInteger negative) {
        block16: {
            block17: {
                block15: {
                    resLength = Math.max(negative._size, positive._size);
                    iNeg = negative.getFirstNonzeroDigit();
                    if (iNeg >= (iPos = positive.getFirstNonzeroDigit())) break block15;
                    resDigits = new int[resLength];
                    i = iNeg;
                    resDigits[i] = negative._words[i];
                    limit = Math.min(negative._size, iPos);
                    ++i;
                    while (i < limit) {
                        resDigits[i] = negative._words[i];
                        ++i;
                    }
                    if (i == negative._size) {
                        while (i < positive._size) {
                            resDigits[i] = positive._words[i];
                            ++i;
                        }
                    }
                    break block16;
                }
                if (iPos >= iNeg) break block17;
                resDigits = new int[resLength];
                i = iPos;
                resDigits[i] = -positive._words[i];
                limit = Math.min(positive._size, iNeg);
                ++i;
                while (i < limit) {
                    resDigits[i] = ~positive._words[i];
                    ++i;
                }
                if (i != iNeg) ** GOTO lbl36
                resDigits[i] = ~(positive._words[i] ^ -negative._words[i]);
                ++i;
                break block16;
lbl-1000:
                // 1 sources

                {
                    resDigits[i] = -1;
                    ++i;
lbl36:
                    // 2 sources

                    ** while (i < iNeg)
                }
lbl37:
                // 2 sources

                while (i < negative._size) {
                    resDigits[i] = negative._words[i];
                    ++i;
                }
                break block16;
            }
            i = iNeg;
            digit = positive._words[i] ^ -negative._words[i];
            if (digit == 0) {
                limit = Math.min(positive._size, negative._size);
                ++i;
                while (i < limit && (digit = positive._words[i] ^ ~negative._words[i]) == 0) {
                    ++i;
                }
                if (digit == 0) {
                    while (i < positive._size && (digit = ~positive._words[i]) == 0) {
                        ++i;
                    }
                    while (i < negative._size && (digit = ~negative._words[i]) == 0) {
                        ++i;
                    }
                    if (digit == 0) {
                        resDigits = new int[++resLength];
                        resDigits[resLength - 1] = 1;
                        result = BigInteger.newInstance(-1, resLength, resDigits);
                        return result;
                    }
                }
            }
            resDigits = new int[resLength];
            resDigits[i] = -digit;
            ++i;
        }
        limit = Math.min(negative._size, positive._size);
        while (i < limit) {
            resDigits[i] = ~(~negative._words[i] ^ positive._words[i]);
            ++i;
        }
        while (i < positive._size) {
            resDigits[i] = positive._words[i];
            ++i;
        }
        while (i < negative._size) {
            resDigits[i] = negative._words[i];
            ++i;
        }
        result = BigInteger.newInstance(-1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }
}

