/*
 * Decompiled with CFR 0.152.
 */
package apache.harmony.math;

import apache.harmony.math.BigInteger;
import apache.harmony.math.BitLevel;
import org.matheclipse.basic.Config;
import org.matheclipse.basic.ObjectMemoryExceededException;

class Multiplication {
    static final int whenUseKaratsuba = 63;
    static final int[] tenPows = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    static final int[] fivePows = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
    static final BigInteger[] bigTenPows = new BigInteger[32];
    static final BigInteger[] bigFivePows = new BigInteger[32];

    static {
        long fivePow = 1L;
        int i = 0;
        while (i <= 18) {
            Multiplication.bigFivePows[i] = BigInteger.valueOfStatic(fivePow);
            Multiplication.bigTenPows[i] = BigInteger.valueOfStatic(fivePow << i);
            fivePow *= 5L;
            ++i;
        }
        while (i < bigTenPows.length) {
            Multiplication.bigFivePows[i] = bigFivePows[i - 1].times(bigFivePows[1]);
            Multiplication.bigTenPows[i] = bigTenPows[i - 1].times(BigInteger.TEN);
            ++i;
        }
    }

    private Multiplication() {
    }

    static BigInteger multiply(BigInteger x, BigInteger y) {
        return Multiplication.karatsuba(x, y);
    }

    static BigInteger karatsuba(BigInteger op1, BigInteger op2) {
        if (op2._size > op1._size) {
            BigInteger temp = op1;
            op1 = op2;
            op2 = temp;
        }
        if (op2._size < 63) {
            return Multiplication.multiplyPAP(op1, op2);
        }
        int ndiv2 = (op1._size & 0xFFFFFFFE) << 4;
        BigInteger upperOp1 = op1.shiftRight(ndiv2);
        BigInteger upperOp2 = op2.shiftRight(ndiv2);
        BigInteger lowerOp1 = op1.minus(upperOp1.shiftLeft(ndiv2));
        BigInteger lowerOp2 = op2.minus(upperOp2.shiftLeft(ndiv2));
        BigInteger upper = Multiplication.karatsuba(upperOp1, upperOp2);
        BigInteger lower = Multiplication.karatsuba(lowerOp1, lowerOp2);
        BigInteger middle = Multiplication.karatsuba(upperOp1.minus(lowerOp1), lowerOp2.minus(upperOp2));
        middle = middle.plus(upper).plus(lower);
        middle = middle.shiftLeft(ndiv2);
        upper = upper.shiftLeft(ndiv2 << 1);
        return upper.plus(middle).plus(lower);
    }

    static BigInteger multiplyPAP(BigInteger a, BigInteger b) {
        int resSign;
        int aLen = a._size;
        int bLen = b._size;
        int resLength = aLen + bLen;
        int n = resSign = a._sign != b._sign ? -1 : 1;
        if (resLength == 2) {
            long val = ((long)a._words[0] & 0xFFFFFFFFL) * ((long)b._words[0] & 0xFFFFFFFFL);
            int valueLo = (int)val;
            int valueHi = (int)(val >>> 32);
            return valueHi == 0 ? BigInteger.newInstance(resSign, valueLo) : BigInteger.newInstance(resSign, 2, new int[]{valueLo, valueHi});
        }
        int[] aDigits = a._words;
        int[] bDigits = b._words;
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < resLength) {
            throw new ObjectMemoryExceededException("BigInteger", resLength);
        }
        int[] resDigits = new int[resLength];
        int j = 0;
        while (j < bLen) {
            long carry = 0L;
            long bDigit = (long)bDigits[j] & 0xFFFFFFFFL;
            int i = 0;
            int m = j;
            while (i < aLen) {
                resDigits[m] = (int)(carry += ((long)aDigits[i] & 0xFFFFFFFFL) * bDigit + ((long)resDigits[m] & 0xFFFFFFFFL));
                carry >>>= 32;
                ++i;
                ++m;
            }
            resDigits[m] = (int)carry;
            ++j;
        }
        BigInteger result = BigInteger.newInstance(resSign, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    private static int multiplyByInt(int[] res, int[] a, int aSize, int factor) {
        long carry = 0L;
        int i = 0;
        while (i < aSize) {
            res[i] = (int)(carry += ((long)a[i] & 0xFFFFFFFFL) * ((long)factor & 0xFFFFFFFFL));
            carry >>>= 32;
            ++i;
        }
        return (int)carry;
    }

    static int multiplyByInt(int[] a, int aSize, int factor) {
        return Multiplication.multiplyByInt(a, a, aSize, factor);
    }

    static BigInteger multiplyByPositiveInt(BigInteger val, int factor) {
        int resSign = val._sign;
        if (resSign == 0) {
            return BigInteger.ZERO;
        }
        int aNumberLength = val._size;
        int[] aDigits = val._words;
        if (aNumberLength == 1) {
            long res = ((long)aDigits[0] & 0xFFFFFFFFL) * (long)factor;
            int resLo = (int)res;
            int resHi = (int)(res >>> 32);
            return resHi == 0 ? BigInteger.newInstance(resSign, resLo) : BigInteger.newInstance(resSign, 2, new int[]{resLo, resHi});
        }
        int resLength = aNumberLength + 1;
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < resLength) {
            throw new ObjectMemoryExceededException("BigInteger", resLength);
        }
        int[] resDigits = new int[resLength];
        resDigits[aNumberLength] = Multiplication.multiplyByInt(resDigits, aDigits, aNumberLength, factor);
        BigInteger result = BigInteger.newInstance(resSign, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger pow(BigInteger base, int exponent) {
        BigInteger res = BigInteger.ONE;
        BigInteger acc = base;
        while (exponent > 1) {
            if ((exponent & 1) != 0) {
                res = res.times(acc);
            }
            acc = acc._size == 1 ? acc.times(acc) : BigInteger.newInstance(1, Multiplication.square(acc._words, acc._size));
            exponent >>= 1;
        }
        res = res.times(acc);
        return res;
    }

    static int[] square(int[] a, int s) {
        long aI;
        long cs;
        int[] t = new int[s << 1];
        int i = 0;
        while (i < s) {
            cs = 0L;
            aI = 0xFFFFFFFFL & (long)a[i];
            int j = i + 1;
            while (j < s) {
                t[i + j] = (int)(cs += (0xFFFFFFFFL & (long)t[i + j]) + aI * (0xFFFFFFFFL & (long)a[j]));
                cs >>>= 32;
                ++j;
            }
            t[i + s] = (int)cs;
            ++i;
        }
        BitLevel.shiftLeft(t, t, 0, 1);
        cs = 0L;
        i = 0;
        int index = 0;
        while (i < s) {
            aI = 0xFFFFFFFFL & (long)a[i];
            t[index] = (int)(cs += aI * aI + ((long)t[index] & 0xFFFFFFFFL));
            cs >>>= 32;
            t[index] = (int)(cs += (long)t[++index] & 0xFFFFFFFFL);
            cs >>>= 32;
            ++i;
            ++index;
        }
        return t;
    }

    static BigInteger multiplyByTenPow(BigInteger val, long exp) {
        return exp < (long)tenPows.length ? Multiplication.multiplyByPositiveInt(val, tenPows[(int)exp]) : val.times(Multiplication.powerOf10(exp));
    }

    static BigInteger powerOf10(long exp) {
        BigInteger powerOfFive;
        int intExp = (int)exp;
        if (exp < (long)bigTenPows.length) {
            return bigTenPows[intExp];
        }
        if (exp <= 50L) {
            return BigInteger.TEN.pow(intExp);
        }
        if (exp <= 1000L) {
            return bigFivePows[1].pow(intExp).shiftLeft(intExp);
        }
        long byteArraySize = 1L + (long)((double)exp / 2.4082399653118496);
        if (byteArraySize > Runtime.getRuntime().freeMemory()) {
            throw new OutOfMemoryError("Multiplication.powerOf10");
        }
        if (exp <= Integer.MAX_VALUE) {
            return bigFivePows[1].pow(intExp).shiftLeft(intExp);
        }
        BigInteger res = powerOfFive = bigFivePows[1].pow(Integer.MAX_VALUE);
        long longExp = exp - Integer.MAX_VALUE;
        intExp = (int)(exp % Integer.MAX_VALUE);
        while (longExp > Integer.MAX_VALUE) {
            res = res.times(powerOfFive);
            longExp -= Integer.MAX_VALUE;
        }
        res = res.times(bigFivePows[1].pow(intExp));
        res = res.shiftLeft(Integer.MAX_VALUE);
        longExp = exp - Integer.MAX_VALUE;
        while (longExp > Integer.MAX_VALUE) {
            res = res.shiftLeft(Integer.MAX_VALUE);
            longExp -= Integer.MAX_VALUE;
        }
        res = res.shiftLeft(intExp);
        return res;
    }

    static BigInteger multiplyByFivePow(BigInteger val, int exp) {
        if (exp < fivePows.length) {
            return Multiplication.multiplyByPositiveInt(val, fivePows[exp]);
        }
        if (exp < bigFivePows.length) {
            return val.times(bigFivePows[exp]);
        }
        return val.times(bigFivePows[1].pow(exp));
    }
}

