/*
 * Decompiled with CFR 0.152.
 */
package apache.harmony.math;

import apache.harmony.math.BigInteger;
import apache.harmony.math.Division;
import apache.harmony.math.Elementary;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import org.matheclipse.basic.Config;
import org.matheclipse.basic.ObjectMemoryExceededException;

public class Primality {
    private static final int[] primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997, 1009, 1013, 1019, 1021};
    private static final BigInteger[] BIprimes = new BigInteger[primes.length];
    private static final int[] BITS;
    private static final int[][] offsetPrimes;

    static {
        int[] nArray = new int[53];
        nArray[2] = 1854;
        nArray[3] = 1233;
        nArray[4] = 927;
        nArray[5] = 747;
        nArray[6] = 627;
        nArray[7] = 543;
        nArray[8] = 480;
        nArray[9] = 431;
        nArray[10] = 393;
        nArray[11] = 361;
        nArray[12] = 335;
        nArray[13] = 314;
        nArray[14] = 295;
        nArray[15] = 279;
        nArray[16] = 265;
        nArray[17] = 253;
        nArray[18] = 242;
        nArray[19] = 232;
        nArray[20] = 223;
        nArray[21] = 216;
        nArray[22] = 181;
        nArray[23] = 169;
        nArray[24] = 158;
        nArray[25] = 150;
        nArray[26] = 145;
        nArray[27] = 140;
        nArray[28] = 136;
        nArray[29] = 132;
        nArray[30] = 127;
        nArray[31] = 123;
        nArray[32] = 119;
        nArray[33] = 114;
        nArray[34] = 110;
        nArray[35] = 105;
        nArray[36] = 101;
        nArray[37] = 96;
        nArray[38] = 92;
        nArray[39] = 87;
        nArray[40] = 83;
        nArray[41] = 78;
        nArray[42] = 73;
        nArray[43] = 69;
        nArray[44] = 64;
        nArray[45] = 59;
        nArray[46] = 54;
        nArray[47] = 49;
        nArray[48] = 44;
        nArray[49] = 38;
        nArray[50] = 32;
        nArray[51] = 26;
        nArray[52] = 1;
        BITS = nArray;
        int[][] nArrayArray = new int[11][];
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        nArrayArray[2] = nArray2;
        nArrayArray[3] = new int[]{2, 2};
        nArrayArray[4] = new int[]{4, 2};
        nArrayArray[5] = new int[]{6, 5};
        nArrayArray[6] = new int[]{11, 7};
        nArrayArray[7] = new int[]{18, 13};
        nArrayArray[8] = new int[]{31, 23};
        nArrayArray[9] = new int[]{54, 43};
        nArrayArray[10] = new int[]{97, 75};
        offsetPrimes = nArrayArray;
        int i = 0;
        while (i < primes.length) {
            Primality.BIprimes[i] = BigInteger.valueOfStatic(primes[i]);
            ++i;
        }
    }

    private Primality() {
    }

    static BigInteger nextProbablePrime(BigInteger n) {
        int gapSize = 1024;
        int[] modules = new int[primes.length];
        boolean[] isDivisible = new boolean[gapSize];
        if (n._size == 1 && n._words[0] >= 0 && n._words[0] < primes[primes.length - 1]) {
            int i = 0;
            while (n._words[0] >= primes[i]) {
                ++i;
            }
            return BIprimes[i];
        }
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < n._size + 1) {
            throw new ObjectMemoryExceededException("BigInteger", n._size + 1);
        }
        BigInteger startPoint = BigInteger.newInstance(1, n._size, new int[n._size + 1]);
        System.arraycopy(n._words, 0, startPoint._words, 0, n._size);
        if (n.testBit(0)) {
            Elementary.inplaceAdd(startPoint, 2);
        } else {
            startPoint._words[0] = startPoint._words[0] | 1;
        }
        int j = startPoint.bitLength();
        int certainty = 2;
        while (j < BITS[certainty]) {
            ++certainty;
        }
        int i = 0;
        while (i < primes.length) {
            modules[i] = Division.remainder(startPoint, primes[i]) - gapSize;
            ++i;
        }
        while (true) {
            Arrays.fill(isDivisible, false);
            i = 0;
            while (i < primes.length) {
                modules[i] = (modules[i] + gapSize) % primes[i];
                j = modules[i] == 0 ? 0 : primes[i] - modules[i];
                while (j < gapSize) {
                    isDivisible[j] = true;
                    j += primes[i];
                }
                ++i;
            }
            j = 0;
            while (j < gapSize) {
                if (!isDivisible[j]) {
                    BigInteger probPrime = startPoint.copy();
                    Elementary.inplaceAdd(probPrime, j);
                    if (Primality.millerRabin(probPrime, certainty)) {
                        return probPrime;
                    }
                }
                ++j;
            }
            Elementary.inplaceAdd(startPoint, gapSize);
        }
    }

    static BigInteger consBigInteger(int bitLength, int certainty, Random rnd) {
        if (bitLength <= 10) {
            int[] rp = offsetPrimes[bitLength];
            return BIprimes[rp[0] + rnd.nextInt(rp[1])];
        }
        int shiftCount = -bitLength & 0x1F;
        int last = bitLength + 31 >> 5;
        if (Config.SERVER_MODE && Config.BIGINTEGER_MAX_SIZE < last) {
            throw new ObjectMemoryExceededException("BigInteger", last);
        }
        BigInteger n = BigInteger.newInstance(1, last, new int[last]);
        --last;
        do {
            int i = 0;
            while (i < n._size) {
                n._words[i] = rnd.nextInt();
                ++i;
            }
            int n2 = last;
            n._words[n2] = n._words[n2] | Integer.MIN_VALUE;
            int n3 = last;
            n._words[n3] = n._words[n3] >>> shiftCount;
            n._words[0] = n._words[0] | 1;
        } while (!Primality.isProbablePrime(n, certainty));
        return n;
    }

    static boolean isProbablePrime(BigInteger n, int certainty) {
        if (certainty <= 0 || n._size == 1 && n._words[0] == 2) {
            return true;
        }
        if (!n.testBit(0)) {
            return false;
        }
        if (n._size == 1 && (n._words[0] & 0xFFFFFC00) == 0) {
            return Arrays.binarySearch(primes, n._words[0]) >= 0;
        }
        int i = 1;
        while (i < primes.length) {
            if (Division.remainderArrayByInt(n._words, n._size, primes[i]) == 0) {
                return false;
            }
            ++i;
        }
        int bitLength = n.bitLength();
        i = 2;
        while (bitLength < BITS[i]) {
            ++i;
        }
        certainty = Math.min(i, 1 + (certainty - 1 >> 1));
        return Primality.millerRabin(n, certainty);
    }

    private static boolean millerRabin(BigInteger n, int t) {
        BigInteger n_minus_1 = n.minus(BigInteger.ONE);
        int bitLength = n_minus_1.bitLength();
        int k = n_minus_1.getLowestSetBit();
        BigInteger q = n_minus_1.shiftRight(k);
        Random rnd = new Random();
        int i = 0;
        while (i < t) {
            BigInteger x;
            if (i < primes.length) {
                x = BIprimes[i];
            } else {
                while ((x = new BigInteger(bitLength, rnd)).compareTo(n) >= 0 || x._sign == 0 || x.isOne()) {
                }
            }
            BigInteger y = x.modPow(q, n);
            if (!y.isOne() && !y.equals(n_minus_1)) {
                int j = 1;
                while (j < k) {
                    if (!y.equals(n_minus_1) && (y = y.times(y).mod(n)).isOne()) {
                        return false;
                    }
                    ++j;
                }
                if (!y.equals(n_minus_1)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static BigInteger countPrimes1021(BigInteger val, Map<Integer, Integer> map) {
        BigInteger result = val;
        int i = 0;
        while (i < primes.length) {
            if (result.isLessThan(BIprimes[i])) break;
            BigInteger[] divRem = Division.divideAndRemainderByInteger(result, primes[i], 1);
            while (divRem[1].equals(BigInteger.ZERO)) {
                Integer count = map.get(primes[i]);
                if (count == null) {
                    map.put(primes[i], 1);
                } else {
                    map.put(primes[i], count + 1);
                }
                result = divRem[0];
                if (result.isLessThan(BIprimes[i])) break;
                divRem = Division.divideAndRemainderByInteger(result, primes[i], 1);
            }
            ++i;
        }
        return result;
    }
}

