/*
 * Decompiled with CFR 0.152.
 */
package apache.harmony.math;

import apache.harmony.math.BigInteger;
import java.io.Serializable;

public final class Rational
implements Serializable {
    public static final Rational ZERO = new Rational(BigInteger.ZERO, BigInteger.ONE);
    public static final Rational ONE = new Rational(BigInteger.ONE, BigInteger.ONE);
    public static final Rational MINUS_ONE = new Rational(BigInteger.MINUS_ONE, BigInteger.ONE);
    private BigInteger fNumerator;
    private BigInteger fDenominator;
    private static final long serialVersionUID = 1L;

    private Rational() {
    }

    private Rational(BigInteger dividend, BigInteger divisor) {
        this.fNumerator = dividend;
        this.fDenominator = divisor;
    }

    public static Rational valueOf(double x) {
        return Rational.valueOf(x, 1.0E-12);
    }

    public static Rational valueOf(double x, double epsilon) {
        long intPart;
        double z;
        if (x == 0.0) {
            return ZERO;
        }
        if (Math.abs(x) > 9.223372036854776E18 || Math.abs(x) < 1.0842021724855044E-19) {
            return Rational.valueOf(0L, 0L);
        }
        int sgn = 1;
        if (x < 0.0) {
            sgn = -1;
            x = -x;
        }
        if ((z = x - (double)(intPart = (long)x)) != 0.0) {
            z = 1.0 / z;
            long a = (long)z;
            z -= (double)a;
            long prevNum = 0L;
            long num = 1L;
            long prevDen = 1L;
            long den = a;
            double approxAns = ((double)den * (double)intPart + (double)num) / (double)den;
            while (Math.abs((x - approxAns) / x) >= epsilon) {
                z = 1.0 / z;
                a = (long)z;
                z -= (double)a;
                if ((double)a * (double)num + (double)prevNum > 9.223372036854776E18 || (double)a * (double)den + (double)prevDen > 9.223372036854776E18) break;
                long tmp = a * num + prevNum;
                prevNum = num;
                num = tmp;
                tmp = a * den + prevDen;
                prevDen = den;
                den = tmp;
                approxAns = ((double)den * (double)intPart + (double)num) / (double)den;
            }
            return Rational.valueOf((long)sgn * (den * intPart + num), den);
        }
        return Rational.valueOf((long)sgn * intPart, 1L);
    }

    public static Rational valueOf(long dividend, long divisor) {
        Rational r = new Rational();
        r.fNumerator = BigInteger.valueOf(dividend);
        r.fDenominator = BigInteger.valueOf(divisor);
        return r.normalize();
    }

    public static Rational valueOf(BigInteger dividend, BigInteger divisor) {
        Rational r = new Rational();
        r.fNumerator = dividend;
        r.fDenominator = divisor;
        return r.normalize();
    }

    public static Rational valueOf(Rational rat) {
        Rational r = new Rational();
        r.fNumerator = rat.fNumerator;
        r.fDenominator = rat.fDenominator;
        return r;
    }

    public static Rational valueOf(String chars) {
        int sep = chars.indexOf("/");
        if (sep >= 0) {
            BigInteger dividend = BigInteger.valueOf(chars.substring(0, sep));
            BigInteger divisor = BigInteger.valueOf(chars.substring(sep + 1, chars.length()));
            return Rational.valueOf(dividend, divisor);
        }
        return Rational.valueOf(BigInteger.valueOf(chars), BigInteger.ONE);
    }

    public BigInteger getNumerator() {
        return this.fNumerator;
    }

    public BigInteger getDenominator() {
        return this.fDenominator;
    }

    public BigInteger round() {
        return this.fNumerator.divide(this.fDenominator);
    }

    public Rational opposite() {
        return Rational.valueOf(this.fNumerator.opposite(), this.fDenominator);
    }

    public Rational plus(Rational that) {
        return Rational.valueOf(this.fNumerator.times(that.fDenominator).plus(this.fDenominator.times(that.fNumerator)), this.fDenominator.times(that.fDenominator)).normalize();
    }

    public Rational minus(Rational that) {
        return Rational.valueOf(this.fNumerator.times(that.fDenominator).minus(this.fDenominator.times(that.fNumerator)), this.fDenominator.times(that.fDenominator)).normalize();
    }

    public Rational times(Rational that) {
        Rational r = Rational.valueOf(this.fNumerator.times(that.fNumerator), this.fDenominator.times(that.fDenominator)).normalize();
        return r;
    }

    public Rational inverse() {
        if (this.fNumerator.isZero()) {
            throw new ArithmeticException("Dividend is zero");
        }
        return this.fNumerator.isNegative() ? Rational.valueOf(this.fDenominator.opposite(), this.fNumerator.opposite()) : Rational.valueOf(this.fDenominator, this.fNumerator);
    }

    public Rational divide(Rational that) {
        return Rational.valueOf(this.fNumerator.times(that.fDenominator), this.fDenominator.times(that.fNumerator)).normalize();
    }

    public Rational abs() {
        return Rational.valueOf(this.fNumerator.abs(), this.fDenominator);
    }

    public boolean isLargerThan(Rational that) {
        return this.fNumerator.times(that.fDenominator).isLargerThan(that.fNumerator.times(this.fDenominator));
    }

    public boolean isNegative() {
        return this.fNumerator.isNegative() ^ this.fDenominator.isNegative();
    }

    public boolean equals(Object that) {
        if (that instanceof Rational) {
            return this.fNumerator.equals(((Rational)that).fNumerator) && this.fDenominator.equals(((Rational)that).fDenominator);
        }
        return false;
    }

    public int hashCode() {
        return this.fNumerator.hashCode() - this.fDenominator.hashCode();
    }

    public long longValue() {
        return (long)this.doubleValue();
    }

    public double doubleValue() {
        int divisorBitLength;
        int dividendBitLength = this.fNumerator.bitLength();
        if (dividendBitLength > (divisorBitLength = this.fDenominator.bitLength())) {
            int shift = divisorBitLength - 63;
            long divisor = this.fDenominator.shiftRight(shift).longValue();
            BigInteger dividend = this.fNumerator.shiftRight(shift);
            return dividend.doubleValue() / (double)divisor;
        }
        int shift = dividendBitLength - 63;
        long dividend = this.fNumerator.shiftRight(shift).longValue();
        BigInteger divisor = this.fDenominator.shiftRight(shift);
        return (double)dividend / divisor.doubleValue();
    }

    public int compareTo(Rational that) {
        return this.fNumerator.times(that.fDenominator).compareTo(that.fNumerator.times(this.fDenominator));
    }

    private Rational normalize() {
        if (!this.fDenominator.isZero()) {
            if (this.fDenominator.isPositive()) {
                BigInteger gcd = this.fNumerator.gcd(this.fDenominator);
                if (!gcd.equals(BigInteger.ONE)) {
                    this.fNumerator = this.fNumerator.divide(gcd);
                    this.fDenominator = this.fDenominator.divide(gcd);
                }
                return this;
            }
            this.fNumerator = this.fNumerator.opposite();
            this.fDenominator = this.fDenominator.opposite();
            return this.normalize();
        }
        throw new ArithmeticException("Zero divisor");
    }

    public Rational copyNew() {
        Rational r = new Rational();
        r.fNumerator = this.fNumerator.copyNew();
        r.fDenominator = this.fDenominator.copyNew();
        return r;
    }
}

