/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ColorPolynomial;
import edu.jas.structure.RingElem;
import java.io.Serializable;

public class CPair<C extends RingElem<C>>
implements Serializable,
Comparable<CPair<C>> {
    public final ColorPolynomial<C> pi;
    public final ColorPolynomial<C> pj;
    public final int i;
    public final int j;
    protected int n;
    protected boolean toZero = false;
    protected boolean useCriterion4 = true;
    protected boolean useCriterion3 = true;

    public CPair(ColorPolynomial<C> a, ColorPolynomial<C> b, int i, int j) {
        this.pi = a;
        this.pj = b;
        this.i = i;
        this.j = j;
        this.n = 0;
        this.toZero = false;
    }

    public String toString() {
        return "pair[" + this.n + "](" + this.i + "{" + this.pi.length() + "}," + this.j + "{" + this.pj.length() + "}" + ", r0=" + this.toZero + ", c4=" + this.useCriterion4 + ", c3=" + this.useCriterion3 + ")";
    }

    public void pairNumber(int n) {
        this.n = n;
    }

    public int getPairNumber() {
        return this.n;
    }

    public void setZero() {
        this.toZero = true;
    }

    public boolean isZero() {
        return this.toZero;
    }

    public boolean equals(Object ob) {
        CPair cp = null;
        try {
            cp = (CPair)ob;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (cp == null) {
            return false;
        }
        return this.compareTo(cp) == 0;
    }

    @Override
    public int compareTo(CPair<C> p) {
        int x = p.getPairNumber();
        if (this.n > x) {
            return 1;
        }
        if (this.n < x) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int h = this.getPairNumber();
        return h;
    }

    public void setUseCriterion4(boolean c) {
        this.useCriterion4 = c;
    }

    public boolean getUseCriterion4() {
        return this.useCriterion4;
    }

    public void setUseCriterion3(boolean c) {
        this.useCriterion3 = c;
    }

    public boolean getUseCriterion3() {
        return this.useCriterion3;
    }
}

