/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ColorPolynomial<C extends RingElem<C>> {
    public final GenPolynomial<GenPolynomial<C>> green;
    public final GenPolynomial<GenPolynomial<C>> red;
    public final GenPolynomial<GenPolynomial<C>> white;

    public ColorPolynomial(GenPolynomial<GenPolynomial<C>> g, GenPolynomial<GenPolynomial<C>> r, GenPolynomial<GenPolynomial<C>> w) {
        if (g == null || r == null || w == null) {
            throw new IllegalArgumentException("g,r,w may not be null");
        }
        this.green = g;
        this.red = r;
        this.white = w;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(":green: ");
        s.append(this.green.toString());
        s.append(" :red: ");
        s.append(this.red.toString());
        s.append(" :white: ");
        s.append(this.white.toString());
        return s.toString();
    }

    public boolean isZERO() {
        return this.red.isZERO() && this.white.isZERO();
    }

    public boolean isONE() {
        return this.red.isZERO() && this.white.isONE() || this.red.isONE() && this.white.isZERO();
    }

    public boolean equals(Object p) {
        ColorPolynomial cp = null;
        try {
            cp = (ColorPolynomial)p;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (cp == null) {
            return false;
        }
        return this.green.equals(cp.green) && this.red.equals(cp.red) && this.white.equals(cp.white);
    }

    public int hashCode() {
        int h = this.green.hashCode();
        h <<= 11;
        h += this.red.hashCode();
        h <<= 11;
        return h += this.white.hashCode();
    }

    public boolean isDetermined() {
        return !this.red.isZERO() || this.white.isZERO();
    }

    public boolean checkInvariant() {
        ExpVector ltw;
        Comparator<ExpVector> cmp;
        ExpVector ttg;
        boolean t = true;
        if (this.green.isZERO() && this.red.isZERO() && this.white.isZERO()) {
            return true;
        }
        if (this.green.isZERO() && this.red.isZERO()) {
            return true;
        }
        if (this.red.isZERO() && this.white.isZERO()) {
            return true;
        }
        if (!this.green.isZERO() && !this.red.isZERO()) {
            ttg = this.green.trailingExpVector();
            ExpVector ltr = this.red.leadingExpVector();
            cmp = this.green.ring.tord.getDescendComparator();
            boolean bl = t = t && cmp.compare(ttg, ltr) < 0;
        }
        if (!this.red.isZERO() && !this.white.isZERO()) {
            ExpVector ttr = this.red.trailingExpVector();
            ltw = this.white.leadingExpVector();
            cmp = this.white.ring.tord.getDescendComparator();
            boolean bl = t = t && cmp.compare(ttr, ltw) < 0;
        }
        if (this.red.isZERO() && !this.green.isZERO() && !this.white.isZERO()) {
            ttg = this.green.trailingExpVector();
            ltw = this.white.leadingExpVector();
            cmp = this.white.ring.tord.getDescendComparator();
            boolean bl = t = t && cmp.compare(ttg, ltw) < 0;
        }
        if (!t) {
            System.out.println("not invariant " + this);
        }
        return t;
    }

    public List<GenPolynomial<C>> getGreenCoefficients() {
        Collection<GenPolynomial<C>> c = this.green.getMap().values();
        return new ArrayList<GenPolynomial<C>>(c);
    }

    public List<GenPolynomial<C>> getRedCoefficients() {
        Collection<GenPolynomial<C>> c = this.red.getMap().values();
        return new ArrayList<GenPolynomial<C>>(c);
    }

    public GenPolynomial<GenPolynomial<C>> getPolynomial() {
        GenPolynomial<GenPolynomial<C>> f = this.green.sum((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)this.red).sum((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>)this.white);
        int s = this.green.length() + this.red.length() + this.white.length();
        int t = f.length();
        if (t != s) {
            throw new RuntimeException("illegal coloring state " + s + " != " + t);
        }
        return f;
    }

    public GenPolynomial<GenPolynomial<C>> getEssentialPolynomial() {
        GenPolynomial<GenPolynomial<C>> f = this.red.sum((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)this.white);
        int s = this.red.length() + this.white.length();
        int t = f.length();
        if (t != s) {
            throw new RuntimeException("illegal coloring state " + s + " != " + t);
        }
        return f;
    }

    public int length() {
        int s = this.red.length() + this.white.length();
        return s;
    }

    public ExpVector leadingExpVector() {
        if (!this.red.isZERO()) {
            return this.red.leadingExpVector();
        }
        return this.white.leadingExpVector();
    }

    public Map.Entry<ExpVector, GenPolynomial<C>> leadingMonomial() {
        if (!this.red.isZERO()) {
            return this.red.leadingMonomial();
        }
        return this.white.leadingMonomial();
    }

    public ColorPolynomial<C> abs() {
        int s = this.green.signum();
        if (s > 0) {
            return this;
        }
        if (s < 0) {
            AbelianGroupElem g = this.green.negate();
            AbelianGroupElem r = this.red.negate();
            AbelianGroupElem w = this.white.negate();
            return new ColorPolynomial<C>(g, r, w);
        }
        GenPolynomial<GenPolynomial<C>> g = this.green;
        s = this.red.signum();
        if (s > 0) {
            return this;
        }
        if (s < 0) {
            AbelianGroupElem r = this.red.negate();
            AbelianGroupElem w = this.white.negate();
            return new ColorPolynomial<C>(g, r, w);
        }
        GenPolynomial<GenPolynomial<C>> r = this.red;
        s = this.white.signum();
        if (s > 0) {
            return this;
        }
        if (s < 0) {
            AbelianGroupElem w = this.white.negate();
            return new ColorPolynomial<C>(g, r, w);
        }
        GenPolynomial<GenPolynomial<C>> w = this.white;
        return new ColorPolynomial<C>(g, r, w);
    }

    public ColorPolynomial<C> sum(ColorPolynomial<C> S) {
        GenPolynomial<GenPolynomial<C>> g = this.green.sum((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)S.green);
        AbelianGroupElem r = this.red.ring.getZERO();
        GenPolynomial<GenPolynomial<C>> w = this.getEssentialPolynomial().sum((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)S.getEssentialPolynomial());
        return new ColorPolynomial<C>(g, r, w);
    }

    public ColorPolynomial<C> sum(GenPolynomial<C> s, ExpVector e) {
        GenPolynomial<GenPolynomial<C>> g = this.green;
        GenPolynomial<GenPolynomial<C>> r = this.red;
        GenPolynomial<GenPolynomial<C>> w = this.white;
        if (this.green.getMap().keySet().contains(e)) {
            g = this.green.sum(s, e);
        } else if (this.red.getMap().keySet().contains(e)) {
            r = this.red.sum(s, e);
        } else {
            w = this.white.sum(s, e);
        }
        return new ColorPolynomial<C>(g, r, w);
    }

    public ColorPolynomial<C> subtract(ColorPolynomial<C> S) {
        GenPolynomial<GenPolynomial<C>> g = this.green.subtract((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)S.green);
        AbelianGroupElem r = this.red.ring.getZERO();
        GenPolynomial<GenPolynomial<C>> w = this.getEssentialPolynomial().subtract((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)S.getEssentialPolynomial());
        return new ColorPolynomial<C>(g, r, w);
    }

    public ColorPolynomial<C> subtract(GenPolynomial<C> s, ExpVector e) {
        GenPolynomial<GenPolynomial<C>> g = this.green;
        GenPolynomial<GenPolynomial<C>> r = this.red;
        GenPolynomial<GenPolynomial<C>> w = this.white;
        if (this.green.getMap().keySet().contains(e)) {
            g = this.green.subtract(s, e);
        } else if (this.red.getMap().keySet().contains(e)) {
            r = this.red.subtract(s, e);
        } else {
            w = this.white.subtract(s, e);
        }
        return new ColorPolynomial<C>(g, r, w);
    }

    public ColorPolynomial<C> multiply(GenPolynomial<C> s, ExpVector e) {
        GenPolynomial<GenPolynomial<C>> g = this.green.multiply(s, e);
        GenPolynomial<GenPolynomial<C>> r = this.red.multiply(s, e);
        GenPolynomial<GenPolynomial<C>> w = this.white.multiply(s, e);
        return new ColorPolynomial<C>(g, r, w);
    }

    public ColorPolynomial<C> multiply(GenPolynomial<C> s) {
        GenPolynomial<GenPolynomial<C>> g = this.green.multiply((GenPolynomial<GenPolynomial<C>>)s);
        GenPolynomial<GenPolynomial<C>> r = this.red.multiply((GenPolynomial<GenPolynomial<C>>)s);
        GenPolynomial<GenPolynomial<C>> w = this.white.multiply((GenPolynomial<GenPolynomial<C>>)s);
        return new ColorPolynomial<C>(g, r, w);
    }

    public ColorPolynomial<C> divide(GenPolynomial<C> s) {
        GenPolynomial<GenPolynomial<C>> g = this.green.divide((GenPolynomial<GenPolynomial<C>>)s);
        GenPolynomial<GenPolynomial<C>> r = this.red.divide((GenPolynomial<GenPolynomial<C>>)s);
        GenPolynomial<GenPolynomial<C>> w = this.white.divide((GenPolynomial<GenPolynomial<C>>)s);
        return new ColorPolynomial<C>(g, r, w);
    }
}

