/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ColorPolynomial;
import edu.jas.application.Ideal;
import edu.jas.application.MultiplicativeSet;
import edu.jas.application.MultiplicativeSetSquarefree;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Condition<C extends GcdRingElem<C>>
implements Serializable {
    private static final Logger logger = Logger.getLogger(Condition.class);
    private final boolean debug = logger.isDebugEnabled();
    public final Ideal<C> zero;
    public final MultiplicativeSet<C> nonZero;

    public Condition(GenPolynomialRing<C> ring) {
        this(new Ideal<C>(ring), new MultiplicativeSetSquarefree<C>(ring));
        if (ring == null) {
            throw new IllegalArgumentException("only for non null rings");
        }
    }

    public Condition(Ideal<C> z) {
        this(z, new MultiplicativeSetSquarefree(z.list.ring));
    }

    public Condition(MultiplicativeSet<C> nz) {
        this(new Ideal(nz.ring), nz);
    }

    public Condition(Ideal<C> z, MultiplicativeSet<C> nz) {
        if (z == null || nz == null) {
            throw new IllegalArgumentException("only for non null condition parts");
        }
        this.zero = z;
        this.nonZero = nz;
    }

    public String toString() {
        return "Condition[ 0 == " + this.zero.list.list.toString() + ", 0 != " + this.nonZero.mset.toString() + " ]";
    }

    public boolean equals(Object ob) {
        Condition c = null;
        try {
            c = (Condition)ob;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (c == null) {
            return false;
        }
        if (!this.zero.equals(c.zero)) {
            return false;
        }
        return this.nonZero.equals(c.nonZero);
    }

    public int hashCode() {
        int h = this.zero.getList().hashCode();
        h <<= 17;
        return h += this.nonZero.hashCode();
    }

    public boolean isEmpty() {
        return this.zero.isZERO() && this.nonZero.isEmpty();
    }

    public boolean isContradictory() {
        if (this.zero.isZERO()) {
            return false;
        }
        boolean t = this.zero.isONE();
        if (t) {
            logger.info((Object)("contradiction zero.isONE(): " + this));
            return t;
        }
        for (GenPolynomial p : this.zero.list.list) {
            t = this.nonZero.contains(p);
            if (!t) continue;
            logger.info((Object)("contradiction nonZero.contains(zero): " + this + ", pol = " + p));
            return t;
        }
        for (GenPolynomial p : this.nonZero.mset) {
            t = this.zero.contains(p);
            if (!t) continue;
            logger.info((Object)("contradiction zero.contains(nonZero): " + this + ", pol = " + p));
            return t;
        }
        return false;
    }

    public Condition<C> extendZero(GenPolynomial<C> z) {
        z = z.monic();
        Ideal<C> idz = this.zero.sum(z);
        logger.info((Object)("added to ideal: " + z));
        Condition<C> nc = new Condition<C>(idz, this.nonZero);
        return nc.simplify();
    }

    public Condition<C> extendNonZero(GenPolynomial<C> nz) {
        GenPolynomial<C> n = this.zero.normalform(nz).monic();
        if (n == null || n.isZERO()) {
            return this;
        }
        MultiplicativeSet<C> ms = this.nonZero.add(n);
        logger.info((Object)("added to non zero: " + n));
        Condition<C> nc = new Condition<C>(this.zero, ms);
        return nc.simplify();
    }

    public Condition<C> simplify() {
        Condition<C> nc;
        List<GenPolynomial<C>> Z;
        Ideal idz = this.zero.squarefree();
        if (!idz.getList().equals(this.zero.getList())) {
            logger.info((Object)("simplify squarefree: " + this.zero.getList() + " to " + idz.getList()));
        }
        List<GenPolynomial<C>> ml = idz.normalform(this.nonZero.mset);
        MultiplicativeSet<C> ms = this.nonZero;
        if (!ml.equals(this.nonZero.mset)) {
            if (ml.size() != this.nonZero.mset.size()) {
                logger.info((Object)"contradiction(==0):");
                logger.info((Object)("simplify normalform contradiction: " + this.nonZero.mset + " to " + ml));
                return null;
            }
            logger.info((Object)("simplify normalform: " + this.nonZero.mset + " to " + ml));
            ms = this.nonZero.replace(ml);
        }
        if (!(Z = ms.removeFactors(idz.getList())).equals(idz.getList())) {
            if (Z.size() != idz.getList().size()) {
                logger.info((Object)"contradiction(!=0):");
                logger.info((Object)("simplify removeFactors contradiction: " + idz.getList() + " to " + Z));
                return null;
            }
            logger.info((Object)("simplify removeFactors: " + idz.getList() + " to " + Z));
            idz = new Ideal<C>(this.zero.getRing(), Z);
        }
        if ((nc = new Condition<C>(idz, ms)).isContradictory()) {
            return null;
        }
        if (idz.equals(this.zero) && ms.equals(this.nonZero)) {
            return this;
        }
        logger.info((Object)("condition simplified: " + this + " to " + nc));
        return nc.simplify();
    }

    public Color color(GenPolynomial<C> c) {
        GenPolynomial<C> m = this.zero.normalform(c).monic();
        if (m.isZERO()) {
            return Color.GREEN;
        }
        if (m.isConstant()) {
            return Color.RED;
        }
        if (this.nonZero.contains(m) || this.nonZero.contains(c)) {
            return Color.RED;
        }
        return Color.WHITE;
    }

    public ColorPolynomial<C> determine(GenPolynomial<GenPolynomial<C>> A) {
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>> zero;
        ColorPolynomial cp = null;
        if (A == null) {
            return cp;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>> green = zero = A.ring.getZERO();
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>> red = zero;
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>> white = zero;
        if (A.isZERO()) {
            cp = new ColorPolynomial(green, red, white);
            return cp;
        }
        GenPolynomial<GenPolynomial<C>> Ap = A;
        while (!Ap.isZERO()) {
            Map.Entry<ExpVector, GenPolynomial<C>> m = Ap.leadingMonomial();
            ExpVector e = m.getKey();
            GenPolynomial<C> c = m.getValue();
            GenPolynomial<GenPolynomial<GenPolynomial<C>>> Bp = Ap.reductum();
            switch (this.color(c)) {
                case GREEN: {
                    green = green.sum(c, e);
                    Ap = Bp;
                    break;
                }
                case RED: {
                    red = red.sum(c, e);
                    white = Bp;
                    return new ColorPolynomial<C>(green, red, white);
                }
                default: {
                    System.out.println("error cond       = " + this);
                    System.out.println("error poly     A = " + A);
                    System.out.println("error poly green = " + green);
                    System.out.println("error poly   red = " + red);
                    System.out.println("error poly    Ap = " + Ap);
                    System.out.println("error coeff    c = " + c);
                    throw new RuntimeException("error, c is white = " + c);
                }
            }
        }
        cp = new ColorPolynomial(green, red, white);
        return cp;
    }

    public List<ColorPolynomial<C>> determine(List<GenPolynomial<GenPolynomial<C>>> L) {
        ArrayList<ColorPolynomial<C>> cl = null;
        if (L == null) {
            return cl;
        }
        cl = new ArrayList<ColorPolynomial<C>>(L.size());
        for (GenPolynomial<GenPolynomial<C>> A : L) {
            ColorPolynomial<C> c = this.determine(A);
            if (c == null || c.isZERO()) continue;
            cl.add(c);
        }
        return cl;
    }

    public ColorPolynomial<C> reDetermine(ColorPolynomial<C> s) {
        ColorPolynomial<C> p = this.determine(s.getEssentialPolynomial());
        GenPolynomial g = s.green.sum(p.green);
        p = new ColorPolynomial(g, p.red, p.white);
        return p;
    }

    public List<ColorPolynomial<C>> reDetermine(List<ColorPolynomial<C>> S) {
        if (S == null || S.isEmpty()) {
            return S;
        }
        ArrayList<ColorPolynomial<C>> P = new ArrayList<ColorPolynomial<C>>();
        for (ColorPolynomial<C> s : S) {
            ColorPolynomial<C> p = this.reDetermine(s);
            P.add(p);
        }
        return P;
    }

    public boolean isDetermined(ColorPolynomial<C> s) {
        ColorPolynomial<C> p = this.determine(s.getPolynomial());
        boolean t = p.equals(s);
        if (!t) {
            System.out.println("not determined s    = " + s);
            System.out.println("not determined p    = " + p);
            System.out.println("not determined cond = " + this);
        }
        return t;
    }

    public boolean isDetermined(List<ColorPolynomial<C>> S) {
        if (S == null) {
            return true;
        }
        for (ColorPolynomial<C> p : S) {
            if (this.isDetermined(p)) continue;
            return false;
        }
        return true;
    }

    public static enum Color {
        GREEN,
        RED,
        WHITE;

    }
}

