/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ComprehensiveGroebnerBaseSeq;
import edu.jas.application.GroebnerSystem;
import edu.jas.application.Ideal;
import edu.jas.application.IdealWithRealAlgebraicRoots;
import edu.jas.application.PolyUtilApp;
import edu.jas.application.Residue;
import edu.jas.application.ResidueRing;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ProductRing;
import edu.jas.gb.GBFactory;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.RGroebnerBasePseudoSeq;
import edu.jas.gb.RReductionSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.structure.MonoidElem;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;

public class Examples {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        if (args.length > 0) {
            Examples.example1();
            Examples.example2();
            Examples.example3();
            Examples.example4();
        }
        Examples.example5();
        Examples.example6();
        ComputerThreads.terminate();
    }

    public static void example1() {
        int n = 4;
        BigInteger fac = new BigInteger();
        GenPolynomialRing<BigInteger> ring = new GenPolynomialRing<BigInteger>(fac, n);
        System.out.println("ring = " + ring + "\n");
        ArrayList cp = new ArrayList(n);
        int i = 1;
        while (i <= n) {
            GenPolynomial<BigInteger> p = Examples.cyclicPoly(ring, n, i);
            cp.add(p);
            System.out.println("p[" + i + "] = " + p);
            System.out.println();
            ++i;
        }
        System.out.println("cp = " + cp + "\n");
        GroebnerBaseAbstract<BigInteger> sgb = GBFactory.getImplementation(fac);
        List gb = sgb.GB(cp);
        System.out.println("gb = " + gb);
    }

    static GenPolynomial<BigInteger> cyclicPoly(GenPolynomialRing<BigInteger> ring, int n, int i) {
        List<GenPolynomial<BigInteger>> X = ring.univariateList();
        GenPolynomial<MonoidElem> p = ring.getZERO();
        int j = 1;
        while (j <= n) {
            GenPolynomial<GenPolynomial<BigInteger>> pi = ring.getONE();
            int k = j;
            while (k < j + i) {
                pi = pi.multiply(X.get(k % n));
                ++k;
            }
            p = p.sum(pi);
            if (i == n) {
                p = p.subtract(ring.getONE());
                break;
            }
            ++j;
        }
        return p;
    }

    public static void example2() {
        ArrayList L = null;
        L = new ArrayList();
        BigRational bfac = new BigRational(1L);
        GenPolynomialRing<BigRational> pfac = null;
        pfac = new GenPolynomialRing<BigRational>(bfac, 3);
        ArrayList F2 = null;
        F2 = new ArrayList();
        GenPolynomial<BigRational> p = null;
        int i = 0;
        while (i < 2) {
            p = pfac.random(5, 4, 3, 0.4f);
            if (!p.isConstant()) {
                F2.add(p);
            }
            ++i;
        }
        Ideal<BigRational> id = new Ideal<BigRational>(pfac, F2);
        id.doGB();
        if (id.isONE() || id.isZERO()) {
            System.out.println("id zero or one = " + id);
            return;
        }
        ResidueRing<BigRational> rr = new ResidueRing<BigRational>(id);
        System.out.println("rr = " + rr);
        ProductRing<BigRational> pr = null;
        pr = new ProductRing<BigRational>(rr, 3);
        String[] vars = new String[]{"a", "b"};
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(pr, 2, vars);
        int i2 = 0;
        while (i2 < 1) {
            GenPolynomial<BigRational> pp = fac.random(2, 4, 4, 0.4f);
            if (!pp.isConstant()) {
                L.add(pp);
            }
            ++i2;
        }
        System.out.println("L = " + L);
        RGroebnerBasePseudoSeq<BigRational> bb = new RGroebnerBasePseudoSeq<BigRational>(pr);
        System.out.println("isGB(L) = " + bb.isGB(L));
        List G = null;
        G = bb.GB(L);
        System.out.println("G = " + G);
        System.out.println("isGB(G) = " + bb.isGB(G));
    }

    public static void example3() {
        ArrayList L = null;
        L = new ArrayList();
        BigRational bfac = new BigRational(1L);
        GenPolynomialRing<BigRational> pfac = null;
        pfac = new GenPolynomialRing<BigRational>(bfac, 2);
        ArrayList F2 = null;
        F2 = new ArrayList();
        GenPolynomial<BigRational> p = null;
        int i = 0;
        while (i < 2) {
            p = pfac.random(5, 5, 5, 0.4f);
            if (!p.isConstant()) {
                F2.add(p);
            }
            ++i;
        }
        Ideal<BigRational> id = new Ideal<BigRational>(pfac, F2);
        id.doGB();
        if (id.isONE() || id.isZERO()) {
            System.out.println("id zero or one = " + id);
            return;
        }
        ResidueRing<BigRational> rr = new ResidueRing<BigRational>(id);
        System.out.println("rr = " + rr);
        String[] vars = new String[]{"a", "b"};
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(rr, 2, vars);
        int i2 = 0;
        while (i2 < 2) {
            GenPolynomial<BigRational> pp = fac.random(2, 4, 6, 0.2f);
            if (!pp.isConstant()) {
                L.add(pp);
            }
            ++i2;
        }
        System.out.println("L = " + L);
        GroebnerBaseAbstract<BigRational> bb = GBFactory.getImplementation(rr);
        System.out.println("isGB(L) = " + bb.isGB(L));
        List G = null;
        G = bb.GB(L);
        System.out.println("G = " + G);
        System.out.println("isGB(G) = " + bb.isGB(G));
    }

    public static void example4() {
        int kl = 2;
        int ll = 3;
        int el = 3;
        float q = 0.2f;
        BigRational coeff = new BigRational(kl);
        String[] cv = new String[]{"a", "b"};
        GenPolynomialRing<BigRational> cfac = new GenPolynomialRing<BigRational>(coeff, 2, cv);
        String[] v = new String[]{"x", "y"};
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(cfac, 2, v);
        ComprehensiveGroebnerBaseSeq<BigRational> bb = new ComprehensiveGroebnerBaseSeq<BigRational>(coeff);
        List<GenPolynomial<GenPolynomial<Object>>> L = new ArrayList();
        GenPolynomial<BigRational> a = fac.random(kl, ll, el, q);
        GenPolynomial<BigRational> b = fac.random(kl, ll, el, q);
        GenPolynomial<BigRational> c = a;
        if (a.isZERO() || b.isZERO() || c.isZERO()) {
            return;
        }
        L.add(a);
        System.out.println("CGB exam L = " + L);
        L = bb.GB(L);
        System.out.println("CGB( L )   = " + L);
        System.out.println("isCGB( L ) = " + bb.isGB(L));
        L.add(b);
        System.out.println("CGB exam L = " + L);
        L = bb.GB(L);
        System.out.println("CGB( L )   = " + L);
        System.out.println("isCGB( L ) = " + bb.isGB(L));
        L.add(c);
        System.out.println("CGB exam L = " + L);
        L = bb.GB(L);
        System.out.println("CGB( L )   = " + L);
        System.out.println("isCGB( L ) = " + bb.isGB(L));
    }

    public static void example5() {
        int kl = 2;
        int ll = 4;
        int el = 3;
        float q = 0.3f;
        BigRational coeff = new BigRational(kl);
        String[] cv = new String[]{"a", "b"};
        GenPolynomialRing<BigRational> cfac = new GenPolynomialRing<BigRational>(coeff, 2, cv);
        String[] v = new String[]{"x", "y"};
        GenPolynomialRing<BigRational> fac = new GenPolynomialRing<BigRational>(cfac, 2, v);
        ComprehensiveGroebnerBaseSeq<BigRational> bb = new ComprehensiveGroebnerBaseSeq<BigRational>(coeff);
        ArrayList L = new ArrayList();
        GenPolynomial<BigRational> a = fac.random(kl, ll, el, q);
        GenPolynomial<BigRational> b = fac.random(kl, ll, el, q);
        GenPolynomial<BigRational> c = a;
        if (a.isZERO() || b.isZERO() || c.isZERO()) {
            return;
        }
        L.add(a);
        L.add(b);
        L.add(c);
        System.out.println("CGB exam L = " + L);
        GroebnerSystem<BigRational> sys = bb.GBsys(L);
        boolean ig = bb.isGB(sys.getCGB());
        System.out.println("CGB( L )   = " + sys.getCGB());
        System.out.println("isCGB( L ) = " + ig);
        RReductionSeq res = new RReductionSeq();
        List Lr = PolyUtilApp.toProductRes(sys.list);
        List bLr = res.booleanClosure(Lr);
        System.out.println("booleanClosed(Lr)   = " + bLr);
        if (bLr.size() > 0) {
            RGroebnerBasePseudoSeq rbb = new RGroebnerBasePseudoSeq(bLr.get((int)0).ring.coFac);
            System.out.println("isRegularGB(Lr) = " + rbb.isGB(bLr));
        }
    }

    public static void example6() {
        BigRational coeff = new BigRational();
        GroebnerBaseAbstract<BigRational> gb = GBFactory.getImplementation(coeff);
        String exam = "(x,y,z) L ( ( x^2 - 2 ), ( y^2 - 3 ), ( z^2 + x * y )) ";
        StringReader source = new StringReader(exam);
        GenPolynomialTokenizer parser = new GenPolynomialTokenizer(source);
        PolynomialList F2 = null;
        try {
            F2 = parser.nextPolynomialSet();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("F = " + F2);
        List G = gb.GB(F2.list);
        PolynomialList Gp = new PolynomialList(F2.ring, G);
        System.out.println("G = " + Gp);
        Ideal I2 = new Ideal(Gp);
        List Ir = PolyUtilApp.realAlgebraicRoots(I2);
        for (IdealWithRealAlgebraicRoots R : Ir) {
            R.doDecimalApproximation();
            for (List<BigDecimal> Dr : R.decimalApproximation()) {
                System.out.println(Dr.toString());
            }
            System.out.println();
        }
    }

    public static void example7() {
        String[] vars = new String[]{"v3", "v2", "v1"};
        ModIntegerRing z2 = new ModIntegerRing(2L);
        GenPolynomialRing<ModInteger> z2p = new GenPolynomialRing<ModInteger>(z2, vars.length, new TermOrder(2), vars);
        ArrayList fieldPolynomials = new ArrayList();
        int i = 0;
        while (i < vars.length) {
            GenPolynomial<ModInteger> var = z2p.univariate(i);
            fieldPolynomials.add(var.multiply((ModInteger)((Object)var)).sum(var));
            ++i;
        }
        Ideal<ModInteger> fieldPolys = new Ideal<ModInteger>(z2p, fieldPolynomials);
        ResidueRing<ModInteger> ring = new ResidueRing<ModInteger>(fieldPolys);
        String[] mvars = new String[]{"mv3", "mv2", "mv1"};
        GenPolynomialRing<ModInteger> ringp = new GenPolynomialRing<ModInteger>(ring, mvars.length, mvars);
        ArrayList polynomials = new ArrayList();
        GenPolynomial<ModInteger> v1 = ringp.univariate(0);
        GenPolynomial<ModInteger> v2 = ringp.univariate(1);
        GenPolynomial<ModInteger> v3 = ringp.univariate(2);
        GenPolynomial notV1 = v1.sum((ModInteger)((Object)ringp.ONE));
        GenPolynomial notV2 = v2.sum((ModInteger)((Object)ringp.ONE));
        GenPolynomial notV3 = v3.sum((ModInteger)((Object)ringp.ONE));
        GenPolynomial<GenPolynomial<ModInteger>> p1 = v1.multiply((ModInteger)((Object)v2));
        GenPolynomial p2 = notV1.multiply(notV2);
        GenPolynomial p3 = notV1.multiply(notV3);
        polynomials.add(p1);
        polynomials.add(p2);
        polynomials.add(p3);
        GroebnerBaseAbstract<ModInteger> gb = GBFactory.getImplementation(ring);
        List G = gb.GB(polynomials);
        System.out.println(G);
    }

    public static void example8() {
        String[] vars = new String[]{"v3", "v2", "v1"};
        ModIntegerRing z2 = new ModIntegerRing(2L);
        GenPolynomialRing<ModInteger> z2p = new GenPolynomialRing<ModInteger>(z2, vars.length, new TermOrder(2), vars);
        ArrayList fieldPolynomials = new ArrayList();
        int i = 0;
        while (i < vars.length) {
            GenPolynomial<ModInteger> var = z2p.univariate(i);
            fieldPolynomials.add(var.multiply((ModInteger)((Object)var)).sum(var));
            ++i;
        }
        Ideal<ModInteger> fieldPolys = new Ideal<ModInteger>(z2p, fieldPolynomials);
        ResidueRing<ModInteger> ring = new ResidueRing<ModInteger>(fieldPolys);
        String[] mvars = new String[]{"mv3", "mv2", "mv1"};
        GenPolynomialRing<ModInteger> ringp = new GenPolynomialRing<ModInteger>(ring, mvars.length, mvars);
        ArrayList polynomials = new ArrayList();
        GenPolynomial<ModInteger> v1 = ringp.univariate(0);
        GenPolynomial<ModInteger> v2 = ringp.univariate(1);
        GenPolynomial<ModInteger> v3 = ringp.univariate(2);
        GenPolynomial notV1 = v1.sum((ModInteger)((Object)ringp.ONE));
        GenPolynomial notV2 = v2.sum((ModInteger)((Object)ringp.ONE));
        GenPolynomial notV3 = v3.sum((ModInteger)((Object)ringp.ONE));
        GenPolynomial<GenPolynomial<ModInteger>> p1 = v1.multiply((ModInteger)((Object)v2));
        GenPolynomial p2 = notV1.multiply(notV2);
        GenPolynomial p3 = notV1.multiply(notV3);
        polynomials.add(p1);
        polynomials.add(p2);
        polynomials.add(p3);
        List<Residue<ModInteger>> gens = ring.generators();
        System.out.println("gens = " + gens);
        GenPolynomial<Residue<ModInteger>> mv3v3 = v3.subtract((ModInteger)((Object)gens.get(1)));
        GenPolynomial<Residue<ModInteger>> mv2v2 = v2.subtract((ModInteger)((Object)gens.get(2)));
        GenPolynomial<Residue<ModInteger>> mv1v1 = v1.subtract((ModInteger)((Object)gens.get(3)));
        System.out.println("mv3v3 = " + mv3v3);
        System.out.println("mv2v2 = " + mv2v2);
        System.out.println("mv1v1 = " + mv1v1);
        polynomials.add(mv3v3);
        polynomials.add(mv2v2);
        polynomials.add(mv1v1);
        GroebnerBaseAbstract<ModInteger> gb = GBFactory.getImplementation(ring);
        List G = gb.GB(polynomials);
        System.out.println(G);
    }
}

