/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Dimension;
import edu.jas.application.Ideal;
import edu.jas.application.IdealWithComplexRoots;
import edu.jas.application.IdealWithRealAlgebraicRoots;
import edu.jas.application.IdealWithRealRoots;
import edu.jas.application.IdealWithUniv;
import edu.jas.application.PolyUtilApp;
import edu.jas.application.PrimaryComponent;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.gb.GBFactory;
import edu.jas.gb.GroebnerBase;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import edu.jas.util.KsubSet;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class IdealTest
extends TestCase {
    TermOrder to;
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    List<? extends GenPolynomial<BigRational>> M;
    GroebnerBase<BigRational> bb;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 3;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)IdealTest.suite());
    }

    public IdealTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(IdealTest.class);
        return suite;
    }

    protected void setUp() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder();
        String[] vars = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to, vars);
        this.bb = GBFactory.getImplementation(coeff);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
        ComputerThreads.terminate();
    }

    public void testIdealSum() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        IdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"not isONE( I )", (!I2.isONE() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        I2 = new Ideal<BigRational>(this.fac, this.L, false);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"not isONE( I )", (!I2.isONE() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        this.L = this.bb.GB(this.L);
        IdealTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        I2 = new Ideal<BigRational>(this.fac, this.L, false);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        IdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        I2 = new Ideal<BigRational>(this.fac, this.L, false);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        this.L = this.bb.GB(this.L);
        IdealTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        Ideal<BigRational> J = I2;
        Ideal<BigRational> K = J.sum(I2);
        IdealTest.assertTrue((String)"not isZERO( K )", (!K.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)K.isGB());
        IdealTest.assertTrue((String)"equals( K, I )", (boolean)K.equals(I2));
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        IdealTest.assertTrue((String)"isGB( { c } )", (boolean)this.bb.isGB(this.L));
        J = new Ideal<BigRational>(this.fac, this.L, true);
        K = J.sum(I2);
        IdealTest.assertTrue((String)"not isZERO( K )", (!K.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)K.isGB());
        IdealTest.assertTrue((String)"K contains(I)", (boolean)K.contains(I2));
        IdealTest.assertTrue((String)"K contains(J)", (boolean)K.contains(J));
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        IdealTest.assertTrue((String)"isGB( { d } )", (boolean)this.bb.isGB(this.L));
        J = new Ideal<BigRational>(this.fac, this.L, true);
        I2 = K;
        K = J.sum(I2);
        IdealTest.assertTrue((String)"not isZERO( K )", (!K.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)K.isGB());
        IdealTest.assertTrue((String)"K contains(I)", (boolean)K.contains(I2));
        IdealTest.assertTrue((String)"K contains(J)", (boolean)K.contains(J));
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        IdealTest.assertTrue((String)"isGB( { e } )", (boolean)this.bb.isGB(this.L));
        J = new Ideal<BigRational>(this.fac, this.L, true);
        I2 = K;
        K = J.sum(I2);
        IdealTest.assertTrue((String)"not isZERO( K )", (!K.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)K.isGB());
        IdealTest.assertTrue((String)"equals( K, I )", (boolean)K.equals(I2));
        IdealTest.assertTrue((String)"K contains(J)", (boolean)K.contains(I2));
        IdealTest.assertTrue((String)"I contains(K)", (boolean)I2.contains(K));
    }

    public void testIdealProduct() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"not isONE( I )", (!I2.isONE() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( b )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        Ideal<BigRational> J = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( J )", (!J.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"not isONE( J )", (!J.isONE() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)J.isGB());
        Ideal<BigRational> K = I2.product(J);
        IdealTest.assertTrue((String)"not isZERO( K )", (!K.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)K.isGB());
        IdealTest.assertTrue((String)"I contains(K)", (boolean)I2.contains(K));
        IdealTest.assertTrue((String)"J contains(K)", (boolean)J.contains(K));
        Ideal<BigRational> H = I2.intersect(J);
        IdealTest.assertTrue((String)"not isZERO( H )", (!H.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( H )", (boolean)H.isGB());
        IdealTest.assertTrue((String)"I contains(H)", (boolean)I2.contains(H));
        IdealTest.assertTrue((String)"J contains(H)", (boolean)J.contains(H));
        IdealTest.assertTrue((String)"H contains(K)", (boolean)H.contains(K));
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        IdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        K = I2.product(J);
        IdealTest.assertTrue((String)"not isZERO( K )", (!K.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)K.isGB());
        IdealTest.assertTrue((String)"I contains(K)", (boolean)I2.contains(K));
        IdealTest.assertTrue((String)"J contains(K)", (boolean)J.contains(K));
        H = I2.intersect(J);
        IdealTest.assertTrue((String)"not isZERO( H )", (!H.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( H )", (boolean)H.isGB());
        IdealTest.assertTrue((String)"I contains(H)", (boolean)I2.contains(H));
        IdealTest.assertTrue((String)"J contains(H)", (boolean)J.contains(H));
        IdealTest.assertTrue((String)"H contains(K)", (boolean)H.contains(K));
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        IdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        J = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( J )", (!J.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)J.isGB());
        K = I2.product(J);
        IdealTest.assertTrue((String)"not isZERO( K )", (!K.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)K.isGB());
        IdealTest.assertTrue((String)"I contains(K)", (boolean)I2.contains(K));
        IdealTest.assertTrue((String)"J contains(K)", (boolean)J.contains(K));
        H = I2.intersect(J);
        IdealTest.assertTrue((String)"not isZERO( H )", (!H.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( H )", (boolean)H.isGB());
        IdealTest.assertTrue((String)"I contains(H)", (boolean)I2.contains(H));
        IdealTest.assertTrue((String)"J contains(H)", (boolean)J.contains(H));
        IdealTest.assertTrue((String)"H contains(K)", (boolean)H.contains(K));
    }

    public void testIdealQuotient() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( b )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        Ideal<BigRational> J = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( J )", (!J.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)J.isGB());
        Ideal<BigRational> K = I2.product(J);
        IdealTest.assertTrue((String)"not isZERO( K )", (!K.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)K.isGB());
        IdealTest.assertTrue((String)"I contains(K)", (boolean)I2.contains(K));
        IdealTest.assertTrue((String)"J contains(K)", (boolean)J.contains(K));
        Ideal<BigRational> H = K.quotient(J.getList().get(0));
        IdealTest.assertTrue((String)"not isZERO( H )", (!H.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( H )", (boolean)H.isGB());
        IdealTest.assertTrue((String)"equals(H,I)", (boolean)H.equals(I2));
        H = K.quotient(J);
        IdealTest.assertTrue((String)"not isZERO( H )", (!H.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( H )", (boolean)H.isGB());
        IdealTest.assertTrue((String)"equals(H,I)", (boolean)H.equals(I2));
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        IdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        J = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( J )", (!J.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)J.isGB());
        K = I2.product(J);
        IdealTest.assertTrue((String)"not isZERO( K )", (!K.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)K.isGB());
        IdealTest.assertTrue((String)"I contains(K)", (boolean)I2.contains(K));
        IdealTest.assertTrue((String)"J contains(K)", (boolean)J.contains(K));
        H = K.quotient(J);
        IdealTest.assertTrue((String)"not isZERO( H )", (!H.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( H )", (boolean)H.isGB());
        IdealTest.assertTrue((String)"equals(H,I)", (boolean)H.equals(I2));
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        IdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        K = I2.product(J);
        IdealTest.assertTrue((String)"not isZERO( K )", (!K.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)K.isGB());
        IdealTest.assertTrue((String)"I contains(K)", (boolean)I2.contains(K));
        IdealTest.assertTrue((String)"J contains(K)", (boolean)J.contains(K));
        H = K.quotient(J);
        IdealTest.assertTrue((String)"not isZERO( H )", (!H.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( H )", (boolean)H.isGB());
        IdealTest.assertTrue((String)"equals(H,I)", (boolean)H.equals(I2));
    }

    public void testIdealInfiniteQuotient() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        Ideal<BigRational> J = I2.infiniteQuotient(this.a);
        IdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        J = I2.infiniteQuotient(this.a);
        IdealTest.assertTrue((String)"equals(J,I)", (boolean)J.equals(I2));
        IdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        J = I2.infiniteQuotient(this.a);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)J.isGB());
        IdealTest.assertTrue((String)"equals(J,I)", (boolean)J.equals(I2));
        this.G = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.G.add(this.a);
        this.G = this.bb.GB(this.G);
        Ideal<BigRational> K = new Ideal<BigRational>(this.fac, this.G, true);
        IdealTest.assertTrue((String)"not isZERO( K )", (!K.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)K.isGB());
        J = I2.infiniteQuotient(K);
        IdealTest.assertTrue((String)"equals(J,I)", (boolean)J.equals(I2));
        IdealTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.G.add(this.e);
        this.G = this.bb.GB(this.G);
        K = new Ideal<BigRational>(this.fac, this.G, true);
        IdealTest.assertTrue((String)"not isZERO( K )", (!K.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)K.isGB());
        J = I2.infiniteQuotient(K);
        IdealTest.assertTrue((String)"equals(J,I)", (boolean)J.equals(I2));
    }

    public void testIdealInfiniteQuotientRabi() {
        this.a = this.fac.random(this.kl - 1, this.ll - 1, this.el - 1, this.q / 2.0f);
        this.b = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.c = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.d = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.e = this.a;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        Ideal<BigRational> J = I2.infiniteQuotientRab(this.a);
        Ideal<BigRational> JJ = I2.infiniteQuotient(this.a);
        IdealTest.assertTrue((String)"equals(J,JJ)", (boolean)J.equals(JJ));
        IdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        J = I2.infiniteQuotientRab(this.a);
        IdealTest.assertTrue((String)"equals(J,I)", (boolean)J.equals(I2));
        JJ = I2.infiniteQuotient(this.a);
        IdealTest.assertTrue((String)"equals(J,JJ)", (boolean)J.equals(JJ));
        IdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        J = I2.infiniteQuotientRab(this.a);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)J.isGB());
        IdealTest.assertTrue((String)"equals(J,I)", (boolean)J.equals(I2));
        JJ = I2.infiniteQuotient(this.a);
        IdealTest.assertTrue((String)"equals(J,JJ)", (boolean)J.equals(JJ));
        this.G = new ArrayList<GenPolynomial<BigRational>>();
        IdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.G.add(this.a);
        this.G = this.bb.GB(this.G);
        Ideal<BigRational> K = new Ideal<BigRational>(this.fac, this.G, true);
        IdealTest.assertTrue((String)"not isZERO( K )", (!K.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)K.isGB());
        J = I2.infiniteQuotientRab(K);
        IdealTest.assertTrue((String)"equals(J,I)", (boolean)J.equals(I2));
        JJ = I2.infiniteQuotient(this.a);
        IdealTest.assertTrue((String)"equals(J,JJ)", (boolean)J.equals(JJ));
        IdealTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.G.add(this.e);
        this.G = this.bb.GB(this.G);
        K = new Ideal<BigRational>(this.fac, this.G, true);
        IdealTest.assertTrue((String)"not isZERO( K )", (!K.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)K.isGB());
        J = I2.infiniteQuotientRab(K);
        IdealTest.assertTrue((String)"equals(J,I)", (boolean)J.equals(I2));
        JJ = I2.infiniteQuotient(this.a);
        IdealTest.assertTrue((String)"equals(J,JJ)", (boolean)J.equals(JJ));
    }

    public void testIdealRadicalMember() {
        this.a = this.fac.random(this.kl - 1, this.ll, this.el - 1, this.q);
        this.b = this.fac.random(this.kl - 1, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.d = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.e = this.a;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        if (!I2.isONE()) {
            IdealTest.assertFalse((String)"a in radical(b)", (boolean)I2.isRadicalMember(this.a));
            IdealTest.assertTrue((String)"b in radical(b)", (boolean)I2.isRadicalMember(this.b));
        }
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.b.multiply((BigRational)((Object)this.b)));
        this.L = this.bb.GB(this.L);
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        if (!I2.isONE()) {
            IdealTest.assertFalse((String)"a in radical(b*b)", (boolean)I2.isRadicalMember(this.a));
            IdealTest.assertTrue((String)"b in radical(b*b)", (boolean)I2.isRadicalMember(this.b));
        }
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        if (!I2.isONE()) {
            IdealTest.assertFalse((String)"a in radical(b*b)", (boolean)I2.isRadicalMember(this.a));
            IdealTest.assertTrue((String)"b in radical(b*b)", (boolean)I2.isRadicalMember(this.b));
        }
    }

    public void testIdealCommonZeros() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertEquals((String)"commonZeroTest( I )", (int)I2.commonZeroTest(), (int)1);
        this.a = this.fac.getZERO();
        this.L.add(this.a);
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertEquals((String)"commonZeroTest( I )", (int)I2.commonZeroTest(), (int)1);
        this.b = this.fac.getONE();
        this.L.add(this.b);
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertEquals((String)"commonZeroTest( I )", (int)I2.commonZeroTest(), (int)-1);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        if (!this.a.isZERO() && !this.a.isConstant()) {
            this.L.add(this.a);
            I2 = new Ideal<BigRational>(this.fac, this.L, true);
            IdealTest.assertEquals((String)"commonZeroTest( I )", (int)I2.commonZeroTest(), (int)1);
        }
        this.L = this.fac.univariateList();
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertEquals((String)"commonZeroTest( I )", (int)I2.commonZeroTest(), (int)0);
        this.L.remove(0);
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertEquals((String)"commonZeroTest( I )", (int)I2.commonZeroTest(), (int)1);
    }

    public void testIdealDimension() {
        Dimension dim;
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertEquals((String)"dimension( I )", (int)this.rl, (int)I2.dimension().d);
        this.a = this.fac.getZERO();
        this.L.add(this.a);
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertEquals((String)"dimension( I )", (int)this.rl, (int)I2.dimension().d);
        this.b = this.fac.getONE();
        this.L.add(this.b);
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        IdealTest.assertEquals((String)"dimension( I )", (int)-1, (int)I2.dimension().d);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        if (!this.a.isZERO() && !this.a.isConstant()) {
            this.L.add(this.a);
            I2 = new Ideal<BigRational>(this.fac, this.L, true);
            dim = I2.dimension();
            IdealTest.assertTrue((String)"dimension( I )", (dim.d >= 1 ? 1 : 0) != 0);
        }
        this.L = this.fac.univariateList();
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        dim = I2.dimension();
        IdealTest.assertEquals((String)"dimension( I )", (int)0, (int)dim.d);
        while (this.L.size() > 0) {
            this.L.remove(0);
            I2 = new Ideal<BigRational>(this.fac, this.L, true);
            dim = I2.dimension();
            IdealTest.assertEquals((String)"dimension( I )", (int)(this.rl - this.L.size()), (int)dim.d);
        }
        this.L = this.fac.univariateList();
        I2 = new Ideal<BigRational>(this.fac, this.L, true);
        I2 = I2.product(I2);
        dim = I2.dimension();
        IdealTest.assertEquals((String)"dimension( I )", (int)0, (int)dim.d);
        this.L = I2.getList();
        while (this.L.size() > 0) {
            this.L.remove(0);
            I2 = new Ideal<BigRational>(this.fac, this.L, true);
            dim = I2.dimension();
            IdealTest.assertTrue((String)"dimension( I )", (dim.d > 0 ? 1 : 0) != 0);
        }
    }

    public void testIdealTopt() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        IdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        I2.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        Object J = I2.clone();
        ((Ideal)J).doToptimize();
        IdealTest.assertTrue((String)"not isZERO( J )", (!((Ideal)J).isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)((Ideal)J).isGB());
        if (I2.isONE()) {
            return;
        }
        IdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        I2 = new Ideal<BigRational>(this.fac, this.L);
        Object K = I2.clone();
        I2.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        ((Ideal)K).doToptimize();
        ((Ideal)K).doGB();
        IdealTest.assertTrue((String)"not isZERO( K )", (!((Ideal)K).isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)((Ideal)K).isGB());
        J = I2.clone();
        ((Ideal)J).doToptimize();
        IdealTest.assertTrue((String)"not isZERO( J )", (!((Ideal)J).isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)((Ideal)J).isGB());
        if (I2.isONE()) {
            return;
        }
        IdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        I2 = new Ideal<BigRational>(this.fac, this.L);
        K = I2.clone();
        I2.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        ((Ideal)K).doToptimize();
        ((Ideal)K).doGB();
        IdealTest.assertTrue((String)"not isZERO( K )", (!((Ideal)K).isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( K )", (boolean)((Ideal)K).isGB());
        J = I2.clone();
        ((Ideal)J).doToptimize();
        IdealTest.assertTrue((String)"not isZERO( J )", (!((Ideal)J).isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( J )", (boolean)((Ideal)J).isGB());
    }

    public void testElimIdeal() {
        String[] vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.univariate(2, 3L);
        this.b = this.fac.univariate(1, 2L);
        this.c = this.fac.univariate(0, 1L);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        ArrayList<String> sv = new ArrayList<String>(vars.length);
        int i = 0;
        while (i < vars.length) {
            sv.add(vars[i]);
            ++i;
        }
        i = 0;
        while (i <= vars.length) {
            KsubSet ps = new KsubSet(sv, i);
            for (List ev : ps) {
                String[] evars = new String[ev.size()];
                int j = 0;
                while (j < ev.size()) {
                    evars[j] = (String)ev.get(j);
                    ++j;
                }
                GenPolynomialRing efac = new GenPolynomialRing(this.fac.coFac, evars.length, this.fac.tord, evars);
                Ideal<BigRational> J = I2.eliminate(efac);
                IdealTest.assertTrue((String)"isGB( J )", (boolean)J.isGB());
                IdealTest.assertTrue((String)"size( J ) <=  |ev|", (J.getList().size() <= ev.size() ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testUnivPoly() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to, vars);
        vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^3 + 34/55 x^2 + 1/9 x + 99 )");
        this.b = this.fac.parse("( y^4 - x )");
        this.c = this.fac.parse("( z^3 - x y )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        int i = 0;
        while (i < this.rl) {
            GenPolynomial<BigRational> u = I2.constructUnivariate(this.rl - 1 - i);
            Element U = this.fac.parse(u.toString());
            IdealTest.assertTrue((String)"I.contains(U) ", (boolean)I2.contains((GenPolynomial<BigRational>)U));
            ++i;
        }
        List<GenPolynomial<BigRational>> Us = I2.constructUnivariate();
        for (GenPolynomial<BigRational> u : Us) {
            Element U = this.fac.parse(u.toString());
            IdealTest.assertTrue((String)"I.contains(U) ", (boolean)I2.contains((GenPolynomial<BigRational>)U));
        }
    }

    public void testComplexRoot() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to, vars);
        vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^3 - 27 )");
        this.b = this.fac.parse("( y^2 - 9 )");
        this.c = this.fac.parse("( z - 7 )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        BigRational eps = new BigRational(1L, 1000000L);
        eps = eps.multiply(eps);
        eps = eps.multiply(eps).multiply(eps);
        BigDecimal e = new BigDecimal(eps.getRational());
        e = e.abs();
        BigDecimal dc = BigDecimal.ONE;
        GenPolynomialRing<BigDecimal> dfac = new GenPolynomialRing<BigDecimal>(dc, this.fac);
        ComplexRing<BigDecimal> dcc = new ComplexRing<BigDecimal>(dc);
        GenPolynomialRing<BigDecimal> dcfac = new GenPolynomialRing<BigDecimal>(dcc, dfac);
        List<List<Complex<BigDecimal>>> roots = PolyUtilApp.complexRootTuples(I2, eps);
        for (GenPolynomial<BigRational> p : I2.getList()) {
            GenPolynomial<BigDecimal> dp = PolyUtil.decimalFromRational(dfac, p);
            GenPolynomial<Complex<BigDecimal>> dpc = PolyUtil.toComplex(dcfac, dp);
            for (List<Complex<BigDecimal>> r : roots) {
                Complex<BigDecimal> ev = PolyUtil.evaluateAll(dcc, dcfac, dpc, r);
                if (((BigDecimal)((Complex)ev.norm()).getRe()).compareTo(e) <= 0) continue;
                IdealTest.fail((String)("ev > eps : " + ev + " > " + e));
            }
        }
    }

    public void testRealRoot() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to, vars);
        vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^3 - 27 )");
        this.b = this.fac.parse("( y^4 - x )");
        this.c = this.fac.parse("( z^2 - x^2 )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        BigRational eps = new BigRational(1L, 1000000L);
        eps = eps.multiply(eps);
        eps = eps.multiply(eps).multiply(eps);
        BigDecimal e = new BigDecimal(eps.getRational());
        e = e.abs();
        List<List<BigDecimal>> roots = PolyUtilApp.realRootTuples(I2, eps);
        BigDecimal dc = BigDecimal.ONE;
        GenPolynomialRing<BigDecimal> dfac = new GenPolynomialRing<BigDecimal>(dc, this.fac);
        for (GenPolynomial<BigRational> p : I2.getList()) {
            GenPolynomial<BigDecimal> dp = PolyUtil.decimalFromRational(dfac, p);
            for (List<BigDecimal> r : roots) {
                BigDecimal ev = PolyUtil.evaluateAll(dc, dfac, dp, r);
                if (ev.abs().compareTo(e) <= 0) continue;
                IdealTest.fail((String)("ev > eps : " + ev + " > " + e));
            }
        }
    }

    public void testZeroDimDecomp() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to, vars);
        vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^3 - 27 )");
        this.b = this.fac.parse("( y^4 - x )");
        this.c = this.fac.parse("( z^2 - x^2 )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        List zd = I2.zeroDimDecomposition();
        boolean t = I2.isZeroDimDecomposition(zd);
        IdealTest.assertTrue((String)"is decomposition ", (boolean)t);
    }

    public void testIdealRealRoot() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to, vars);
        vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^3 - 27 )");
        this.b = this.fac.parse("( y^4 - x )");
        this.c = this.fac.parse("( z^2 - x^2 )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        List zd = I2.zeroDimDecomposition();
        IdealTest.assertTrue((String)"is decomposition ", (boolean)I2.isZeroDimDecomposition(zd));
        BigRational eps = new BigRational(1L, 1000000L);
        eps = eps.multiply(eps);
        eps = eps.multiply(eps).multiply(eps);
        BigDecimal e = new BigDecimal(eps.getRational());
        e = e.abs();
        BigDecimal dc = BigDecimal.ONE;
        List roots = PolyUtilApp.realRoots(zd, eps);
        for (IdealWithRealRoots Ir : roots) {
            List L = Ir.ideal.getList();
            ArrayList<GenPolynomial<BigDecimal>> Ld = new ArrayList<GenPolynomial<BigDecimal>>(L.size());
            GenPolynomialRing<BigDecimal> dfac = new GenPolynomialRing<BigDecimal>(dc, Ir.ideal.list.ring);
            for (GenPolynomial p : L) {
                GenPolynomial<BigDecimal> dp = PolyUtil.decimalFromRational(dfac, p);
                Ld.add(dp);
            }
            boolean t = PolyUtilApp.isRealRoots(Ld, Ir.rroots, e);
            IdealTest.assertTrue((String)"isRealRoots ", (boolean)t);
        }
    }

    public void testIdealComplexRoot() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] vars = new String[]{"x", "y"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, vars.length, this.to, vars);
        vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^2 + 9 )");
        this.b = this.fac.parse("( y^2 - x )");
        this.c = this.fac.parse("( z^2 - x^2 )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        List zd = I2.zeroDimDecomposition();
        IdealTest.assertTrue((String)"is decomposition ", (boolean)I2.isZeroDimDecomposition(zd));
        BigRational eps = new BigRational(1L, 1000000L);
        eps = eps.multiply(eps).multiply(eps);
        BigDecimal e = new BigDecimal(eps.getRational());
        e = e.abs();
        List roots = PolyUtilApp.complexRoots(zd, eps);
        ComplexRing<BigDecimal> dcc = new ComplexRing<BigDecimal>(e);
        GenPolynomialRing<BigDecimal> dcfac = new GenPolynomialRing<BigDecimal>(dcc, this.fac);
        for (IdealWithComplexRoots Ic : roots) {
            List L = Ic.ideal.getList();
            ArrayList<GenPolynomial<Complex<BigDecimal>>> Ld = new ArrayList<GenPolynomial<Complex<BigDecimal>>>(L.size());
            GenPolynomialRing<BigDecimal> dfac = new GenPolynomialRing<BigDecimal>(e, Ic.ideal.list.ring);
            for (GenPolynomial p : L) {
                GenPolynomial<BigDecimal> dp = PolyUtil.decimalFromRational(dfac, p);
                GenPolynomial<Complex<BigDecimal>> dpc = PolyUtil.toComplex(dcfac, dp);
                Ld.add(dpc);
            }
            boolean t = PolyUtilApp.isComplexRoots(Ld, Ic.croots, e);
            if (!t) continue;
            IdealTest.assertTrue((String)"isComplexRoots ", (boolean)t);
        }
    }

    public void testNormalPosition() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to, vars);
        vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^3 - 27 )");
        this.b = this.fac.parse("( y^3 - x )");
        this.c = this.fac.parse("( z^2 - x^2 )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        I2.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        int[] np = I2.normalPositionIndex2Vars();
        if (np == null) {
            np = I2.normalPositionIndexUnivars();
        }
        if (np == null) {
            return;
        }
        int i = np[0];
        int j = np[1];
        IdealWithUniv<BigRational> Ip = I2.normalPositionFor(i, j, null);
        boolean t = Ip.ideal.isNormalPositionFor(i + 1, j + 1);
        IdealTest.assertTrue((String)"is normal position ", (boolean)t);
        np = Ip.ideal.normalPositionIndex2Vars();
        if (np == null) {
            np = Ip.ideal.normalPositionIndexUnivars();
        }
        if (np == null) {
            return;
        }
        i = np[0];
        j = np[1];
        IdealTest.assertTrue((String)"i == 0", (i == 0 ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"j == 3", (j == 3 ? 1 : 0) != 0);
    }

    public void testRootDecomposition() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to, vars);
        vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^2 - 7 )");
        this.b = this.fac.parse("( y^2 - 5 )");
        this.c = this.fac.parse("( z^3 - x * y )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        I2.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        List rzd = I2.zeroDimRootDecomposition();
        IdealTest.assertTrue((String)"is contained in intersection ", (boolean)I2.isZeroDimDecomposition(rzd));
    }

    public void testPrimeDecomposition() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to, vars);
        vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^2 - 5 )^2 ");
        this.b = this.fac.parse("( y^2 - 5 )");
        this.c = this.fac.parse("( z^3 - x )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        I2.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        List pzd = I2.zeroDimPrimeDecomposition();
        IdealTest.assertTrue((String)"is contained in intersection ", (boolean)I2.isZeroDimDecomposition(pzd));
    }

    public void testPrimaryDecomposition() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to, vars);
        vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^2 - 5 )^2 ");
        this.b = this.fac.parse("( y^2 - 5 )");
        this.c = this.fac.parse("( z^3 - x )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        I2.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        List qzd = I2.zeroDimPrimaryDecomposition();
        IdealTest.assertTrue((String)"is intersection ", (boolean)I2.isPrimaryDecomposition(qzd));
    }

    public void testRootDecompositionReal() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to, vars);
        vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^2 - 5 )");
        this.b = this.fac.parse("( y^2 - 7 )");
        this.c = this.fac.parse("( z^3 - x * y )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        I2.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        List iur = PolyUtilApp.realAlgebraicRoots(I2);
        ArrayList iul = new ArrayList();
        for (IdealWithRealAlgebraicRoots iu : iur) {
            iul.add(iu);
        }
        IdealTest.assertTrue((String)"is contained in intersection ", (boolean)I2.isZeroDimDecomposition(iul));
        for (IdealWithRealAlgebraicRoots iu : iur) {
            List<List<BigDecimal>> list = iu.decimalApproximation();
        }
    }

    public void testExtCont() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder();
        String[] vars = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to, vars);
        vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( y + x y^2 ) ");
        this.b = this.fac.parse("( x z + x^2 y ) ");
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        I2.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        IdealWithUniv Ext = I2.extension("x");
        IdealWithUniv<BigRational> Con = I2.permContraction(Ext);
        IdealTest.assertTrue((String)"I subseteq Con(Ext(I)) ", (boolean)Con.ideal.contains(I2));
    }

    public void testPrimeDecomp() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to, vars);
        vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( z^2 - x ) ");
        this.b = this.fac.parse("( y^2 - x ) ");
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        I2.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        List pdec = I2.primeDecomposition();
        IdealTest.assertTrue((String)"I subseteq cup G_i ", (boolean)I2.isDecomposition(pdec));
        ArrayList dec = new ArrayList(pdec.size());
        for (IdealWithUniv pu : pdec) {
            dec.add(pu.ideal);
        }
        Ideal<BigRational> Ii = I2.intersect(dec);
        IdealTest.assertTrue((String)"I == Ii ", (boolean)I2.equals(Ii));
    }

    public void testRadicalDecomp() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to, vars);
        vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^2 + 2 x y z + z^4 ) ");
        this.b = this.fac.parse("( y z - z^2 ) ");
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        I2.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        List rdec = I2.radicalDecomposition();
        IdealTest.assertTrue((String)"I subseteq cup G_i ", (boolean)I2.isDecomposition(rdec));
        ArrayList dec = new ArrayList(rdec.size());
        for (IdealWithUniv ru : rdec) {
            dec.add(ru.ideal);
        }
        Ideal<BigRational> Ii = I2.intersect(dec);
        IdealTest.assertTrue((String)"Ii.contains(I) ", (boolean)Ii.contains(I2));
    }

    public void testIrredDecomp() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to, vars);
        vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x^2 + 2 x y z + z^4 ) ");
        this.b = this.fac.parse("( y z - z^2 ) ");
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        I2.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        List rdec = I2.decomposition();
        IdealTest.assertTrue((String)"I subseteq cup G_i ", (boolean)I2.isDecomposition(rdec));
        ArrayList dec = new ArrayList(rdec.size());
        for (IdealWithUniv ru : rdec) {
            dec.add(ru.ideal);
        }
        Ideal<BigRational> Ii = I2.intersect(dec);
        IdealTest.assertTrue((String)"Ii.contains(I) ", (boolean)Ii.contains(I2));
    }

    public void testPrimaryDecomp() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] vars = new String[]{"x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to, vars);
        vars = this.fac.getVars();
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("( x z^2 - 1 )^2 ");
        this.b = this.fac.parse("( y^2 - x ) ");
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        Ideal<BigRational> I2 = new Ideal<BigRational>(this.fac, this.L);
        I2.doGB();
        IdealTest.assertTrue((String)"not isZERO( I )", (!I2.isZERO() ? 1 : 0) != 0);
        IdealTest.assertTrue((String)"isGB( I )", (boolean)I2.isGB());
        List qdec = I2.primaryDecomposition();
        ArrayList dec = new ArrayList(qdec.size());
        for (PrimaryComponent<BigRational> primaryComponent : qdec) {
            dec.add(primaryComponent.primary);
        }
        IdealTest.assertTrue((String)"I eq cup G_i ", (boolean)I2.isPrimaryDecomposition(qdec));
    }
}

