/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.LocalRing;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import org.apache.log4j.Logger;

public class Local<C extends GcdRingElem<C>>
implements RingElem<Local<C>> {
    private static final Logger logger = Logger.getLogger(Local.class);
    private boolean debug = logger.isDebugEnabled();
    public final LocalRing<C> ring;
    protected final GenPolynomial<C> num;
    protected final GenPolynomial<C> den;
    protected int isunit = -1;

    public Local(LocalRing<C> r) {
        this(r, (GenPolynomial<C>)r.ring.getZERO());
    }

    public Local(LocalRing<C> r, GenPolynomial<C> n) {
        this(r, n, (GenPolynomial<C>)r.ring.getONE(), true);
    }

    public Local(LocalRing<C> r, GenPolynomial<C> n, GenPolynomial<C> d) {
        this(r, n, d, false);
    }

    protected Local(LocalRing<C> r, GenPolynomial<C> n, GenPolynomial<C> d, boolean isred) {
        if (d == null || ((GenPolynomial)d).isZERO()) {
            throw new IllegalArgumentException("denominator may not be zero");
        }
        this.ring = r;
        if (((GenPolynomial)d).signum() < 0) {
            n = ((GenPolynomial)n).negate();
            d = ((GenPolynomial)d).negate();
        }
        if (isred) {
            this.num = n;
            this.den = d;
            return;
        }
        GenPolynomial p = this.ring.ideal.normalform((GenPolynomial<GenPolynomial<C>>)d);
        if (p == null || p.isZERO()) {
            throw new IllegalArgumentException("denominator may not be in ideal");
        }
        GenPolynomial<C> gcd = this.gcd((GenPolynomial<C>)n, (GenPolynomial<C>)d);
        logger.info((Object)("gcd = " + gcd));
        if (gcd.isONE()) {
            this.num = n;
            this.den = d;
        } else {
            this.num = ((GenPolynomial)n).divide(gcd);
            this.den = ((GenPolynomial)d).divide(gcd);
        }
    }

    protected GenPolynomial<C> lcm(GenPolynomial<C> n, GenPolynomial<C> d) {
        GenPolynomial lcm = this.ring.engine.lcm(n, d);
        return lcm;
    }

    protected GenPolynomial<C> gcd(GenPolynomial<C> n, GenPolynomial<C> d) {
        if (n.isZERO()) {
            return d;
        }
        if (d.isZERO()) {
            return n;
        }
        if (n.isONE()) {
            return n;
        }
        if (d.isONE()) {
            return d;
        }
        GenPolynomial gcd = this.ring.engine.gcd(n, d);
        return gcd;
    }

    @Override
    public LocalRing<C> factory() {
        return this.ring;
    }

    public Local<C> clone() {
        return new Local<C>(this.ring, this.num, this.den, true);
    }

    @Override
    public boolean isZERO() {
        return this.num.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.num.equals(this.den);
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        if (this.num.isZERO()) {
            this.isunit = 0;
            return false;
        }
        GenPolynomial p = this.ring.ideal.normalform(this.num);
        boolean u = p != null && !p.isZERO();
        this.isunit = u ? 1 : 0;
        return u;
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            String s = "{ " + this.num.toString(this.ring.ring.getVars());
            if (this.den.isONE()) {
                return String.valueOf(s) + " }";
            }
            return String.valueOf(s) + "| " + this.den.toString(this.ring.ring.getVars()) + " }";
        }
        return "Local[ " + this.num.toString() + " | " + this.den.toString() + " ]";
    }

    @Override
    public String toScript() {
        if (this.den.isONE()) {
            return this.num.toScript();
        }
        return String.valueOf(this.num.toScript()) + " / " + this.den.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((LocalRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(Local<C> b) {
        if (b == null || b.isZERO()) {
            return this.signum();
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> r = this.num.multiply(b.den);
        GenPolynomial<GenPolynomial<C>> s = this.den.multiply(b.num);
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> x = r.subtract((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)s);
        return x.signum();
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof Local)) {
            return false;
        }
        Local a = null;
        try {
            a = (Local)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.compareTo(a) == 0;
    }

    @Override
    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + this.num.hashCode();
        h = 37 * h + this.den.hashCode();
        return h;
    }

    @Override
    public Local<C> abs() {
        return new Local<C>(this.ring, this.num.abs(), this.den, true);
    }

    @Override
    public Local<C> sum(Local<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> n = this.num.multiply(S.den);
        n = n.sum((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)this.den.multiply(S.num));
        GenPolynomial<GenPolynomial<C>> d = this.den.multiply(S.den);
        return new Local<GenPolynomial<C>>(this.ring, n, d, false);
    }

    @Override
    public Local<C> negate() {
        return new Local<C>(this.ring, this.num.negate(), this.den, true);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public Local<C> subtract(Local<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> n = this.num.multiply(S.den);
        n = n.subtract((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)this.den.multiply(S.num));
        GenPolynomial<GenPolynomial<C>> d = this.den.multiply(S.den);
        return new Local<GenPolynomial<C>>(this.ring, n, d, false);
    }

    @Override
    public Local<C> divide(Local<C> S) {
        return this.multiply((Local<C>)S.inverse());
    }

    @Override
    public Local<C> inverse() {
        if (this.isONE()) {
            return this;
        }
        if (this.isUnit()) {
            return new Local<C>(this.ring, this.den, this.num, true);
        }
        throw new ArithmeticException("element not invertible " + this);
    }

    @Override
    public Local<C> remainder(Local<C> S) {
        if (this.num.isZERO()) {
            throw new ArithmeticException("element not invertible " + this);
        }
        if (S.isUnit()) {
            return this.ring.getZERO();
        }
        throw new UnsupportedOperationException("remainder not implemented" + S);
    }

    @Override
    public Local<C> multiply(Local<C> S) {
        if (S == null || S.isZERO()) {
            return S;
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (S.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return S;
        }
        GenPolynomial<GenPolynomial<C>> n = this.num.multiply(S.num);
        GenPolynomial<GenPolynomial<C>> d = this.den.multiply(S.den);
        return new Local<GenPolynomial<C>>(this.ring, n, d, false);
    }

    public Local<C> monic() {
        if (this.num.isZERO()) {
            return this;
        }
        GcdRingElem lbc = (GcdRingElem)this.num.leadingBaseCoefficient();
        lbc = (GcdRingElem)lbc.inverse();
        GenPolynomial<GcdRingElem> n = this.num.multiply(lbc);
        GenPolynomial<GcdRingElem> d = this.den.multiply(lbc);
        return new Local<GcdRingElem>(this.ring, n, d, true);
    }

    @Override
    public Local<C> gcd(Local<C> b) {
        GenPolynomial x = this.ring.engine.gcd(this.num, b.num);
        GenPolynomial y = this.ring.engine.gcd(this.den, b.den);
        return new Local<C>(this.ring, x, y, true);
    }

    public Local<C>[] egcd(Local<C> b) {
        throw new UnsupportedOperationException("egcd not implemented " + this.getClass().getName());
    }
}

