/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.Local;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisor;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class LocalRing<C extends GcdRingElem<C>>
implements RingFactory<Local<C>> {
    private static final Logger logger = Logger.getLogger(LocalRing.class);
    protected final GreatestCommonDivisor<C> engine;
    public final Ideal<C> ideal;
    public final GenPolynomialRing<C> ring;
    protected int isField = -1;

    public LocalRing(Ideal<C> i) {
        if (i == null) {
            throw new IllegalArgumentException("ideal may not be null");
        }
        this.ideal = i.GB();
        if (this.ideal.isONE()) {
            throw new IllegalArgumentException("ideal may not be 1");
        }
        if (!this.ideal.isMaximal()) {
            logger.warn((Object)"ideal not maximal");
        }
        this.ring = this.ideal.list.ring;
        this.engine = GCDFactory.getProxy(this.ring.coFac);
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public Local<C> copy(Local<C> c) {
        return new Local(c.ring, c.num, c.den, true);
    }

    @Override
    public Local<C> getZERO() {
        return new Local(this, this.ring.getZERO());
    }

    @Override
    public Local<C> getONE() {
        return new Local(this, this.ring.getONE());
    }

    @Override
    public List<Local<C>> generators() {
        List<GenPolynomial<C>> pgens = this.ring.generators();
        ArrayList<Local<C>> gens = new ArrayList<Local<C>>(pgens.size());
        for (GenPolynomial<C> p : pgens) {
            Local<C> q = new Local<C>(this, p);
            gens.add(q);
        }
        return gens;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public Local<C> fromInteger(BigInteger a) {
        return new Local(this, this.ring.fromInteger(a));
    }

    @Override
    public Local<C> fromInteger(long a) {
        return new Local(this, this.ring.fromInteger(a));
    }

    public String toString() {
        return "Local[ " + this.ideal.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "LC(" + this.ideal.list.toScript() + ")";
    }

    public boolean equals(Object b) {
        if (!(b instanceof LocalRing)) {
            return false;
        }
        LocalRing a = null;
        try {
            a = (LocalRing)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        if (!this.ring.equals(a.ring)) {
            return false;
        }
        return this.ideal.equals(a.ideal);
    }

    public int hashCode() {
        int h = this.ideal.hashCode();
        return h;
    }

    @Override
    public Local<C> random(int n) {
        GenPolynomial r = ((GenPolynomial)this.ring.random(n)).monic();
        GenPolynomial s = ((GenPolynomial)this.ring.random(n)).monic();
        s = this.ideal.normalform(s);
        while (s.isZERO()) {
            logger.info((Object)"s was in ideal");
            s = ((GenPolynomial)this.ring.random(n)).monic();
            s = this.ideal.normalform(s);
        }
        return new Local(this, r, s, false);
    }

    public Local<C> random(int k, int l, int d, float q) {
        GenPolynomial<C> r = this.ring.random(k, l, d, q).monic();
        GenPolynomial<C> s = this.ring.random(k, l, d, q).monic();
        s = this.ideal.normalform(s);
        while (s.isZERO()) {
            logger.info((Object)("s was in ideal " + this.ideal));
            s = this.ring.random(k, l, d, q).monic();
            s = this.ideal.normalform(s);
        }
        return new Local<C>(this, r, s, false);
    }

    @Override
    public Local<C> random(int n, Random rnd) {
        GenPolynomial r = ((GenPolynomial)this.ring.random(n, rnd)).monic();
        GenPolynomial s = ((GenPolynomial)this.ring.random(n, rnd)).monic();
        s = this.ideal.normalform(s);
        while (s.isZERO()) {
            logger.info((Object)"s was in ideal");
            s = ((GenPolynomial)this.ring.random(n, rnd)).monic();
            s = this.ideal.normalform(s);
        }
        return new Local(this, r, s, false);
    }

    @Override
    public Local<C> parse(String s) {
        Element x = this.ring.parse(s);
        return new Local(this, x);
    }

    @Override
    public Local<C> parse(Reader r) {
        Element x = this.ring.parse(r);
        return new Local(this, x);
    }
}

