/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.Local;
import edu.jas.application.LocalRing;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LocalTest
extends TestCase {
    Ideal<BigRational> id;
    LocalRing<BigRational> fac;
    GenPolynomialRing<BigRational> mfac;
    List<GenPolynomial<BigRational>> F;
    Local<BigRational> a;
    Local<BigRational> b;
    Local<BigRational> c;
    Local<BigRational> d;
    Local<BigRational> e;
    int rl = 3;
    int kl = 3;
    int ll = 5;
    int el = 2;
    float q = 0.3f;
    int il = 2;

    public static void main(String[] args) {
        TestRunner.run((Test)LocalTest.suite());
    }

    public LocalTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(LocalTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        BigRational cfac = new BigRational(1L);
        String[] vars = new String[]{"x", "y", "z"};
        this.mfac = new GenPolynomialRing<BigRational>(cfac, this.rl, vars);
        this.id = null;
        while (this.id == null || this.id.isONE()) {
            this.F = new ArrayList<GenPolynomial<BigRational>>(this.il);
            int i = 0;
            while (i < this.rl) {
                GenPolynomial<BigRational> mo = this.mfac.univariate(i);
                mo = mo.sum((BigRational)this.mfac.fromInteger(cfac.random(7).denominator()));
                while (mo.isConstant()) {
                    mo = this.mfac.random(this.kl, this.ll, this.el, this.q);
                }
                this.F.add(mo);
                ++i;
            }
            this.id = new Ideal<BigRational>(this.mfac, this.F);
            this.id = this.id.GB();
        }
        this.fac = new LocalRing<BigRational>(this.id);
        this.F = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.id = null;
        this.mfac = null;
        ComputerThreads.terminate();
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        LocalTest.assertTrue((String)"length( c ) = 1", (this.c.num.length() == 1 ? 1 : 0) != 0);
        LocalTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        LocalTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        LocalTest.assertTrue((String)"length( d ) = 0", (this.d.num.length() == 0 ? 1 : 0) != 0);
        LocalTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        LocalTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        int i = 0;
        while (i < 4) {
            this.a = this.fac.random(this.kl * (i + 1), this.ll + i, this.el, this.q);
            LocalTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.num.length() >= 0 ? 1 : 0) != 0);
            if (!this.a.isZERO() && !this.a.isONE()) {
                LocalTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
                LocalTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        LocalTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        LocalTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        LocalTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((Local<BigRational>)this.fac.getZERO());
        this.d = this.a.subtract((Local<BigRational>)this.fac.getZERO());
        LocalTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((Local)this.fac.getZERO()).sum(this.a);
        this.d = ((Local)this.fac.getZERO()).subtract(this.a.negate());
        LocalTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        LocalTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        LocalTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        LocalTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        LocalTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        LocalTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        LocalTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        LocalTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        LocalTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        LocalTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((Local<BigRational>)this.fac.getONE());
        this.d = ((Local)this.fac.getONE()).multiply(this.a);
        LocalTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        if (this.a.isUnit()) {
            this.c = this.a.inverse();
            this.d = this.c.multiply(this.a);
            LocalTest.assertTrue((String)"a*1/a = 1", (boolean)this.d.isONE());
            this.d = this.c.inverse();
            LocalTest.assertTrue((String)"1/(1/a) = a", (boolean)this.d.equals(this.a));
        }
    }
}

