/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.MultiplicativeSet;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MultiplicativeSetFactors<C extends GcdRingElem<C>>
extends MultiplicativeSet<C> {
    private static final Logger logger = Logger.getLogger(MultiplicativeSetFactors.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final FactorAbstract<C> engine;

    public MultiplicativeSetFactors(GenPolynomialRing<C> ring) {
        super(ring);
        this.engine = FactorFactory.getImplementation(ring.coFac);
    }

    protected MultiplicativeSetFactors(GenPolynomialRing<C> ring, List<GenPolynomial<C>> ms, FactorAbstract<C> eng) {
        super(ring, ms);
        this.engine = eng;
    }

    @Override
    public String toString() {
        return "MultiplicativeSetFactors" + this.mset;
    }

    @Override
    public MultiplicativeSetFactors<C> add(GenPolynomial<C> cc) {
        GenPolynomial<C> c;
        if (cc == null || cc.isZERO() || cc.isConstant()) {
            return this;
        }
        if (this.ring.coFac.isField()) {
            cc = cc.monic();
        }
        if ((c = this.removeFactors(cc)).isConstant()) {
            logger.info((Object)("skipped unit or constant = " + c));
            return this;
        }
        List<GenPolynomial<C>> list = this.engine.factorsRadical(c);
        logger.info((Object)("factorsRadical = " + list));
        if (this.ring.coFac.isField()) {
            list = PolyUtil.monic(list);
        }
        ArrayList<GenPolynomial<C>> ms = new ArrayList<GenPolynomial<C>>(this.mset);
        for (GenPolynomial<C> p : list) {
            if (p.isConstant() || p.isZERO() || this.mset.contains(p)) continue;
            logger.info((Object)("added to irreducible mset = " + p));
            ms.add(p);
        }
        return new MultiplicativeSetFactors<C>(this.ring, ms, this.engine);
    }

    @Override
    public MultiplicativeSetFactors<C> replace(List<GenPolynomial<C>> L) {
        MultiplicativeSet ms = new MultiplicativeSetFactors<C>(this.ring);
        if (L == null || L.size() == 0) {
            return ms;
        }
        for (GenPolynomial<C> p : L) {
            ms = ms.add((GenPolynomial)p);
        }
        return ms;
    }
}

