/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.MultiplicativeSet;
import edu.jas.application.MultiplicativeSetCoPrime;
import edu.jas.application.MultiplicativeSetFactors;
import edu.jas.application.MultiplicativeSetSquarefree;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class MultiplicativeSetTest
extends TestCase {
    TermOrder to;
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    List<? extends GenPolynomial<BigRational>> M;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 3;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)MultiplicativeSetTest.suite());
    }

    public MultiplicativeSetTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(MultiplicativeSetTest.class);
        return suite;
    }

    protected void setUp() {
        BigRational coeff = new BigRational(17L, 1L);
        this.to = new TermOrder();
        this.fac = new GenPolynomialRing<BigRational>(coeff, this.rl, this.to);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        ComputerThreads.terminate();
    }

    public void testContaines() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        MultiplicativeSet<BigRational> ms = new MultiplicativeSet<BigRational>(this.fac);
        MultiplicativeSetTest.assertTrue((String)"isEmpty ", (boolean)ms.isEmpty());
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not contained ", (boolean)ms.contains(this.a));
        }
        MultiplicativeSet<BigRational> ms2 = ms.add(this.a);
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)ms2.isEmpty());
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms2.contains(this.a));
        }
        if (!this.a.equals(this.b) && !this.b.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not contained ", (boolean)ms2.contains(this.b));
        }
        MultiplicativeSet<BigRational> ms3 = ms2.add(this.b);
        if (!this.b.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)ms3.isEmpty());
        }
        MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms3.contains(this.a));
        MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms3.contains(this.b));
        if (!(this.a.equals(this.c) || this.b.equals(this.c) || this.c.isConstant())) {
            MultiplicativeSetTest.assertFalse((String)"not contained ", (boolean)ms3.contains(this.c));
        }
        this.e = this.a.multiply((BigRational)((Object)this.b));
        if (!this.e.isConstant()) {
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms3.contains(this.e));
        }
        MultiplicativeSet<BigRational> ms4 = ms3.add(this.e);
        MultiplicativeSetTest.assertTrue((String)"m3 == m4 ", (boolean)ms3.equals(ms4));
    }

    public void testRemoveFactors() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        MultiplicativeSet<BigRational> ms = new MultiplicativeSet<BigRational>(this.fac);
        MultiplicativeSetTest.assertTrue((String)"isEmpty ", (boolean)ms.isEmpty());
        this.e = ms.removeFactors(this.a);
        MultiplicativeSetTest.assertEquals((String)"a == remove(a) ", this.a, this.e);
        MultiplicativeSet<BigRational> ms2 = ms.add(this.a);
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)ms2.isEmpty());
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms2.contains(this.a));
            this.e = ms2.removeFactors(this.a);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a) ", (boolean)this.e.isConstant());
            if (!this.b.isConstant()) {
                this.e = ms2.removeFactors(this.b);
                MultiplicativeSetTest.assertEquals((String)"b == remove(b) ", this.e, this.b);
            }
        }
        this.d = this.a.multiply((BigRational)((Object)this.b));
        MultiplicativeSet<BigRational> ms3 = ms2.add(this.d);
        if (!this.d.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)ms3.isEmpty());
            this.e = ms3.removeFactors(this.a);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a) ", (boolean)this.e.isConstant());
            this.e = ms3.removeFactors(this.b);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(b) ", (boolean)this.e.isConstant());
            this.e = ms3.removeFactors(this.d);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a*b) ", (boolean)this.e.isConstant());
            if (!this.c.isConstant()) {
                this.e = ms3.removeFactors(this.c);
                MultiplicativeSetTest.assertEquals((String)"c == remove(c) ", this.e, this.c);
            }
        }
    }

    public void testCoPrimeContaines() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        MultiplicativeSetCoPrime<BigRational> ms = new MultiplicativeSetCoPrime<BigRational>(this.fac);
        MultiplicativeSetTest.assertTrue((String)"isEmpty ", (boolean)ms.isEmpty());
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not contained ", (boolean)ms.contains(this.a));
        }
        MultiplicativeSet<BigRational> ms2 = ((MultiplicativeSet)ms).add(this.a);
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)ms2.isEmpty());
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms2.contains(this.a));
        }
        if (!this.a.equals(this.b) && !this.b.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)("not contained " + ms2), (boolean)ms2.contains(this.b));
        }
        MultiplicativeSet<BigRational> ms3 = ms2.add(this.b);
        if (!this.b.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)ms3.isEmpty());
        }
        MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms3.contains(this.a));
        MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms3.contains(this.b));
        if (!(this.a.equals(this.c) || this.b.equals(this.c) || this.c.isConstant())) {
            MultiplicativeSetTest.assertFalse((String)("not contained " + ms3), (boolean)ms3.contains(this.c));
        }
        this.e = this.a.multiply((BigRational)((Object)this.b));
        if (!this.e.isConstant()) {
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms3.contains(this.e));
        }
        MultiplicativeSet<BigRational> ms4 = ms3.add(this.e);
        MultiplicativeSetTest.assertTrue((String)"m3 == m4 ", (boolean)ms3.equals(ms4));
    }

    public void testCoPrimeRemoveFactors() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        MultiplicativeSetCoPrime<BigRational> ms = new MultiplicativeSetCoPrime<BigRational>(this.fac);
        MultiplicativeSetTest.assertTrue((String)"isEmpty ", (boolean)ms.isEmpty());
        this.e = ms.removeFactors(this.a);
        MultiplicativeSetTest.assertEquals((String)"a == remove(a) ", this.a, this.e);
        MultiplicativeSet<BigRational> ms2 = ((MultiplicativeSet)ms).add(this.a);
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)ms2.isEmpty());
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms2.contains(this.a));
            this.e = ms2.removeFactors(this.a);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a) ", (boolean)this.e.isConstant());
            if (!this.b.isConstant()) {
                this.e = ms2.removeFactors(this.b);
                MultiplicativeSetTest.assertEquals((String)"b == remove(b) ", this.e, this.b);
            }
        }
        this.d = this.a.multiply((BigRational)((Object)this.b));
        MultiplicativeSet<BigRational> ms3 = ms2.add(this.d);
        if (!this.d.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)ms3.isEmpty());
            this.e = ms3.removeFactors(this.a);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a) ", (boolean)this.e.isConstant());
            this.e = ms3.removeFactors(this.b);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(b) ", (boolean)this.e.isConstant());
            this.e = ms3.removeFactors(this.d);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a*b) ", (boolean)this.e.isConstant());
            if (!this.c.isConstant()) {
                this.e = ms3.removeFactors(this.c);
                MultiplicativeSetTest.assertEquals((String)"c == remove(c) ", this.e, this.c);
            }
        }
    }

    public void testSquarefreeContaines() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        MultiplicativeSetSquarefree<BigRational> ms = new MultiplicativeSetSquarefree<BigRational>(this.fac);
        MultiplicativeSetTest.assertTrue((String)"isEmpty ", (boolean)ms.isEmpty());
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not contained ", (boolean)ms.contains(this.a));
        }
        MultiplicativeSet<BigRational> ms2 = ((MultiplicativeSet)ms).add(this.a);
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)ms2.isEmpty());
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms2.contains(this.a));
        }
        if (!this.a.equals(this.b) && !this.b.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)("not contained " + ms2), (boolean)ms2.contains(this.b));
        }
        MultiplicativeSet<BigRational> ms3 = ms2.add(this.b);
        if (!this.b.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)ms3.isEmpty());
        }
        MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms3.contains(this.a));
        MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms3.contains(this.b));
        if (!(this.a.equals(this.c) || this.b.equals(this.c) || this.c.isConstant())) {
            MultiplicativeSetTest.assertFalse((String)("not contained " + ms3), (boolean)ms3.contains(this.c));
        }
        this.e = this.a.multiply((BigRational)((Object)this.b));
        if (!this.e.isConstant()) {
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms3.contains(this.e));
        }
        MultiplicativeSet<BigRational> ms4 = ms3.add(this.e);
        MultiplicativeSetTest.assertTrue((String)"m3 == m4 ", (boolean)ms3.equals(ms4));
    }

    public void testSquarefreeRemoveFactors() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        MultiplicativeSetSquarefree<BigRational> ms = new MultiplicativeSetSquarefree<BigRational>(this.fac);
        MultiplicativeSetTest.assertTrue((String)"isEmpty ", (boolean)ms.isEmpty());
        this.e = ms.removeFactors(this.a);
        MultiplicativeSetTest.assertEquals((String)"a == remove(a) ", this.a, this.e);
        MultiplicativeSet<BigRational> ms2 = ((MultiplicativeSet)ms).add(this.a);
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)ms2.isEmpty());
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms2.contains(this.a));
            this.e = ms2.removeFactors(this.a);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a) ", (boolean)this.e.isConstant());
            if (!this.b.isConstant()) {
                this.e = ms2.removeFactors(this.b);
                MultiplicativeSetTest.assertEquals((String)"b == remove(b) ", this.e, this.b);
            }
        }
        this.d = this.a.multiply((BigRational)((Object)this.b));
        MultiplicativeSet<BigRational> ms3 = ms2.add(this.d);
        if (!this.d.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)ms3.isEmpty());
            this.e = ms3.removeFactors(this.a);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a) ", (boolean)this.e.isConstant());
            this.e = ms3.removeFactors(this.b);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(b) ", (boolean)this.e.isConstant());
            this.e = ms3.removeFactors(this.d);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a*b) ", (boolean)this.e.isConstant());
            if (!this.c.isConstant()) {
                this.e = ms3.removeFactors(this.c);
                MultiplicativeSetTest.assertEquals((String)"c == remove(c) ", this.e, this.c);
            }
        }
    }

    public void testFactorsContaines() {
        this.a = this.fac.random(this.kl - 2, this.ll - 2, this.el, this.q);
        this.b = this.fac.random(this.kl - 2, this.ll - 2, this.el, this.q);
        this.c = this.fac.random(this.kl - 2, this.ll - 2, this.el, this.q).monic();
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        MultiplicativeSetFactors<BigRational> ms = new MultiplicativeSetFactors<BigRational>(this.fac);
        MultiplicativeSetTest.assertTrue((String)"isEmpty ", (boolean)ms.isEmpty());
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not contained ", (boolean)ms.contains(this.a));
        }
        MultiplicativeSet<BigRational> ms2 = ((MultiplicativeSet)ms).add(this.a);
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)ms2.isEmpty());
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms2.contains(this.a));
            if (!this.a.equals(this.b) && !this.b.isConstant()) {
                MultiplicativeSetTest.assertFalse((String)("not contained " + ms2 + ", " + this.b), (boolean)ms2.contains(this.b));
            }
        }
        MultiplicativeSet<BigRational> ms3 = ms2.add(this.b);
        MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms3.contains(this.a));
        MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms3.contains(this.b));
        if (!this.b.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)ms3.isEmpty());
            if (!(this.a.monic().equals(this.c) || this.b.monic().equals(this.c) || this.c.isConstant())) {
                MultiplicativeSetTest.assertFalse((String)("not contained " + ms3 + ", " + this.c), (boolean)ms3.contains(this.c));
            }
        }
        this.e = this.a.multiply((BigRational)((Object)this.b));
        if (!this.e.isConstant()) {
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms3.contains(this.e));
        }
        MultiplicativeSet<BigRational> ms4 = ms3.add(this.e);
        MultiplicativeSetTest.assertTrue((String)"m3 == m4 ", (boolean)ms3.equals(ms4));
    }

    public void testFactorsRemoveFactors() {
        this.a = this.fac.random(this.kl - 2, this.ll - 2, this.el, this.q);
        this.b = this.fac.random(this.kl - 2, this.ll - 2, this.el, this.q);
        this.c = this.fac.random(this.kl - 2, this.ll - 2, this.el, this.q);
        this.d = this.fac.random(this.kl - 2, this.ll - 2, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        MultiplicativeSetFactors<BigRational> ms = new MultiplicativeSetFactors<BigRational>(this.fac);
        MultiplicativeSetTest.assertTrue((String)"isEmpty ", (boolean)ms.isEmpty());
        this.e = ms.removeFactors(this.a);
        MultiplicativeSetTest.assertEquals((String)"a == remove(a) ", this.a, this.e);
        MultiplicativeSet<BigRational> ms2 = ((MultiplicativeSet)ms).add(this.a);
        if (!this.a.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)ms2.isEmpty());
            MultiplicativeSetTest.assertTrue((String)"contained ", (boolean)ms2.contains(this.a));
            this.e = ms2.removeFactors(this.a);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a) ", (boolean)this.e.isConstant());
            if (!this.b.isConstant()) {
                this.e = ms2.removeFactors(this.b);
                MultiplicativeSetTest.assertTrue((String)"remove(b) | b ", (boolean)this.b.remainder(this.e).isZERO());
            }
        }
        this.d = this.a.multiply((BigRational)((Object)this.b));
        MultiplicativeSet<BigRational> ms3 = ms2.add(this.d);
        if (!this.d.isConstant()) {
            MultiplicativeSetTest.assertFalse((String)"not isEmpty ", (boolean)ms3.isEmpty());
            this.e = ms3.removeFactors(this.a);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a) ", (boolean)this.e.isConstant());
            this.e = ms3.removeFactors(this.b);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(b) ", (boolean)this.e.isConstant());
            this.e = ms3.removeFactors(this.d);
            MultiplicativeSetTest.assertTrue((String)"1 == remove(a*b) ", (boolean)this.e.isConstant());
            if (!this.c.isConstant()) {
                this.e = ms3.removeFactors(this.c);
                MultiplicativeSetTest.assertTrue((String)"remove(c) | c ", (boolean)this.c.remainder(this.e).isZERO());
            }
        }
    }
}

